; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=arm-none-eabihf -mattr=+v7,+neon,+vfp4 | FileCheck %s --check-prefixes=CHECK-ARMV7
; RUN: llc < %s -mtriple=arm-none-eabihf -mattr=+v8,+neon,+fp-armv8 | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16
; RUN: llc < %s -mtriple=arm-none-eabihf -mattr=+v8,+neon,+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

define <4 x half> @frinta_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frinta_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frinta_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrinta.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrinta.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrinta.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrinta.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frinta_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrinta.f16 d0, d0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.round.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frinta_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frinta_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frinta_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrinta.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrinta.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrinta.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrinta.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrinta.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrinta.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrinta.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrinta.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frinta_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrinta.f16 q0, q0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.round.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frinta_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frinta_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frinta_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrinta.f32 d0, d0
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.round.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frinta_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frinta_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl roundf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frinta_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrinta.f32 q0, q0
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.round.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frinta_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frinta_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl round
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl round
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frinta_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrinta.f64 d17, d1
; CHECK-NEXT:    vrinta.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.round.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}


define <4 x half> @frinti_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frinti_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frinti_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrintr.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrintr.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrintr.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrintr.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frinti_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vmovx.f16 s2, s0
; CHECK-FP16-NEXT:    vrintr.f16 s2, s2
; CHECK-FP16-NEXT:    vmov r0, s2
; CHECK-FP16-NEXT:    vrintr.f16 s2, s0
; CHECK-FP16-NEXT:    vmov r1, s2
; CHECK-FP16-NEXT:    vrintr.f16 s2, s1
; CHECK-FP16-NEXT:    vmovx.f16 s0, s1
; CHECK-FP16-NEXT:    vrintr.f16 s0, s0
; CHECK-FP16-NEXT:    vmov.16 d16[0], r1
; CHECK-FP16-NEXT:    vmov.16 d16[1], r0
; CHECK-FP16-NEXT:    vmov r0, s2
; CHECK-FP16-NEXT:    vmov.16 d16[2], r0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    vmov.16 d16[3], r0
; CHECK-FP16-NEXT:    vorr d0, d16, d16
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.nearbyint.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frinti_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frinti_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frinti_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrintr.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrintr.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrintr.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrintr.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrintr.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrintr.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrintr.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrintr.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frinti_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vmovx.f16 s4, s2
; CHECK-FP16-NEXT:    vrintr.f16 s4, s4
; CHECK-FP16-NEXT:    vmov r0, s4
; CHECK-FP16-NEXT:    vrintr.f16 s4, s2
; CHECK-FP16-NEXT:    vmov r1, s4
; CHECK-FP16-NEXT:    vrintr.f16 s4, s3
; CHECK-FP16-NEXT:    vmov.16 d17[0], r1
; CHECK-FP16-NEXT:    vmov.16 d17[1], r0
; CHECK-FP16-NEXT:    vmov r0, s4
; CHECK-FP16-NEXT:    vmovx.f16 s4, s3
; CHECK-FP16-NEXT:    vrintr.f16 s4, s4
; CHECK-FP16-NEXT:    vmov.16 d17[2], r0
; CHECK-FP16-NEXT:    vmov r0, s4
; CHECK-FP16-NEXT:    vmovx.f16 s4, s0
; CHECK-FP16-NEXT:    vrintr.f16 s4, s4
; CHECK-FP16-NEXT:    vmov.16 d17[3], r0
; CHECK-FP16-NEXT:    vmov r0, s4
; CHECK-FP16-NEXT:    vrintr.f16 s4, s0
; CHECK-FP16-NEXT:    vmovx.f16 s0, s1
; CHECK-FP16-NEXT:    vmov r1, s4
; CHECK-FP16-NEXT:    vrintr.f16 s4, s1
; CHECK-FP16-NEXT:    vrintr.f16 s0, s0
; CHECK-FP16-NEXT:    vmov.16 d16[0], r1
; CHECK-FP16-NEXT:    vmov.16 d16[1], r0
; CHECK-FP16-NEXT:    vmov r0, s4
; CHECK-FP16-NEXT:    vmov.16 d16[2], r0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    vmov.16 d16[3], r0
; CHECK-FP16-NEXT:    vorr q0, q8, q8
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.nearbyint.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frinti_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frinti_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frinti_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintr.f32 s3, s1
; CHECK-NEXT:    vrintr.f32 s2, s0
; CHECK-NEXT:    vmov.f64 d0, d1
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.nearbyint.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frinti_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frinti_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl nearbyintf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frinti_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintr.f32 s7, s3
; CHECK-NEXT:    vrintr.f32 s6, s2
; CHECK-NEXT:    vrintr.f32 s5, s1
; CHECK-NEXT:    vrintr.f32 s4, s0
; CHECK-NEXT:    vorr q0, q1, q1
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frinti_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frinti_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl nearbyint
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl nearbyint
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frinti_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintr.f64 d17, d1
; CHECK-NEXT:    vrintr.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}


define <4 x half> @frintm_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintm_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frintm_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrintm.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrintm.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrintm.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrintm.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frintm_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintm.f16 d0, d0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.floor.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frintm_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintm_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frintm_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrintm.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrintm.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrintm.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrintm.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrintm.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrintm.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrintm.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrintm.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frintm_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintm.f16 q0, q0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.floor.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frintm_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintm_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintm_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintm.f32 d0, d0
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.floor.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frintm_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintm_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl floorf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintm_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintm.f32 q0, q0
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.floor.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frintm_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frintm_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl floor
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl floor
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintm_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintm.f64 d17, d1
; CHECK-NEXT:    vrintm.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.floor.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}


define <4 x half> @frintn_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintn_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frintn_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrintn.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrintn.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrintn.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrintn.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frintn_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintn.f16 d0, d0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.roundeven.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frintn_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintn_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frintn_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrintn.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrintn.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrintn.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrintn.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrintn.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrintn.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrintn.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrintn.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frintn_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintn.f16 q0, q0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.roundeven.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frintn_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintn_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintn_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintn.f32 d0, d0
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.roundeven.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frintn_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintn_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl roundevenf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintn_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintn.f32 q0, q0
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.roundeven.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frintn_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frintn_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl roundeven
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl roundeven
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintn_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintn.f64 d17, d1
; CHECK-NEXT:    vrintn.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.roundeven.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}


define <4 x half> @frintp_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintp_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frintp_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrintp.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrintp.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrintp.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrintp.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frintp_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintp.f16 d0, d0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.ceil.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frintp_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintp_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frintp_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrintp.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrintp.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrintp.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrintp.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrintp.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrintp.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrintp.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrintp.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frintp_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintp.f16 q0, q0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.ceil.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frintp_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintp_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintp_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintp.f32 d0, d0
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.ceil.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frintp_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintp_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl ceilf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintp_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintp.f32 q0, q0
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.ceil.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frintp_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frintp_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl ceil
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl ceil
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintp_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintp.f64 d17, d1
; CHECK-NEXT:    vrintp.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.ceil.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}


define <4 x half> @frintx_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintx_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frintx_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrintx.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrintx.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrintx.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrintx.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frintx_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintx.f16 d0, d0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.rint.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frintx_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintx_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frintx_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrintx.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrintx.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrintx.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrintx.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrintx.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrintx.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrintx.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrintx.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frintx_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintx.f16 q0, q0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.rint.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frintx_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintx_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintx_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintx.f32 d0, d0
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.rint.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frintx_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintx_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl rintf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintx_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintx.f32 q0, q0
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.rint.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frintx_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frintx_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl rint
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl rint
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintx_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintx.f64 d17, d1
; CHECK-NEXT:    vrintx.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.rint.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}


define <4 x half> @frintz_4h(<4 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintz_4h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, lr}
; CHECK-ARMV7-NEXT:    push {r4, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10}
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s1
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov d16, r0, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d16[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d16[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d16[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d16[3]
; CHECK-ARMV7-NEXT:    vmov s0, r0
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10}
; CHECK-ARMV7-NEXT:    pop {r4, pc}
;
; CHECK-NOFP16-LABEL: frintz_4h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s3
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NOFP16-NEXT:    vrintz.f32 s4, s4
; CHECK-NOFP16-NEXT:    vrintz.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vmov r0, s4
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s2, s1
; CHECK-NOFP16-NEXT:    vrintz.f32 s2, s2
; CHECK-NOFP16-NEXT:    vrintz.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s2
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov d16, r1, r0
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d16[3]
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    vmov s1, r1
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    bx lr
;
; CHECK-FP16-LABEL: frintz_4h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintz.f16 d0, d0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <4 x half> @llvm.trunc.v4f16(<4 x half> %A)
  ret <4 x half> %tmp3
}

define <8 x half> @frintz_8h(<8 x half> %A) nounwind {
; CHECK-ARMV7-LABEL: frintz_8h:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    push {r4, r5, r6, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    vmov.f32 s28, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s0, s7
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s6
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s5
; CHECK-ARMV7-NEXT:    vmov.f32 s20, s4
; CHECK-ARMV7-NEXT:    vmov.f32 s22, s3
; CHECK-ARMV7-NEXT:    vmov.f32 s24, s2
; CHECK-ARMV7-NEXT:    vmov.f32 s26, s1
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s2, s16
; CHECK-ARMV7-NEXT:    vmov r4, s0
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s24, s24
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s2
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s22, s22
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s20, s20
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s18, s18
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s28, s28
; CHECK-ARMV7-NEXT:    vcvtb.f32.f16 s26, s26
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s26
; CHECK-ARMV7-NEXT:    pkhbt r4, r0, r4, lsl #16
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r5, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s28
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s18
; CHECK-ARMV7-NEXT:    pkhbt r5, r0, r5, lsl #16
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s16, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov r0, s16
; CHECK-ARMV7-NEXT:    vmov r1, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-ARMV7-NEXT:    vmov.32 d8[0], r0
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d9[0], r5
; CHECK-ARMV7-NEXT:    vmov r6, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s24
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-ARMV7-NEXT:    vmov.32 d8[1], r4
; CHECK-ARMV7-NEXT:    vmov r0, s0
; CHECK-ARMV7-NEXT:    vmov.u16 r5, d8[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r4, d8[2]
; CHECK-ARMV7-NEXT:    pkhbt r0, r0, r6, lsl #16
; CHECK-ARMV7-NEXT:    vmov.u16 r6, d8[0]
; CHECK-ARMV7-NEXT:    vmov.32 d9[1], r0
; CHECK-ARMV7-NEXT:    vmov s5, r5
; CHECK-ARMV7-NEXT:    vmov.u16 r0, d8[3]
; CHECK-ARMV7-NEXT:    vmov s6, r4
; CHECK-ARMV7-NEXT:    vmov.u16 r12, d9[0]
; CHECK-ARMV7-NEXT:    vmov.u16 r1, d9[1]
; CHECK-ARMV7-NEXT:    vmov.u16 r2, d9[2]
; CHECK-ARMV7-NEXT:    vmov.u16 r3, d9[3]
; CHECK-ARMV7-NEXT:    vmov s4, r6
; CHECK-ARMV7-NEXT:    vmov s7, r0
; CHECK-ARMV7-NEXT:    vmov s0, r12
; CHECK-ARMV7-NEXT:    vmov s1, r1
; CHECK-ARMV7-NEXT:    vmov s2, r2
; CHECK-ARMV7-NEXT:    vmov s3, r3
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14}
; CHECK-ARMV7-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOFP16-LABEL: frintz_8h:
; CHECK-NOFP16:       @ %bb.0:
; CHECK-NOFP16-NEXT:    .save {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s8, s7
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s6
; CHECK-NOFP16-NEXT:    vrintz.f32 s8, s8
; CHECK-NOFP16-NEXT:    vrintz.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s8, s8
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vmov r0, s8
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s6, s1
; CHECK-NOFP16-NEXT:    vrintz.f32 s6, s6
; CHECK-NOFP16-NEXT:    vrintz.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s6, s6
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s5
; CHECK-NOFP16-NEXT:    vrintz.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s4, s4
; CHECK-NOFP16-NEXT:    vrintz.f32 s4, s4
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s4, s4
; CHECK-NOFP16-NEXT:    vmov r3, s4
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r0, lsl #16
; CHECK-NOFP16-NEXT:    vmov r1, s6
; CHECK-NOFP16-NEXT:    pkhbt r1, r2, r1, lsl #16
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s3
; CHECK-NOFP16-NEXT:    vrintz.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d17[0], r1
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    pkhbt r2, r3, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.32 d16[0], r2
; CHECK-NOFP16-NEXT:    vmov r2, s0
; CHECK-NOFP16-NEXT:    vcvtb.f32.f16 s0, s2
; CHECK-NOFP16-NEXT:    vrintz.f32 s0, s0
; CHECK-NOFP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NOFP16-NEXT:    vmov.32 d16[1], r0
; CHECK-NOFP16-NEXT:    vmov r1, s0
; CHECK-NOFP16-NEXT:    vmov.u16 r4, d16[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r5, d16[3]
; CHECK-NOFP16-NEXT:    pkhbt r0, r1, r2, lsl #16
; CHECK-NOFP16-NEXT:    vmov.u16 r1, d16[1]
; CHECK-NOFP16-NEXT:    vmov.32 d17[1], r0
; CHECK-NOFP16-NEXT:    vmov s6, r4
; CHECK-NOFP16-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NOFP16-NEXT:    vmov s7, r5
; CHECK-NOFP16-NEXT:    vmov.u16 r12, d17[0]
; CHECK-NOFP16-NEXT:    vmov.u16 lr, d17[1]
; CHECK-NOFP16-NEXT:    vmov.u16 r2, d17[2]
; CHECK-NOFP16-NEXT:    vmov.u16 r3, d17[3]
; CHECK-NOFP16-NEXT:    vmov s5, r1
; CHECK-NOFP16-NEXT:    vmov s4, r0
; CHECK-NOFP16-NEXT:    vmov s0, r12
; CHECK-NOFP16-NEXT:    vmov s1, lr
; CHECK-NOFP16-NEXT:    vmov s2, r2
; CHECK-NOFP16-NEXT:    vmov s3, r3
; CHECK-NOFP16-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-FP16-LABEL: frintz_8h:
; CHECK-FP16:       @ %bb.0:
; CHECK-FP16-NEXT:    vrintz.f16 q0, q0
; CHECK-FP16-NEXT:    bx lr
  %tmp3 = call <8 x half> @llvm.trunc.v8f16(<8 x half> %A)
  ret <8 x half> %tmp3
}

define <2 x float> @frintz_2s(<2 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintz_2s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9}
; CHECK-ARMV7-NEXT:    vpush {d8, d9}
; CHECK-ARMV7-NEXT:    vmov.f64 d8, d0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s17
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s16
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f64 d0, d9
; CHECK-ARMV7-NEXT:    vpop {d8, d9}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintz_2s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintz.f32 d0, d0
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x float> @llvm.trunc.v2f32(<2 x float> %A)
  ret <2 x float> %tmp3
}

define <4 x float> @frintz_4s(<4 x float> %A) nounwind {
; CHECK-ARMV7-LABEL: frintz_4s:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q5, q0, q0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s23
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vmov.f32 s19, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s22
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vmov.f32 s18, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s21
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vmov.f32 s17, s0
; CHECK-ARMV7-NEXT:    vmov.f32 s0, s20
; CHECK-ARMV7-NEXT:    bl truncf
; CHECK-ARMV7-NEXT:    vmov.f32 s16, s0
; CHECK-ARMV7-NEXT:    vorr q0, q4, q4
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintz_4s:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintz.f32 q0, q0
; CHECK-NEXT:    bx lr
  %tmp3 = call <4 x float> @llvm.trunc.v4f32(<4 x float> %A)
  ret <4 x float> %tmp3
}

define <2 x double> @frintz_2d(<2 x double> %A) nounwind {
; CHECK-ARMV7-LABEL: frintz_2d:
; CHECK-ARMV7:       @ %bb.0:
; CHECK-ARMV7-NEXT:    .save {r11, lr}
; CHECK-ARMV7-NEXT:    push {r11, lr}
; CHECK-ARMV7-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    vorr q4, q0, q0
; CHECK-ARMV7-NEXT:    vorr d0, d9, d9
; CHECK-ARMV7-NEXT:    bl trunc
; CHECK-ARMV7-NEXT:    vorr d11, d0, d0
; CHECK-ARMV7-NEXT:    vorr d0, d8, d8
; CHECK-ARMV7-NEXT:    bl trunc
; CHECK-ARMV7-NEXT:    vorr d10, d0, d0
; CHECK-ARMV7-NEXT:    vorr q0, q5, q5
; CHECK-ARMV7-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-ARMV7-NEXT:    pop {r11, pc}
;
; CHECK-LABEL: frintz_2d:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vrintz.f64 d17, d1
; CHECK-NEXT:    vrintz.f64 d16, d0
; CHECK-NEXT:    vorr q0, q8, q8
; CHECK-NEXT:    bx lr
  %tmp3 = call <2 x double> @llvm.trunc.v2f64(<2 x double> %A)
  ret <2 x double> %tmp3
}
