/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeoutCompletableFuture<T>
extends CompletableFuture<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeoutCompletableFuture.class);

    TimeoutCompletableFuture() {
    }

    public CompletableFuture<T> compatTimeout(long timeout, TimeUnit unit) {
        return TimeoutCompletableFuture.compatTimeout(this, timeout, unit);
    }

    public static <T> CompletableFuture<T> compatTimeout(CompletableFuture<T> f, long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            f.completeExceptionally(new TimeoutException("timeout is " + timeout + ", but must be > 0"));
        }
        ScheduledFuture<?> sf = TimeoutScheduler.executor.schedule(() -> {
            if (!f.isDone()) {
                f.completeExceptionally(new TimeoutException("Timeout of " + unit.toMillis(timeout) + "ms has elapsed before the task completed"));
            }
        }, timeout, unit);
        f.whenComplete((T result, U ex) -> {
            if (ex == null && !sf.isDone()) {
                sf.cancel(false);
            }
        });
        return f;
    }

    private static final class TimeoutScheduler {
        private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("dnsjava AsyncSemaphoreTimeoutScheduler");
            return t;
        });

        private TimeoutScheduler() {
        }

        static {
            executor.setRemoveOnCancelPolicy(true);
        }
    }
}

