/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPRegistryDescriptor;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerProvider;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDLabelValuePairExt;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVDataContext;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.model.virtual.DBVObject;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.registry.expressions.ExpressionNamespaceDescriptor;
import org.jkiss.dbeaver.registry.expressions.ExpressionRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DBVUtils {
    private static final Log log = Log.getLog(DBVUtils.class);
    private static final Map<String, DBVEntity> orphanVirtualEntities = new HashMap<String, DBVEntity>();

    @Nullable
    public static DBVTransformSettings getTransformSettings(@NotNull DBDAttributeBinding binding, boolean create) {
        DBVEntityAttribute vAttr;
        if (DBUtils.isDynamicAttribute(binding.getAttribute()) && (binding.getParentObject() == null || binding.getParentObject().getDataKind() != DBPDataKind.DOCUMENT)) {
            return null;
        }
        DBVEntity vEntity = DBVUtils.getVirtualEntity(binding, create);
        if (vEntity != null && (vAttr = vEntity.getVirtualAttribute(binding, create)) != null) {
            return DBVUtils.getTransformSettings(vAttr, create);
        }
        return null;
    }

    public static DBVEntity getVirtualEntity(@NotNull DBDAttributeBinding binding, boolean create) {
        DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
        DBVEntity vEntity = entityAttribute != null ? DBVUtils.getVirtualEntity(entityAttribute.getParentObject(), create) : DBVUtils.getVirtualEntity(binding.getDataContainer(), create);
        return vEntity;
    }

    @Nullable
    public static DBVEntity getVirtualEntity(@NotNull DBSEntity source, boolean create) {
        if (source instanceof DBVEntity) {
            return (DBVEntity)source;
        }
        DBPDataSource dataSource = source.getDataSource();
        return dataSource == null ? null : dataSource.getContainer().getVirtualModel().findEntity(source, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBVEntity getVirtualEntity(@NotNull DBSDataContainer dataContainer, boolean create) {
        DBSDataContainer nestedDC;
        if (dataContainer instanceof IAdaptable && (nestedDC = (DBSDataContainer)((IAdaptable)dataContainer).getAdapter(DBSDataContainer.class)) != null) {
            dataContainer = nestedDC;
        }
        if (dataContainer instanceof DBSEntity) {
            return DBVUtils.getVirtualEntity((DBSEntity)((Object)dataContainer), create);
        }
        String attrKey = DBUtils.getObjectFullId(dataContainer);
        Map<String, DBVEntity> map = orphanVirtualEntities;
        synchronized (map) {
            DBPDataSource dataSource = dataContainer.getDataSource();
            if (dataSource == null) {
                return null;
            }
            DBVEntity vEntity = orphanVirtualEntities.get(attrKey);
            if (vEntity == null && create) {
                vEntity = new DBVEntity((DBVContainer)dataSource.getContainer().getVirtualModel(), dataContainer.getName(), "");
                orphanVirtualEntities.put(attrKey, vEntity);
            }
            return vEntity;
        }
    }

    @Nullable
    public static DBVTransformSettings getTransformSettings(@NotNull DBVEntityAttribute attribute, boolean create) {
        if (attribute.getTransformSettings() != null) {
            return attribute.getTransformSettings();
        }
        if (create) {
            attribute.setTransformSettings(new DBVTransformSettings());
            return attribute.getTransformSettings();
        }
        for (DBVObject object = attribute.getParentObject(); object != null; object = ((DBVObject)object).getParentObject()) {
            if (object.getTransformSettings() == null) continue;
            return object.getTransformSettings();
        }
        return null;
    }

    @NotNull
    public static Map<String, Object> getAttributeTransformersOptions(@NotNull DBDAttributeBinding binding) {
        if (DBUtils.isDynamicAttribute(binding.getAttribute())) {
            return Collections.emptyMap();
        }
        Map<String, Object> options = null;
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings(binding, false);
        if (transformSettings != null) {
            options = transformSettings.getTransformOptions();
        }
        if (options != null) {
            return options;
        }
        return Collections.emptyMap();
    }

    @Nullable
    public static DBDAttributeTransformer[] findAttributeTransformers(@NotNull DBDAttributeBinding binding, @Nullable Boolean custom) {
        ArrayList<DBDAttributeTransformer> allTransformers = new ArrayList<DBDAttributeTransformer>();
        DBSDataContainer dBSDataContainer = binding.getDataContainer();
        if (dBSDataContainer instanceof DBDAttributeTransformerProvider) {
            DBDAttributeTransformerProvider dbdAttributeTransformerProvider = (DBDAttributeTransformerProvider)((Object)dBSDataContainer);
            List<DBDAttributeTransformer> inMemoryAddedTransformers = dbdAttributeTransformerProvider.findTransformerForBinding(binding);
            allTransformers.addAll(inMemoryAddedTransformers);
        }
        List<DBDAttributeTransformer> savedTransformers = DBVUtils.findBindingTransformers(binding, custom);
        allTransformers.addAll(savedTransformers);
        return allTransformers.isEmpty() ? null : (DBDAttributeTransformer[])allTransformers.toArray(DBDAttributeTransformer[]::new);
    }

    @NotNull
    public static List<DBDAttributeTransformer> findBindingTransformers(@NotNull DBDAttributeBinding binding, @Nullable Boolean custom) {
        DBPDataSource dataSource = binding.getDataSource();
        List<? extends DBDAttributeTransformerDescriptor> tdList = DBWorkbench.getPlatform().getValueHandlerRegistry().findTransformers(dataSource, binding.getAttribute(), custom);
        if (tdList == null || tdList.isEmpty()) {
            return List.of();
        }
        boolean filtered = false;
        DBVTransformSettings transformSettings = DBVUtils.getTransformSettings(binding, false);
        if (transformSettings != null) {
            filtered = transformSettings.filterTransformers(tdList);
        }
        if (!filtered) {
            int i = 0;
            while (i < tdList.size()) {
                if (tdList.get(i).isCustom() || !tdList.get(i).isApplicableByDefault()) {
                    tdList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (tdList.isEmpty()) {
            return List.of();
        }
        return tdList.stream().map(DBPRegistryDescriptor::getInstance).toList();
    }

    public static String getDictionaryDescriptionColumns(DBRProgressMonitor monitor, DBSEntityAttribute attribute) throws DBException {
        DBVEntity dictionary = DBVUtils.getVirtualEntity(attribute.getParentObject(), false);
        String descColumns = null;
        if (dictionary != null) {
            descColumns = dictionary.getDescriptionColumnNames();
        }
        if (descColumns == null) {
            descColumns = DBVEntity.getDefaultDescriptionColumn(monitor, attribute);
        }
        return descColumns;
    }

    @NotNull
    public static List<DBDLabelValuePair> readDictionaryRows(@NotNull DBCSession session, @NotNull List<DBSEntityAttribute> valueAttributes, @NotNull List<DBDValueHandler> valueHandlers, @NotNull DBCResultSet dbResult, boolean formatValues, boolean containsCount) throws DBCException {
        ArrayList<DBDLabelValuePair> values = new ArrayList<DBDLabelValuePair>();
        List<? extends DBCAttributeMetaData> metaColumns = dbResult.getMeta().getAttributes();
        ArrayList<DBDValueHandler> colHandlers = new ArrayList<DBDValueHandler>(metaColumns.size());
        for (DBCAttributeMetaData dBCAttributeMetaData : metaColumns) {
            colHandlers.add(DBUtils.findValueHandler(session, (DBSTypedObject)dBCAttributeMetaData));
        }
        boolean hasNulls = false;
        String string = session.getDataSource().getContainer().getPreferenceStore().getString("resultset.dictionary.columnDivider");
        while (dbResult.nextRow() && !session.getProgressMonitor().isCanceled()) {
            Object[] finalKeyValue;
            Object[] keyValues = new Object[valueAttributes.size()];
            for (int i = 0; i < valueAttributes.size(); ++i) {
                Object keyValue = valueHandlers.get(i).fetchValueObject(session, dbResult, valueAttributes.get(i), i);
                if (DBUtils.isNullValue(keyValue)) {
                    if (hasNulls) continue;
                    hasNulls = true;
                }
                if (formatValues && keyValue instanceof Date) {
                    keyValue = valueHandlers.get(i).getValueDisplayString(valueAttributes.get(i), keyValue, DBDDisplayFormat.UI);
                }
                keyValues[i] = keyValue;
            }
            long keyCount = 0L;
            StringBuilder keyLabel2 = new StringBuilder();
            for (int i = valueAttributes.size(); i < colHandlers.size(); ++i) {
                Object descValue = ((DBDValueHandler)colHandlers.get(i)).fetchValueObject(session, dbResult, metaColumns.get(i), i);
                if (containsCount && i == colHandlers.size() - 1) {
                    keyCount = CommonUtils.toLong((Object)descValue);
                    break;
                }
                if (!keyLabel2.isEmpty()) {
                    keyLabel2.append(string);
                }
                keyLabel2.append(((DBDValueHandler)colHandlers.get(i)).getValueDisplayString(metaColumns.get(i), descValue, formatValues ? DBDDisplayFormat.UI : DBDDisplayFormat.NATIVE));
            }
            String keyLabel = keyLabel2.toString();
            Object object = finalKeyValue = keyValues.length == 1 ? keyValues[0] : keyValues;
            if (containsCount && keyCount > 0L) {
                values.add(new DBDLabelValuePairExt(keyLabel, finalKeyValue, keyCount));
                continue;
            }
            values.add(new DBDLabelValuePair(keyLabel, finalKeyValue));
        }
        return values;
    }

    @NotNull
    public static List<DBVEntityAttribute> getCustomAttributes(@NotNull DBSEntity entity) {
        DBVEntity vEntity = DBVUtils.getVirtualEntity(entity, false);
        if (vEntity != null) {
            return vEntity.getCustomAttributes();
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<DBSEntityAttribute> getAllAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        List<DBVEntityAttribute> vAttributes;
        DBVEntity vEntity;
        ArrayList<DBSEntityAttribute> result = new ArrayList<DBSEntityAttribute>();
        List<? extends DBSEntityAttribute> realAttributes = entity.getAttributes(monitor);
        if (!CommonUtils.isEmpty(realAttributes)) {
            result.addAll(realAttributes);
        }
        if ((vEntity = DBVUtils.getVirtualEntity(entity, false)) != null && !CommonUtils.isEmpty(vAttributes = vEntity.getEntityAttributes())) {
            for (DBVEntityAttribute attr : vAttributes) {
                if (!attr.isCustom()) continue;
                result.add(attr);
            }
        }
        return result;
    }

    @NotNull
    public static List<DBSEntityConstraint> getAllConstraints(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        List<DBVEntityConstraint> vConstraints;
        DBVEntity vEntity;
        ArrayList<DBSEntityConstraint> result = new ArrayList<DBSEntityConstraint>();
        Collection<? extends DBSEntityConstraint> realConstraints = entity.getConstraints(monitor);
        if (!CommonUtils.isEmpty(realConstraints)) {
            result.addAll(realConstraints);
        }
        if ((vEntity = DBVUtils.getVirtualEntity(entity, false)) != null && !CommonUtils.isEmpty(vConstraints = vEntity.getConstraints())) {
            result.addAll(vConstraints);
        }
        return result;
    }

    @NotNull
    public static List<DBSEntityAssociation> getAllAssociations(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        List<DBVEntityForeignKey> vFKs;
        DBVEntity vEntity;
        ArrayList<DBSEntityAssociation> result = new ArrayList<DBSEntityAssociation>();
        Collection<? extends DBSEntityAssociation> realConstraints = entity.getAssociations(monitor);
        if (!CommonUtils.isEmpty(realConstraints)) {
            result.addAll(realConstraints);
        }
        if (!(entity instanceof DBVEntity) && (vEntity = DBVUtils.getVirtualEntity(entity, false)) != null && !CommonUtils.isEmpty(vFKs = vEntity.getForeignKeys())) {
            result.addAll(vFKs);
        }
        return result;
    }

    @NotNull
    public static List<DBSEntityAssociation> getAllReferences(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity onEntity) {
        ArrayList<DBSEntityAssociation> result = new ArrayList<DBSEntityAssociation>();
        try {
            Collection<? extends DBSEntityAssociation> realConstraints = onEntity.getReferences(monitor);
            if (!CommonUtils.isEmpty(realConstraints)) {
                result.addAll(realConstraints);
            }
        }
        catch (DBException e) {
            log.debug("Error reading entity references", e);
        }
        result.addAll(DBVUtils.getVirtualReferences(onEntity));
        return result;
    }

    @NotNull
    public static List<DBVEntityForeignKey> getVirtualReferences(@NotNull DBSEntity onEntity) {
        List<DBVEntityForeignKey> globalRefs;
        DBNDatabaseNode entityNode = DBNUtils.getNodeByObject(onEntity);
        if (entityNode != null && !CommonUtils.isEmpty(globalRefs = DBVModel.getGlobalReferences(entityNode))) {
            return globalRefs;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static DBSEntity getRealEntity(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        if (entity instanceof DBVEntity) {
            DBSEntity realEntity = ((DBVEntity)entity).getRealEntity(monitor);
            if (realEntity == null) {
                throw new DBException("Can't locate real entity for " + DBUtils.getObjectFullId(entity));
            }
            return realEntity;
        }
        return entity;
    }

    @NotNull
    public static DBSEntity tryGetRealEntity(@NotNull DBSEntity entity) {
        if (entity instanceof DBVEntity) {
            DBVEntity vEntity = (DBVEntity)entity;
            try {
                DBSEntity realEntity = vEntity.getRealEntity(new VoidProgressMonitor());
                if (realEntity != null) {
                    return realEntity;
                }
            }
            catch (DBException e) {
                log.error("Can't get real entity from virtual entity", e);
            }
        }
        return entity;
    }

    public static DBVObject getVirtualObject(DBSObject source, boolean create) {
        if (source == null) {
            return null;
        }
        if (source instanceof DBVObject) {
            DBVObject vObject = (DBVObject)source;
            return vObject;
        }
        DBPDataSource dataSource = source.getDataSource();
        return dataSource == null ? null : dataSource.getContainer().getVirtualModel().findObject(source, create);
    }

    public static Object executeExpression(DBVEntityAttribute attribute, DBDAttributeBinding[] allAttributes, Object[] row) {
        String exprString = attribute.getExpression();
        if (CommonUtils.isEmpty((String)exprString)) {
            return null;
        }
        JexlExpression expression = attribute.getParsedExpression();
        if (expression == null) {
            return null;
        }
        DBVEntity entity = attribute.getEntity();
        DBSEntity dataContainer = null;
        try {
            dataContainer = entity.getRealEntity(new VoidProgressMonitor());
        }
        catch (DBException e) {
            log.debug(e);
        }
        if (dataContainer == null) {
            dataContainer = entity;
        }
        return DBVUtils.evaluateDataExpression(dataContainer, allAttributes, row, expression, attribute.getName());
    }

    public static Object evaluateDataExpression(@NotNull DBSObject dataContainer, @NotNull DBDAttributeBinding[] allAttributes, @NotNull Object[] row, @NotNull JexlExpression expression, @Nullable String attributeName) {
        try {
            return expression.evaluate((JexlContext)new DBVDataContext(dataContainer, allAttributes, row, attributeName));
        }
        catch (Exception e) {
            return GeneralUtils.getExpressionParseMessage(e);
        }
    }

    @NotNull
    static Map<String, Object> getExpressionNamespaces() {
        HashMap<String, Object> nsList = new HashMap<String, Object>();
        for (ExpressionNamespaceDescriptor ns : ExpressionRegistry.getInstance().getExpressionNamespaces()) {
            Class<?> implClass = ns.getImplClass();
            if (implClass == null) continue;
            nsList.put(ns.getId(), implClass);
        }
        return nsList;
    }

    public static JexlExpression parseExpression(String expression) {
        Map<String, Object> nsList = DBVUtils.getExpressionNamespaces();
        JexlBuilder jexlBuilder = new JexlBuilder();
        jexlBuilder.cache(100);
        jexlBuilder.namespaces(nsList);
        JexlEngine jexlEngine = jexlBuilder.create();
        return jexlEngine.createExpression(expression);
    }

    public static boolean isIdentifyingAttributes(@NotNull DBRProgressMonitor monitor, @NotNull List<DBSEntityAttribute> attributes) throws DBException {
        if (attributes.isEmpty()) {
            return false;
        }
        DBSEntity table = attributes.getFirst().getParentObject();
        List<DBSEntityConstraint> constraints = DBVUtils.getAllConstraints(monitor, table);
        for (DBSEntityConstraint constraint : constraints) {
            List<? extends DBSEntityAttributeRef> attrRefs;
            if (!DBUtils.isIdentifierConstraint(monitor, constraint) || (attrRefs = ((DBSEntityReferrer)constraint).getAttributeReferences(monitor)) == null || attributes.size() != attrRefs.size()) continue;
            boolean matches = true;
            for (int i = 0; i < attributes.size(); ++i) {
                if (attributes.get(i) == attrRefs.get(i).getAttribute()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }
}

