/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class CubridSQLDialect
extends GenericSQLDialect {
    public static final String CUBRID_DIALECT_ID = "cubrid";
    private static final String PROP_SHARD_TYPE = "shardType";
    private static final String PROP_SHARD_VALUE = "shardValue";
    private static final String PROP_IS_SHARD = "isShard";
    private static final String SHARD_TYPE_ID = "SHARD ID";
    private static final String DEFAULT_SHARD_VALUE = "0";
    private static final Log log = Log.getLog(CubridSQLDialect.class);
    private boolean isShard = false;
    private static final String[] CUBRID_KEYWORD = new String[]{"BIT", "CONNECT_BY_ISCYCLE", "CONNECT_BY_ISLEAF", "CONNECT_BY_ROOT", "CURRENT_DATE", "CURRENT_DATETIME", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DATA_TYPE", "DATABASE", "DATETIME", "DAY_HOUR", "DAY_MILLISECOND", "DAY_MINUTE", "DAY_SECOND", "DISTINCTROW", "DIV", "DO", "DUPLICATE", "HOUR_MILLISECOND", "HOUR_MINUTE", "HOUR_SECOND", "LOCAL_TRANSACTION_ID", "MILLISECOND", "MINUTE_MILLISECOND", "MINUTE_SECOND", "MODULE", "NAMES", "NCHAR", "ROWNUM", "SECOND_MILLISECOND", "SIBLINGS", "SQLCODE", "SQLERROR", "STATISTICS", "SYS_CONNECT_BY_PATH", "SYSDATE", "SYSDATETIME", "SYSTIME", "TRUNCATE", "VALUE", "XOR", "YEAR_MONTH"};
    private static final String[] REMOVE_KEYWORD = new String[]{"ALIAS", "ALWAYS", "ARRAY", "ASENSITIVE", "ASSIGNMENT", "ASYMMETRIC", "ATOMIC", "AUTHORIZATION", "BINARY", "CALLED", "CARDINALITY", "CHAIN", "CHARACTERISTICS", "CLUSTER", "COLLECT", "COMPLETION", "CONDITION", "CONSTRUCTOR", "CONTAINS", "CORR", "COVAR_POP", "COVAR_SAMP", "CUBE", "CUME_DIST", "CURSOR_NAME", "DATA_TYPE___", "DEFINED", "DEFINER", "DENSE_RANK", "DEREF", "DERIVED", "DETERMINISTIC", "DICTIONARY", "DISPATCH", "DYNAMIC", "ELEMENT", "END-EXEC", "EVERY", "EXCLUDE", "EXCLUDING", "FILTER", "FINAL", "FOLLOWING", "FREE", "FUSION", "GENERATED", "GRANTED", "GROUPING", "HIERARCHY", "HOLD", "IMPLEMENTATION", "INCLUDING", "INCREMENT", "INSENSITIVE", "INSTANCE", "INSTANTIABLE", "INVOKER", "KEY_TYPE", "LAST_DAY", "LATERAL", "LDB", "LN", "LOCATOR", "LPAD", "MAP", "MATCHED", "MAXVALUE", "MEMBER", "MODIFIES", "MORE", "MUMPS", "NESTING", "NEW", "NOMAXVALUE", "NOMINVALUE", "NORMALIZE", "NORMALIZED", "NULLS", "OLD", "OPERATION", "OPERATORS", "OPTIONS", "ORDERING", "ORDINALITY", "OTHERS", "OVERLAY", "OVERRIDING", "PARAMETER", "PATH", "PENDANT", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "PLACING", "PRECEDING", "PREORDER", "PRIVATE", "PROTECTED", "PROXY", "QUALIFY", "READS", "REGISTER", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "RELEASE", "REPEATABLE", "RESTART", "RESULT", "ROW_NUMBER", "RTRIM", "SCALE", "SCOPE___", "SECURITY", "SELF", "SERIAL", "SOURCE", "SPECIFIC", "SPECIFICTYPE", "STDDEV", "STRUCTURE", "STYLE", "SUBMULTISET", "SYMMETRIC", "SYSTEM", "TABLESAMPLE", "TATISTICS", "TEST", "THERE", "TIES", "TRANSFORM", "TRANSFORMS", "TREAT", "TYPE", "UESCAPE", "UNBOUNDED", "UNNAMED", "UNNEST", "VARBINARY", "VARIANCE", "VIRTUAL", "VISIBLE", "WAIT", "WIDTH_BUCKET", "WINDOW", "WITHIN"};

    public CubridSQLDialect() {
        super("Cubrid", CUBRID_DIALECT_ID);
    }

    public void initDriverSettings(@NotNull JDBCSession session, @NotNull JDBCDataSource dataSource, @NotNull JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        CubridDataSource source = (CubridDataSource)dataSource;
        this.detectAndApplyShardSettings(session, source);
        source.setSupportMultiSchema(this.isSupportMultiSchema(session));
        source.setEOLVersion(this.isEOLVersion(session));
        for (String removeKeyWord : REMOVE_KEYWORD) {
            this.removeSQLKeyword(removeKeyWord);
        }
        this.addSQLKeywords(Arrays.asList(CUBRID_KEYWORD));
    }

    @NotNull
    public boolean isSupportMultiSchema(@NotNull JDBCSession session) {
        try {
            int major = session.getMetaData().getDatabaseMajorVersion();
            int minor = session.getMetaData().getDatabaseMinorVersion();
            if (major > 11 || major == 11 && minor >= 2) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Can't get database version", (Throwable)e);
        }
        return false;
    }

    @NotNull
    public boolean isEOLVersion(@NotNull JDBCSession session) {
        try {
            int major = session.getMetaData().getDatabaseMajorVersion();
            if (major <= 9) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Can't get database version", (Throwable)e);
        }
        return false;
    }

    @NotNull
    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    public boolean supportsAlterTableStatement() {
        return !this.isShard;
    }

    private void detectAndApplyShardSettings(JDBCSession session, CubridDataSource source) {
        try {
            Connection conn = session.getExecutionContext().getConnection(session.getProgressMonitor());
            this.isShard = (Boolean)BeanUtils.invokeObjectMethod((Object)conn, (String)PROP_IS_SHARD);
            DBPConnectionConfiguration connectionInfo = source.getContainer().getConnectionConfiguration();
            connectionInfo.setProperty(PROP_IS_SHARD, Boolean.toString(this.isShard));
            source.setShard(this.isShard);
            if (this.isShard) {
                String shardType = connectionInfo.getProperty(PROP_SHARD_TYPE);
                String shardValue = connectionInfo.getProperty(PROP_SHARD_VALUE);
                if (CommonUtils.isEmpty((String)shardType)) {
                    connectionInfo.setProperty(PROP_SHARD_TYPE, SHARD_TYPE_ID);
                    connectionInfo.setProperty(PROP_SHARD_VALUE, DEFAULT_SHARD_VALUE);
                } else {
                    source.setShardType(shardType);
                    source.setShardVal(shardValue);
                }
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Failed to get connection:", (Throwable)e);
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to invoke isShard method:", e);
        }
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if ("VARCHAR".equalsIgnoreCase(typeName)) {
            return "(" + column.getMaxLength() + ")";
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }
}

