/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.charts;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.swt.ChartComposite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.charts.internal.UIChartsMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class BaseChartComposite
extends ChartComposite {
    public BaseChartComposite(Composite parent, int style, Point preferredSize) {
        super(parent, style, null, preferredSize.x, preferredSize.y, 30, 20, 10000, 10000, true, false, true, true, true, true);
    }

    public Canvas getChartCanvas() {
        Control[] children = this.getChildren();
        return children.length == 0 ? null : (Canvas)children[0];
    }

    @Override
    public void mouseDoubleClick(MouseEvent event) {
        if (this.showChartConfigDialog()) {
            this.forceRedraw();
        }
    }

    @Override
    protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this::fillContextMenu);
        Menu contextMenu = manager.createContextMenu((Control)this);
        this.addDisposeListener(e -> manager.dispose());
        return contextMenu;
    }

    protected void fillContextMenu(IMenuManager manager) {
        final Zoomable zoomable = (Zoomable)GeneralUtils.adapt((Object)this.getChart().getPlot(), Zoomable.class);
        if (zoomable != null) {
            manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_zoom_in, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_IN)){

                public void runWithEvent(Event e) {
                    BaseChartComposite.this.doZoom(zoomable, BaseChartComposite.this.getChartCanvas().toControl(BaseChartComposite.this.getDisplay().getCursorLocation()), BaseChartComposite.this.getZoomInFactor());
                }
            });
            manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_zoom_out, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_OUT)){

                public void runWithEvent(Event e) {
                    BaseChartComposite.this.doZoom(zoomable, BaseChartComposite.this.getChartCanvas().toControl(BaseChartComposite.this.getDisplay().getCursorLocation()), BaseChartComposite.this.getZoomOutFactor());
                }
            });
            manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_zoom_reset, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM)){

                public void runWithEvent(Event e) {
                    BaseChartComposite.this.restoreAutoBounds();
                }
            });
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_copy_to_clipboard){

            public void runWithEvent(Event event) {
                BaseChartComposite.this.doCopyToClipboard();
            }
        });
        manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_save_as){

            public void run() {
                try {
                    BaseChartComposite.this.doSaveAs();
                }
                catch (IOException e) {
                    DBWorkbench.getPlatformUI().showError(UIChartsMessages.base_chart_composite_error_title_save_image, UIChartsMessages.base_chart_composite_error_message_error_saving_chart_image, (Throwable)e);
                }
            }
        });
        manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_print){

            public void run() {
                BaseChartComposite.this.createChartPrintJob();
            }
        });
        if (this.hasConfigurationDialog()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_settings, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION)){

                public void run() {
                    BaseChartComposite.this.showChartConfigDialog();
                }
            });
        }
        if (this.hasColorsConfiguration()) {
            manager.add((IAction)new Action(UIChartsMessages.base_chart_composite_action_colors, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PALETTE)){

                public void run() {
                    PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)BaseChartComposite.this.getShell(), (String)"colorsAndFontsPreferencePage", null, null);
                    if (preferenceDialog != null) {
                        preferenceDialog.open();
                    }
                }
            });
        }
    }

    private void doZoom(@NotNull Zoomable zoomable, @NotNull Point origin, double factor) {
        PlotRenderingInfo info = this.getChartRenderingInfo().getPlotInfo();
        Point2D anchor = this.translateScreenToJava2D(new java.awt.Point(origin.x, origin.y));
        if (zoomable.isDomainZoomable()) {
            zoomable.zoomDomainAxes(factor, info, anchor, true);
        }
        if (zoomable.isRangeZoomable()) {
            zoomable.zoomRangeAxes(factor, info, anchor, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCopyToClipboard() {
        Image image = new Image((Device)Display.getDefault(), this.getBounds());
        try {
            GC gc = new GC((Drawable)image);
            try {
                this.print(gc);
            }
            finally {
                gc.dispose();
            }
            ImageTransfer imageTransfer = ImageTransfer.getInstance();
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{imageTransfer});
        }
        finally {
            image.dispose();
        }
    }

    protected boolean hasConfigurationDialog() {
        return true;
    }

    protected boolean showChartConfigDialog() {
        return false;
    }

    protected boolean hasColorsConfiguration() {
        return false;
    }
}

