/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;

public class SQLPresentationRegistry {
    static final String TAG_PRESENTATION = "presentation";
    private static SQLPresentationRegistry instance = null;
    private final List<SQLPresentationDescriptor> presentations = new ArrayList<SQLPresentationDescriptor>();

    public static synchronized SQLPresentationRegistry getInstance() {
        if (instance == null) {
            instance = new SQLPresentationRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLPresentationRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement ext : extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlPresentation")) {
            if (!TAG_PRESENTATION.equals(ext.getName())) continue;
            SQLPresentationDescriptor presentationDescriptor = new SQLPresentationDescriptor(ext);
            this.presentations.add(presentationDescriptor);
        }
        this.presentations.sort(Comparator.comparingInt(SQLPresentationDescriptor::getOrder).thenComparing(SQLPresentationDescriptor::getLabel));
    }

    public void dispose() {
        this.presentations.clear();
    }

    public List<SQLPresentationDescriptor> getPresentations() {
        return new ArrayList<SQLPresentationDescriptor>(this.presentations);
    }

    @Nullable
    public SQLPresentationDescriptor getPresentation(@NotNull String id) {
        for (SQLPresentationDescriptor presentation : this.presentations) {
            if (!presentation.getId().equals(id)) continue;
            return presentation;
        }
        return null;
    }
}

