/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorHandlerOpenDefaultSwitch
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(SQLEditorHandlerOpenDefaultSwitch.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String editorCommand = event.getParameter("command");
        if (editorCommand == null) {
            log.error((Object)"No command for default SQL editor handler");
            return null;
        }
        DBWorkbench.getPlatform().getPreferenceStore().setValue("SQLEditor.defaultOpenCommand", editorCommand);
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String commandId = CommonUtils.toString(parameters.get("command"));
        if (CommonUtils.isEmpty((String)commandId)) {
            return;
        }
        String commandName = ActionUtils.findCommandName((String)commandId);
        if (CommonUtils.isEmpty((String)commandName)) {
            return;
        }
        element.setText(commandName);
        String defCommand = DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.defaultOpenCommand");
        element.setChecked(CommonUtils.equalObjects((Object)defCommand, (Object)commandId));
    }
}

