/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.backup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Statement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.IOUtils;

public class JDBCDatabaseH2BackupHandler
implements JDBCDatabaseBackupHandler {
    private static final Log log = Log.getLog(JDBCDatabaseH2BackupHandler.class);

    public void doBackup(@NotNull Connection connection, int currentSchemaVersion, @NotNull InternalDatabaseConfig databaseConfig) throws DBException, IOException {
        Path workspace = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath().resolve("backup");
        if (!IOUtils.isFileFromDefaultFS((Path)workspace)) {
            log.warn((Object)"Backup to an external workspace is not supported");
            return;
        }
        Path backupFile = workspace.resolve("backup_version_" + currentSchemaVersion + ".zip");
        try (Statement statement = connection.createStatement();){
            if (Files.notExists(backupFile, new LinkOption[0])) {
                Files.createDirectories(workspace, new FileAttribute[0]);
                String backupCommand = "BACKUP TO '" + String.valueOf(backupFile) + "'";
                statement.execute(backupCommand);
                log.info((Object)("Reserve backup created to path: " + String.valueOf(workspace) + "backup"));
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(backupFile);
            log.error((Object)("Create backup is failed: " + e.getMessage()));
            throw new DBException("Backup is failed: " + e.getMessage());
        }
    }
}

