/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.itemlist;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.ObjectPropertyTester;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerFilterConfig;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateNew;
import org.jkiss.dbeaver.ui.navigator.itemlist.NodeListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.properties.PropertyEditorUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ItemListControl
extends NodeListControl {
    private static final Log log = Log.getLog(ItemListControl.class);
    private static final String COLOR_NEW = "org.jkiss.dbeaver.ui.navigator.node.new.background";
    private static final String COLOR_MODIFIED = "org.jkiss.dbeaver.ui.navigator.node.modified.background";
    private final ISearchExecutor searcher;
    private final Color searchHighlightColor;
    private final Map<DBNNode, Map<String, Object>> changedProperties = new HashMap<DBNNode, Map<String, Object>>();
    private CommandContributionItem createObjectCommand;

    public ItemListControl(@NotNull Composite parent, int style, @NotNull IWorkbenchSite workbenchSite, @NotNull DBNNode node, @Nullable DBXTreeNode metaNode) {
        super(parent, style, workbenchSite, node, metaNode);
        BaseThemeSettings.instance.addPropertyListener("org.eclipse.ui.workbench.TREE_TABLE_FONT", s -> super.getItemsViewer().refresh(), (Control)this);
        this.searcher = new ObjectListControl.SearcherFilter(this);
        this.searchHighlightColor = new Color((Device)parent.getDisplay(), 170, 255, 170);
    }

    @Override
    protected NodeListControl.NodeSelectionProvider createSelectionProvider(ISelectionProvider selectionProvider) {
        return new NodeListControl.NodeSelectionProvider(selectionProvider){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                DBNNode selectedNode;
                boolean isEnabled;
                super.selectionChanged(event);
                if (ItemListControl.this.createObjectCommand != null && (isEnabled = ObjectPropertyTester.canCreateObject(selectedNode = NavigatorUtils.getSelectedNode(event.getSelection()), true)) != ItemListControl.this.createObjectCommand.isVisible()) {
                    ItemListControl.this.createObjectCommand.setVisible(isEnabled);
                    IContributionManager toolbarManager = ItemListControl.this.createObjectCommand.getParent();
                    if (toolbarManager != null) {
                        toolbarManager.update(true);
                    }
                }
            }
        };
    }

    public void fillCustomActions(IContributionManager contributionManager) {
        DBNDatabaseNode dbNode;
        List<DBXTreeNode> inlineMetas;
        MultiPageEditorSite mes;
        MultiPageEditorPart editor;
        final IWorkbenchSite workbenchSite = this.getWorkbenchSite();
        if (workbenchSite instanceof MultiPageEditorSite && (editor = (mes = (MultiPageEditorSite)workbenchSite).getMultiPageEditor()) instanceof EntityEditor) {
            DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)workbenchSite, (IContributionManager)contributionManager);
        }
        super.fillCustomActions(contributionManager);
        final DBNNode rootNode = this.getRootNode();
        if (rootNode instanceof DBNDatabaseFolder) {
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.open"));
            if (ObjectPropertyTester.canCreateObject(rootNode, true)) {
                this.createObjectCommand = ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.create");
                contributionManager.add((IContributionItem)this.createObjectCommand);
            } else if (ObjectPropertyTester.canCreateObject(rootNode, false)) {
                contributionManager.add((IAction)new Action(this, null, 4){
                    {
                        super(arg0, arg1);
                        this.setActionDefinitionId("org.jkiss.dbeaver.core.object.create");
                    }

                    public void run() {
                        super.run();
                    }

                    public IMenuCreator getMenuCreator() {
                        return new MenuCreator(control -> {
                            List<IContributionItem> items = NavigatorHandlerObjectCreateNew.fillCreateMenuItems((IWorkbenchPartSite)workbenchSite, rootNode);
                            MenuManager menuManager = new MenuManager();
                            for (IContributionItem cc : items) {
                                menuManager.add(cc);
                            }
                            return menuManager;
                        });
                    }
                });
            }
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.delete"));
        }
        if (rootNode instanceof DBNDatabaseNode && rootNode.isPersisted()) {
            boolean hasReorder = false;
            List childrenTypes = ((DBNDatabaseNode)rootNode).getChildrenTypes(null);
            for (Class childType : childrenTypes) {
                if (DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(childType, DBEObjectReorderer.class) == null) continue;
                hasReorder = true;
                break;
            }
            if (hasReorder) {
                contributionManager.add((IContributionItem)new Separator());
                contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.move.top"));
                contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.move.up"));
                contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.move.down"));
                contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.jkiss.dbeaver.core.object.move.bottom"));
            }
        }
        if (rootNode instanceof DBNDatabaseNode && !(inlineMetas = ItemListControl.collectInlineMetas((DBNDatabaseNode)rootNode, ((DBNDatabaseNode)rootNode).getMeta())).isEmpty()) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.navigate.collapseAll", null, (DBPImage)UIIcon.TREE_COLLAPSE_ALL));
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)workbenchSite, (String)"org.eclipse.ui.navigate.expandAll", null, (DBPImage)UIIcon.TREE_EXPAND_ALL));
        }
        contributionManager.add((IContributionItem)new Separator());
        if (rootNode instanceof DBNDatabaseNode && (dbNode = (DBNDatabaseNode)rootNode).getItemsMeta() != null) {
            contributionManager.add((IAction)new Action(UINavigatorMessages.obj_editor_properties_control_action_filter_setting, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.FILTER)){

                public void run() {
                    NavigatorHandlerFilterConfig.configureFilters(ItemListControl.this.getShell(), dbNode);
                }
            });
        }
        this.addColumnConfigAction(contributionManager);
    }

    @Override
    public void disposeControl() {
        UIUtils.dispose((Resource)this.searchHighlightColor);
        super.disposeControl();
    }

    @Override
    protected void setListData(Collection<DBNNode> items, boolean append, boolean forUpdate) {
        if (!append && !forUpdate) {
            this.changedProperties.clear();
        }
        super.setListData(items, append, forUpdate);
    }

    protected ISearchExecutor getSearchRunner() {
        return this.searcher;
    }

    @Override
    protected LoadingJob<Collection<DBNNode>> createLoadService(boolean forUpdate) {
        return LoadingJob.createService((ILoadService)new ItemLoadService(this.getNodeMeta()), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer(this, forUpdate));
    }

    @Override
    protected EditingSupport makeEditingSupport(ObjectListControl.ObjectColumn objectColumn) {
        return new CellEditingSupport(objectColumn);
    }

    @Override
    protected CellLabelProvider getColumnLabelProvider(ObjectListControl.ObjectColumn objectColumn) {
        return new ItemColorProvider(objectColumn);
    }

    private class ItemLoadService
    extends DatabaseLoadService<Collection<DBNNode>> {
        private final DBXTreeNode metaNode;

        ItemLoadService(DBXTreeNode metaNode) {
            super(ModelMessages.model_navigator_load_.trim() + ": " + ItemListControl.this.getRootNode().getNodeDisplayName(), ItemListControl.this.getRootNode() instanceof DBSWrapper ? (DBSWrapper)ItemListControl.this.getRootNode() : null);
            this.metaNode = metaNode;
        }

        public Collection<DBNNode> evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException {
            try {
                DBSObject parentObject;
                ArrayList<DBNNode> items = new ArrayList<DBNNode>();
                DBNNode parentNode = ItemListControl.this.getRootNode();
                Object[] children = DBNUtils.getNodeChildrenFiltered((DBRProgressMonitor)monitor, (DBNNode)parentNode, (boolean)false);
                if (ArrayUtils.isEmpty((Object[])children)) {
                    return items;
                }
                DBPDataSourceContainer ds = ItemListControl.this.getDataSourceContainer();
                if (ds != null && ds.getNavigatorSettings().isHideFolders()) {
                    ArrayList<Object> filteredChildrenList = new ArrayList<Object>();
                    Object[] objectArray = children;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        DBXTreeNode meta;
                        Object child = objectArray[i];
                        if (!(child instanceof DBNDatabaseNode) || (meta = ((DBNDatabaseNode)child).getMeta()).getParent() != this.metaNode && meta != this.metaNode) continue;
                        filteredChildrenList.add(child);
                    }
                    children = filteredChildrenList.toArray(new DBNNode[0]);
                }
                while (parentNode instanceof DBNDatabaseFolder) {
                    parentNode = parentNode.getParentNode();
                }
                if (parentNode instanceof DBNDatabaseNode && (parentObject = DBUtils.getPublicObject((DBSObject)((DBNDatabaseNode)parentNode).getObject())) instanceof DBPObjectStatisticsCollector) {
                    try {
                        if (!((DBPObjectStatisticsCollector)parentObject).isStatisticsCollected()) {
                            ((DBPObjectStatisticsCollector)parentObject).collectObjectStatistics(monitor, false, false);
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)("Error reading statistics of '" + parentObject.getName() + "'"), (Throwable)e);
                    }
                }
                for (Object item : children) {
                    DBNDatabaseNode dbNode;
                    if (monitor.isCanceled()) break;
                    if (this.metaNode != null && (!(item instanceof DBNDatabaseNode) || (dbNode = (DBNDatabaseNode)item).getMeta() != this.metaNode && !dbNode.getDataSourceContainer().getNavigatorSettings().isHideFolders())) continue;
                    items.add((DBNNode)item);
                }
                return items;
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }
    }

    private class CellEditingSupport
    extends EditingSupport {
        private final ObjectListControl.ObjectColumn objectColumn;

        public CellEditingSupport(ObjectListControl.ObjectColumn objectColumn) {
            super(ItemListControl.this.getItemsViewer());
            this.objectColumn = objectColumn;
        }

        protected CellEditor getCellEditor(Object element) {
            DBNNode object = (DBNNode)element;
            ItemListControl.this.setCurListObject(object);
            ObjectPropertyDescriptor property = this.objectColumn.getProperty(ItemListControl.this.getObjectValue(object));
            if (property != null && property.isEditable(ItemListControl.this.getObjectValue(object))) {
                ItemListControl.this.setFocusCell(object, this.objectColumn);
                return PropertyEditorUtils.createPropertyEditor((IServiceLocator)ItemListControl.this.getWorkbenchSite(), (Composite)ItemListControl.this.getControl(), (DBPPropertySource)property.getSource(), (DBPPropertyDescriptor)property, (int)0);
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            DBNNode object = (DBNNode)element;
            if (DBNUtils.isReadOnly((DBNNode)object)) {
                return false;
            }
            ObjectPropertyDescriptor property = this.objectColumn.getProperty(ItemListControl.this.getObjectValue(object));
            return property != null && property.isEditable(ItemListControl.this.getObjectValue(object));
        }

        protected Object getValue(Object element) {
            DBNNode object = (DBNNode)element;
            Object objectValue = ItemListControl.this.getObjectValue(object);
            ObjectPropertyDescriptor property = this.objectColumn.getProperty(objectValue);
            if (property != null) {
                return ItemListControl.this.getListPropertySource().getPropertyValue(null, objectValue, property, true);
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            DBNNode object = (DBNNode)element;
            Object objectValue = ItemListControl.this.getObjectValue(object);
            ObjectPropertyDescriptor property = this.objectColumn.getProperty(objectValue);
            try {
                if (property != null) {
                    Object oldValue = ItemListControl.this.getListPropertySource().getPropertyValue(null, objectValue, property, false);
                    ItemListControl.this.getListPropertySource().setPropertyValue(null, objectValue, property, UIUtils.normalizePropertyValue((Object)value));
                    Object newValue = ItemListControl.this.getListPropertySource().getPropertyValue(null, objectValue, property, false);
                    if (value instanceof Boolean) {
                        ItemListControl.this.getItemsViewer().getControl().redraw();
                    }
                    if (!CommonUtils.equalObjects((Object)oldValue, (Object)newValue)) {
                        Map propMap = ItemListControl.this.changedProperties.computeIfAbsent(object, dbnNode -> new HashMap());
                        Object savedValue = propMap.get(property.getId());
                        if (CommonUtils.equalObjects(savedValue, (Object)newValue)) {
                            propMap.remove(property.getId());
                        } else if (!propMap.containsKey(property.getId())) {
                            propMap.put(property.getId(), oldValue);
                        }
                    }
                    ItemListControl.this.getItemsViewer().update((Object)object, null);
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Error setting property value", "Error setting property '" + property.getId() + "' value", (Throwable)e);
            }
        }
    }

    private class ItemColorProvider
    extends ObjectListControl.ObjectColumnLabelProvider {
        ItemColorProvider(ObjectListControl.ObjectColumn objectColumn) {
            super(ItemListControl.this, objectColumn);
        }

        @Override
        public Font getFont(Object element) {
            if (!(element instanceof DBNNode)) {
                return BaseThemeSettings.instance.treeAndTableFont;
            }
            DBNNode node = (DBNNode)element;
            Object object = ItemListControl.this.getObjectValue(node);
            return this.objectColumn.isNameColumn(object) && DBNUtils.isDefaultElement((Object)element) ? BaseThemeSettings.instance.treeAndTableFontBold : BaseThemeSettings.instance.treeAndTableFont;
        }

        @Override
        public Color getForeground(Object element) {
            return null;
        }

        @Override
        public Color getBackground(Object element) {
            if (!(element instanceof DBNNode)) {
                return null;
            }
            DBNNode node = (DBNNode)element;
            if (node.isDisposed()) {
                return null;
            }
            if (ItemListControl.this.isNewObject(node)) {
                if (!ItemListControl.this.isNewObject(ItemListControl.this.getRootNode())) {
                    return UIUtils.getCurrentTheme().getColorRegistry().get(ItemListControl.COLOR_NEW);
                }
            } else {
                Object objectValue;
                ObjectPropertyDescriptor prop;
                Map<String, Object> propMap = ItemListControl.this.changedProperties.get(node);
                if (propMap != null && (prop = this.objectColumn.getProperty(objectValue = ItemListControl.this.getObjectValue(node))) != null && propMap.containsKey(prop.getId())) {
                    return UIUtils.getCurrentTheme().getColorRegistry().get(ItemListControl.COLOR_MODIFIED);
                }
            }
            return null;
        }
    }
}

