/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.timescale;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.timescale.TimescaleTable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class TimescaleSchema
extends PostgreSchema {
    public TimescaleSchema(PostgreDatabase owner, String name, ResultSet dbResult) throws SQLException {
        super(owner, name, dbResult);
    }

    @Override
    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        super.collectObjectStatistics(monitor, totalSizeOnly, forceRefresh);
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read hypertable statistics");){
            try (JDBCPreparedStatement stmt = ((JDBCSession)session).prepareStatement("SELECT c.oid,\n       (size_info).total_bytes as total_rel_size,\n       (size_info).table_bytes as rel_size\nFROM pg_class c\nJOIN timescaledb_information.hypertables h\n  ON h.hypertable_schema = ? AND h.hypertable_name = c.relname\nCROSS JOIN LATERAL hypertable_detailed_size(c.oid) AS size_info\nWHERE c.relnamespace = ?");){
                stmt.setString(1, this.getName());
                stmt.setLong(2, this.getObjectId());
                try (JDBCResultSet dbResult = stmt.executeQuery();){
                    while (dbResult.next()) {
                        long tableId = dbResult.getLong(1);
                        PostgreTableBase table = this.getTable(monitor, tableId);
                        if (!(table instanceof TimescaleTable)) continue;
                        TimescaleTable timescaleTable = (TimescaleTable)table;
                        timescaleTable.fetchStatistics(dbResult);
                    }
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading schema relation statistics", (Throwable)e);
            }
        }
    }
}

