/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.hints;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueRow;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.data.DBDValueHintActionHandler;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

record ValueHintReference(@NotNull List<Reference> references) implements DBDValueHint,
DBDValueHintActionHandler
{
    ValueHintReference {
        if (references.isEmpty()) {
            throw new IllegalArgumentException("At least one reference must be provided");
        }
        references = List.copyOf(references);
    }

    @NotNull
    public DBDValueHint.HintType getHintType() {
        return DBDValueHint.HintType.ACTION;
    }

    @Nullable
    public String getHintText() {
        return null;
    }

    @NotNull
    public String getHintDescription() {
        return "Navigate to referenced table row";
    }

    @NotNull
    public DBPImage getHintIcon() {
        return UIIcon.LINK;
    }

    @Override
    @NotNull
    public String getActionText() {
        if (this.references.size() > 1) {
            return "Navigate to...";
        }
        return "Navigate to " + this.references.getFirst().toDisplayString();
    }

    @Override
    public void performAction(@NotNull IResultSetController controller, @NotNull Point location, long state) {
        if (this.references.size() > 1) {
            this.showActionsMenu(controller, location, state);
        } else {
            ValueHintReference.performAction(this.references.getFirst(), controller, state);
        }
    }

    private static void performAction(final @NotNull Reference reference, final @NotNull IResultSetController controller, final long state) {
        if (CommonUtils.isBitSet((long)state, (long)65536L)) {
            EditDictionaryPage editDictionaryPage = new EditDictionaryPage(reference.association().getAssociatedEntity());
            if (editDictionaryPage.edit(controller.getControl().getShell())) {
                controller.refreshData(null);
            }
            return;
        }
        new AbstractJob("Navigate association"){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    controller.navigateAssociation(monitor, controller.getModel(), reference.association(), List.of(reference.row()), CommonUtils.isBitSet((long)state, (long)SWT.MOD1));
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void showActionsMenu(final @NotNull IResultSetController controller, @NotNull Point location, final long state) {
        MenuManager manager = new MenuManager();
        manager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(@NotNull IMenuManager manager) {
                manager.add((IAction)new EmptyAction("Navigate to"));
                for (int i = 0; i < ValueHintReference.this.references.size(); ++i) {
                    final Reference reference = ValueHintReference.this.references.get(i);
                    String label = ActionUtils.getLabelWithIndexMnemonic((String)reference.toDisplayString(), (int)i);
                    ImageDescriptor image = DBeaverIcons.getImageDescriptor((DBPImage)DBSEntityType.TABLE.getIcon());
                    manager.add((IAction)new Action(label, image){

                        public void run() {
                            ValueHintReference.performAction(reference, controller, state);
                        }
                    });
                }
            }

            public void menuAboutToHide(@NotNull IMenuManager manager) {
                UIUtils.asyncExec(() -> ((IMenuManager)manager).dispose());
            }
        });
        Menu menu = manager.createContextMenu((Control)controller.getControl());
        menu.setLocation(location);
        menu.setVisible(true);
    }

    record Reference(@NotNull DBDValueRow row, @NotNull DBSEntityAssociation association) {
        @NotNull
        private String toDisplayString() {
            DBSEntity entity = this.association.getAssociatedEntity();
            return entity != null ? NLS.bind((String)"{0} ({1})", (Object)DBUtils.getObjectFullName((DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.UI), (Object)this.association.getName()) : this.association.getName();
        }
    }
}

