/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Arrays;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;

public enum PostgreAttributeStorage {
    DEFAULT("?"),
    PLAIN("p"),
    MAIN("m"),
    EXTERNAL("e"),
    EXTENDED("x");

    private final String code;

    private PostgreAttributeStorage(String code) {
        this.code = code;
    }

    protected boolean isSupported(PostgreDataSource dataSource) {
        return !this.code.equals("?") || dataSource.isServerVersionAtLeast(16, 0);
    }

    public String getCode() {
        return this.code;
    }

    public static PostgreAttributeStorage getByCode(String code) {
        for (PostgreAttributeStorage as : PostgreAttributeStorage.values()) {
            if (!as.getCode().equals(code)) continue;
            return as;
        }
        return DEFAULT;
    }

    public static PostgreAttributeStorage[] getValues(PostgreDataSource dataSource) {
        return (PostgreAttributeStorage[])Arrays.stream(PostgreAttributeStorage.values()).filter(e -> e.isSupported(dataSource)).toArray(PostgreAttributeStorage[]::new);
    }
}

