/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPRegistryListener;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.INavigatorListener;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractPartListener;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractPageListener;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DataSourceToolbarHandler
implements DBPRegistryListener,
DBPEventListener,
INavigatorListener {
    private final List<DBPDataSourceRegistry> handledRegistries = new ArrayList<DBPDataSourceRegistry>();
    private final IWorkbenchWindow workbenchWindow;
    private IWorkbenchPart activePart;
    private IPageListener pageListener;
    private IPartListener partListener;

    public DataSourceToolbarHandler(IWorkbenchWindow workbenchWindow) {
        this.workbenchWindow = workbenchWindow;
        DBWorkbench.getPlatform().getNavigatorModel().addListener((INavigatorListener)this);
        final ISelectionListener selectionListener = (part, selection) -> {
            Object element;
            DataSourceToolbarUtils.triggerRefreshReadonlyElement();
            if (part == this.activePart && part instanceof IEditorPart && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && RuntimeUtils.getObjectAdapter((Object)element, DBSObject.class) != null) {
                this.updateToolbar();
            }
        };
        this.pageListener = new AbstractPageListener(){

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener(DataSourceToolbarHandler.this.partListener);
                page.removeSelectionListener(selectionListener);
            }

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(DataSourceToolbarHandler.this.partListener);
                page.addSelectionListener(selectionListener);
            }
        };
        this.partListener = new AbstractPartListener(){

            public void partActivated(IWorkbenchPart part) {
                DataSourceToolbarHandler.this.setActivePart(part);
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == DataSourceToolbarHandler.this.activePart) {
                    DataSourceToolbarHandler.this.setActivePart(null);
                }
            }
        };
        workbenchWindow.addPageListener(this.pageListener);
        for (IWorkbenchPage page : workbenchWindow.getPages()) {
            this.pageListener.pageOpened(page);
        }
        UIExecutionQueue.queueExec(() -> {
            DataSourceProviderRegistry.getInstance().addDataSourceRegistryListener((DBPRegistryListener)this);
            for (DBPDataSourceRegistry registry : DBUtils.getAllRegistries((boolean)false)) {
                this.handleRegistryLoad(registry);
            }
            this.updateToolbar();
            DataSourceToolbarUtils.triggerRefreshReadonlyElement();
        });
    }

    public void dispose() {
        DataSourceProviderRegistry.getInstance().removeDataSourceRegistryListener((DBPRegistryListener)this);
        for (DBPDataSourceRegistry registry : this.handledRegistries) {
            registry.removeDataSourceListener((DBPEventListener)this);
        }
        this.handledRegistries.clear();
        DBWorkbench.getPlatform().getNavigatorModel().removeListener((INavigatorListener)this);
        if (this.pageListener != null) {
            this.workbenchWindow.removePageListener(this.pageListener);
            this.pageListener = null;
        }
    }

    public void setActivePart(@Nullable IWorkbenchPart part) {
        this.activePart = part;
        this.updateToolbar();
        DataSourceToolbarUtils.triggerRefreshReadonlyElement();
    }

    public void handleDataSourceEvent(@NotNull DBPEvent event) {
        if (this.workbenchWindow.getWorkbench().isClosing()) {
            return;
        }
        DBPDataSourceContainer currentDataSource = DataSourceToolbarUtils.getCurrentDataSource((IWorkbenchWindow)this.workbenchWindow);
        if (event.getAction() == DBPEvent.Action.OBJECT_UPDATE && event.getObject() == currentDataSource || event.getAction() == DBPEvent.Action.OBJECT_UPDATE && currentDataSource != null && event.getData() == currentDataSource.getRegistry() || event.getAction() == DBPEvent.Action.OBJECT_SELECT && Boolean.TRUE.equals(event.getEnabled()) && DBUtils.getContainer((DBSObject)event.getObject()) == currentDataSource) {
            UIUtils.asyncExec(this::updateToolbar);
        }
        if (event.getAction() == DBPEvent.Action.OBJECT_UPDATE && event.getEnabled() != null) {
            UIUtils.asyncExec(() -> {
                if (this.workbenchWindow instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)this.workbenchWindow).updateActionBars();
                }
            });
        }
        UIUtils.asyncExec(DataSourceToolbarUtils::triggerRefreshReadonlyElement);
    }

    private void updateToolbar() {
        DataSourceToolbarUtils.refreshSelectorToolbar((IWorkbenchWindow)this.workbenchWindow);
    }

    public void handleRegistryLoad(@NotNull DBPDataSourceRegistry registry) {
        registry.addDataSourceListener((DBPEventListener)this);
        this.handledRegistries.add(registry);
    }

    public void handleRegistryUnload(@NotNull DBPDataSourceRegistry registry) {
        this.handledRegistries.remove(registry);
        registry.removeDataSourceListener((DBPEventListener)this);
    }

    public void nodeChanged(DBNEvent event) {
        DBNNode node = event.getNode();
        IWorkbenchPage activePage = this.workbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        if (node instanceof DBNResource) {
            IFile activeFile = EditorUtils.getFileFromInput((IEditorInput)activeEditor.getEditorInput());
            if (activeFile == null) {
                return;
            }
            if (activeFile.equals((Object)((DBNResource)node).getResource())) {
                this.updateToolbar();
            }
            DataSourceToolbarUtils.triggerRefreshReadonlyElement();
        } else {
            DBNNode navigatorNode;
            IEditorInput editorInput = activeEditor.getEditorInput();
            if (editorInput instanceof INavigatorEditorInput && (navigatorNode = ((INavigatorEditorInput)editorInput).getNavigatorNode()) != null && navigatorNode.isChildOf(node)) {
                this.updateToolbar();
            }
        }
    }
}

