/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorPreferences;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.StatisticsNavigatorNodeRenderer;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

public abstract class NavigatorViewBase
extends ViewPart
implements INavigatorModelView,
DBPDataSourceContainerProvider,
DBPPreferenceListener {
    private DatabaseNavigatorTree tree;
    private transient Object lastSelection;

    protected NavigatorViewBase() {
    }

    @NotNull
    public static DBNModel getGlobalNavigatorModel() {
        return DBWorkbench.getPlatform().getNavigatorModel();
    }

    public DatabaseNavigatorTree getNavigatorTree() {
        return this.tree;
    }

    protected INavigatorFilter getNavigatorFilter() {
        return null;
    }

    @NotNull
    public TreeViewer getNavigatorViewer() {
        return this.tree.getViewer();
    }

    public void createPartControl(Composite parent) {
        this.tree = this.createNavigatorTree(parent, null);
        this.tree.setItemRenderer(new StatisticsNavigatorNodeRenderer(this));
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tree.getViewer());
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext("org.jkiss.dbeaver.ui.context.navigator");
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext("org.jkiss.dbeaver.ui.context.navigator.view");
        UIExecutionQueue.queueExec(() -> {
            if (!this.tree.isDisposed()) {
                this.tree.setInput(this.getRootNode());
            }
        });
    }

    private DatabaseNavigatorTree createNavigatorTree(Composite parent, DBNNode rootNode) {
        DatabaseNavigatorTree navigatorTree = new DatabaseNavigatorTree(parent, rootNode, this.getTreeStyle(), false, this.getNavigatorFilter());
        this.createTreeColumns(navigatorTree);
        navigatorTree.getViewer().addSelectionChangedListener(event -> this.onSelectionChange((IStructuredSelection)event.getSelection()));
        navigatorTree.getViewer().getTree().addListener(8, event -> {
            event.doit = false;
        });
        navigatorTree.getViewer().getTree().addMouseListener((MouseListener)new MouseAdapter(this){

            public void mouseDoubleClick(MouseEvent e) {
                super.mouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
            }
        });
        navigatorTree.getViewer().addDoubleClickListener(event -> {
            TreeViewer viewer = this.tree.getViewer();
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            for (Object node : selection.toArray()) {
                boolean hasChildren;
                if (node instanceof DBNResource && ((DBNResource)node).getResource() instanceof IFolder) {
                    this.toggleNode(viewer, node);
                    continue;
                }
                if (node instanceof DBNDataSource) {
                    NavigatorPreferences.DoubleClickBehavior dsBehaviorDefault = (NavigatorPreferences.DoubleClickBehavior)CommonUtils.valueOf(NavigatorPreferences.DoubleClickBehavior.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.connection.doubleClick"), (Enum)NavigatorPreferences.DoubleClickBehavior.EDIT);
                    if (dsBehaviorDefault == NavigatorPreferences.DoubleClickBehavior.EXPAND) {
                        this.toggleNode(viewer, node);
                        continue;
                    }
                    DBPDataSourceContainer dataSource = ((DBNDataSource)node).getObject();
                    switch (dsBehaviorDefault) {
                        case EDIT: {
                            NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)((DBNDataSource)node), null, UIUtils.getActiveWorkbenchWindow());
                            break;
                        }
                        case CONNECT: {
                            UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
                            if (serviceConnections == null) break;
                            if (dataSource.isConnected()) {
                                serviceConnections.disconnectDataSource(dataSource);
                                break;
                            }
                            serviceConnections.connectDataSource(dataSource, null);
                            break;
                        }
                        case SQL_EDITOR: {
                            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                            if (serviceSQL == null) break;
                            serviceSQL.openRecentScript((DBSObject)dataSource);
                            break;
                        }
                        case SQL_EDITOR_NEW: {
                            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                            if (serviceSQL == null) break;
                            serviceSQL.openNewScript((DBSObject)dataSource);
                            break;
                        }
                    }
                    continue;
                }
                if (node instanceof TreeNodeSpecial) {
                    ((TreeNodeSpecial)node).handleDefaultAction(navigatorTree);
                    continue;
                }
                String defaultEditorPageId = null;
                NavigatorPreferences.DoubleClickBehavior dcBehaviorDefault = (NavigatorPreferences.DoubleClickBehavior)CommonUtils.valueOf(NavigatorPreferences.DoubleClickBehavior.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.object.doubleClick"));
                if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof DBSDataContainer) {
                    defaultEditorPageId = DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.object.defaultEditorPage");
                }
                boolean bl = hasChildren = node instanceof DBNNode && ((DBNNode)node).hasChildren(true);
                if (hasChildren && dcBehaviorDefault == NavigatorPreferences.DoubleClickBehavior.EXPAND) {
                    this.toggleNode(viewer, node);
                    continue;
                }
                Map<String, Object> parameters = null;
                if (!CommonUtils.isEmpty((String)defaultEditorPageId)) {
                    parameters = Collections.singletonMap("activePage", defaultEditorPageId);
                }
                NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, node, parameters, (IServiceLocator)this.getSite());
            }
        });
        NavigatorUtils.addContextMenu((IWorkbenchSite)this.getSite(), (Viewer)navigatorTree.getViewer());
        this.installDragAndDropSupport(navigatorTree);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
        return navigatorTree;
    }

    protected void installDragAndDropSupport(DatabaseNavigatorTree navigatorTree) {
        NavigatorUtils.addDragAndDropSupport((Viewer)navigatorTree.getViewer());
    }

    protected void createTreeColumns(DatabaseNavigatorTree tree) {
    }

    private void toggleNode(TreeViewer viewer, Object node) {
        if (Boolean.TRUE.equals(viewer.getExpandedState(node))) {
            viewer.collapseToLevel(node, 1);
        } else {
            viewer.expandToLevel(node, 1);
        }
    }

    private void onSelectionChange(IStructuredSelection structSel) {
        IEditorPart activeEditor;
        if (!structSel.isEmpty()) {
            this.lastSelection = structSel.getFirstElement();
            if (this.lastSelection instanceof DBNRoot) {
                this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
            } else {
                Object object = this.lastSelection;
                if (object instanceof DBNNode) {
                    DBNNode node = (DBNNode)object;
                    Object name = node.getNodeDisplayName();
                    String desc = node.getNodeDescription();
                    if (node instanceof DBNDatabaseNode && !(node instanceof DBNDatabaseFolder)) {
                        name = node.getNodeTypeLabel() + ": " + (String)name;
                    }
                    if (CommonUtils.isEmpty((String)desc)) {
                        this.getViewSite().getActionBars().getStatusLineManager().setMessage((String)name);
                    } else {
                        this.getViewSite().getActionBars().getStatusLineManager().setMessage((String)name + " - " + desc);
                    }
                }
            }
        } else {
            this.lastSelection = null;
        }
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.lastSelection instanceof DBNDatabaseNode && preferenceStore.getBoolean("navigator.sync.editor.datasource") && (activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
            NavigatorUtils.syncEditorWithNavigator(this, activeEditor);
        }
    }

    protected int getTreeStyle() {
        return 65538;
    }

    public void dispose() {
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.tree.getViewer().getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new PropertyPageStandard());
        }
        return (T)super.getAdapter(adapter);
    }

    public void showNode(DBNNode node) {
        this.tree.showNode(node);
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        Object object = this.lastSelection;
        if (object instanceof DBNDatabaseNode) {
            DBNDatabaseNode databaseNode = (DBNDatabaseNode)object;
            Object object2 = this.lastSelection;
            if (object2 instanceof DBNDataSource) {
                dataSourceNode = (DBNDataSource)object2;
                return dataSourceNode.getDataSourceContainer();
            }
            if (databaseNode.getObject() != null) {
                DBPDataSource dataSource = databaseNode.getObject().getDataSource();
                return dataSource == null ? null : dataSource.getContainer();
            }
        } else {
            DBNResource resourceNode;
            Collection containers;
            dataSourceNode = this.lastSelection;
            if (dataSourceNode instanceof DBNResource && (containers = (resourceNode = (DBNResource)dataSourceNode).getAssociatedDataSources()) != null && containers.size() == 1) {
                return (DBPDataSourceContainer)containers.iterator().next();
            }
        }
        return null;
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        String property = event.getProperty();
        if (CommonUtils.equalObjects((Object)event.getOldValue(), (Object)event.getNewValue())) {
            return;
        }
        switch (property) {
            case "navigator.show.folder.placeholders": 
            case "navigator.sort.case.insensitive": 
            case "navigator.sort.case.insensitive.ignore.case": 
            case "navigator.sort.forlers.first": 
            case "navigator.color.nodes.all": 
            case "navigator.group.by.driver": {
                this.tree.getViewer().refresh();
                break;
            }
            case "navigator.show.statistics.info": 
            case "navigator.show.connection.host": 
            case "navigator.show.objects.description": 
            case "navigator.show.node.actions": {
                this.tree.getViewer().getTree().redraw();
            }
        }
    }
}

