/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.bind;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

class GenerateSourceFilesForListsAndSets {
    private static final String DOC_PATTERN = "\\t*/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*/";

    GenerateSourceFilesForListsAndSets() {
    }

    public static void main(String[] args) throws IOException {
        String originalVariant = "Value";
        List<String> derivedVariants = Arrays.asList("List", "Set");
        List<String> files = Arrays.asList("src/org/eclipse/core/databinding/bind/steps/?CommonSteps.java", "src/org/eclipse/core/databinding/bind/steps/?OneWaySteps.java", "src/org/eclipse/core/databinding/bind/steps/?TwoWaySteps.java", "src/org/eclipse/core/internal/databinding/bind/?CommonStepsImpl.java", "src/org/eclipse/core/internal/databinding/bind/?OneWayStepsImpl.java", "src/org/eclipse/core/internal/databinding/bind/?TwoWayStepsImpl.java");
        for (String variant : derivedVariants) {
            for (String file : files) {
                Path source = Paths.get(file.replace("?", originalVariant), new String[0]);
                Path dest = Paths.get(file.replace("?", variant), new String[0]);
                String contents = new String(Files.readAllBytes(source), StandardCharsets.UTF_8);
                contents = contents.replaceFirst("\n\n", "\n\nimport java.util." + variant + ";\n");
                contents = contents.replaceAll("fromComputedValue\\(Supplier<F>", "fromComputedValue(Supplier<" + variant + "<F>>");
                contents = GenerateSourceFilesForListsAndSets.filterMethodDecl(contents, "validateTwoWay");
                contents = GenerateSourceFilesForListsAndSets.filterMethodDecl(contents, "validateAfterConvert");
                contents = GenerateSourceFilesForListsAndSets.filterMethodImpl(contents, "validateAfterConvert");
                contents = GenerateSourceFilesForListsAndSets.filterMethodDecl(contents, "validateAfterGet");
                contents = GenerateSourceFilesForListsAndSets.filterMethodImpl(contents, "validateAfterGet");
                contents = GenerateSourceFilesForListsAndSets.filterMethodDecl(contents, "validateBeforeSet");
                contents = GenerateSourceFilesForListsAndSets.filterMethodImpl(contents, "validateBeforeSet");
                contents = GenerateSourceFilesForListsAndSets.filterMethodDecl(contents, "convertOnly");
                contents = GenerateSourceFilesForListsAndSets.filterMethodImpl(contents, "convertOnly");
                contents = GenerateSourceFilesForListsAndSets.filterMethodImpl(contents, "validateTwoWay");
                contents = contents.replace(originalVariant, variant);
                contents = contents.replace(originalVariant.toLowerCase(), variant.toLowerCase());
                Files.write(dest, contents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                System.out.println("Wrote '" + String.valueOf(dest));
            }
        }
    }

    private static String filterMethodDecl(String source, String methodName) {
        return source.replaceAll("(?sm)\\t*/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*/[\\s@\\w<>]+ " + methodName + "[^\\n]*?;\\n*", "");
    }

    private static String filterMethodImpl(String source, String methodName) {
        return source.replaceAll("(?sm)(\\t*/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*/)?[\\s@\\w<>]+ " + methodName + ".*?\\}\\n*", "\n");
    }
}

