/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class PerformRefactoringOperation
implements IWorkspaceRunnable {
    private final int fStyle;
    private RefactoringContext fRefactoringContext;
    private final Refactoring fRefactoring;
    private RefactoringStatus fPreconditionStatus;
    private RefactoringStatus fValidationStatus;
    private Change fUndo;

    public PerformRefactoringOperation(Refactoring refactoring, int style) {
        Assert.isNotNull((Object)((Object)refactoring));
        this.fRefactoring = refactoring;
        this.fStyle = style;
    }

    public PerformRefactoringOperation(RefactoringContext refactoringContext, int style) {
        Assert.isNotNull((Object)refactoringContext);
        this.fRefactoringContext = refactoringContext;
        this.fRefactoring = this.fRefactoringContext.getRefactoring();
        this.fStyle = style;
    }

    public RefactoringStatus getConditionStatus() {
        return this.fPreconditionStatus;
    }

    public RefactoringStatus getValidationStatus() {
        return this.fValidationStatus;
    }

    public Change getUndoChange() {
        return this.fUndo;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)8);
        try {
            CreateChangeOperation create = new CreateChangeOperation(new CheckConditionsOperation(this.fRefactoring, this.fStyle), 4);
            create.run((IProgressMonitor)subMon.newChild(6));
            this.fPreconditionStatus = create.getConditionCheckingStatus();
            if (this.fPreconditionStatus.hasFatalError()) {
                return;
            }
            Change change = create.getChange();
            if (change != null) {
                PerformChangeOperation perform = new PerformChangeOperation(change);
                perform.setUndoManager(RefactoringCore.getUndoManager(), this.fRefactoring.getName());
                perform.run((IProgressMonitor)subMon.newChild(2));
                this.fValidationStatus = perform.getValidationStatus();
                this.fUndo = perform.getUndoChange();
            }
        }
        finally {
            subMon.done();
            if (this.fRefactoringContext != null) {
                this.fRefactoringContext.dispose();
            }
        }
    }
}

