"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRegisterEvents = void 0;
const react_1 = require("react");
const useSigma_1 = require("./useSigma");
const useSetSettings_1 = require("./useSetSettings");
const sigmaEvents = [
    "clickNode",
    "rightClickNode",
    "downNode",
    "enterNode",
    "leaveNode",
    "doubleClickNode",
    "wheelNode",
    "clickEdge",
    "rightClickEdge",
    "downEdge",
    "enterEdge",
    "leaveEdge",
    "doubleClickEdge",
    "wheelEdge",
    "clickStage",
    "rightClickStage",
    "downStage",
    "doubleClickStage",
    "wheelStage",
    "beforeRender",
    "afterRender",
    "kill",
];
const mouseEvents = [
    "click",
    "rightClick",
    "mouseup",
    "mousedown",
    "mousemove",
    "mousemovebody",
    "doubleClick",
    "wheel",
];
const touchEvents = ["touchup", "touchdown", "touchmove"];
const cameraEvents = ["updated"];
function useRegisterEvents() {
    const sigma = (0, useSigma_1.useSigma)();
    const setSettings = (0, useSetSettings_1.useSetSettings)();
    const [eventHandlers, setEventHandlers] = (0, react_1.useState)({});
    (0, react_1.useEffect)(() => {
        if (!sigma || !eventHandlers) {
            return;
        }
        const userEvents = eventHandlers;
        const eventTypes = Object.keys(userEvents);
        const edgeSettings = {};
        const reverseEdgeSettings = {};
        const sigmaSettings = sigma.getSettings();
        if (eventTypes.some((event) => ["clickEdge", "rightClickEdge", "doubleClickEdge", "downEdge"].includes(event)) &&
            sigmaSettings.enableEdgeClickEvents === false) {
            edgeSettings["enableEdgeClickEvents"] = true;
            reverseEdgeSettings["enableEdgeClickEvents"] = false;
        }
        if (eventTypes.some((event) => ["enterEdge", "leaveEdge"].includes(event)) &&
            sigmaSettings.enableEdgeHoverEvents === false) {
            edgeSettings["enableEdgeHoverEvents"] = true;
            reverseEdgeSettings["enableEdgeHoverEvents"] = false;
        }
        if (eventTypes.some((event) => ["wheelEdge"].includes(event)) && sigmaSettings.enableEdgeWheelEvents === false) {
            edgeSettings["enableEdgeWheelEvents"] = true;
            reverseEdgeSettings["enableEdgeWheelEvents"] = false;
        }
        if (Object.keys(edgeSettings).length > 0) {
            setSettings(edgeSettings);
        }
        eventTypes.forEach((event) => {
            const eventHandler = userEvents[event];
            if (sigmaEvents.find((e) => e === event)) {
                sigma.on(event, eventHandler);
            }
            if (mouseEvents.find((e) => e === event)) {
                sigma.getMouseCaptor().on(event, eventHandler);
            }
            if (touchEvents.find((e) => e === event)) {
                sigma.getTouchCaptor().on(event, eventHandler);
            }
            if (cameraEvents.find((e) => e === event)) {
                sigma.getCamera().on(event, eventHandler);
            }
        });
        return () => {
            if (Object.keys(reverseEdgeSettings).length > 0) {
                setSettings(reverseEdgeSettings);
            }
            if (sigma) {
                eventTypes.forEach((event) => {
                    const eventHandler = userEvents[event];
                    if (sigmaEvents.find((e) => e === event)) {
                        sigma.off(event, eventHandler);
                    }
                    if (mouseEvents.find((e) => e === event)) {
                        sigma.getMouseCaptor().off(event, eventHandler);
                    }
                    if (touchEvents.find((e) => e === event)) {
                        sigma.getTouchCaptor().off(event, eventHandler);
                    }
                    if (cameraEvents.find((e) => e === event)) {
                        sigma.getCamera().off(event, eventHandler);
                    }
                });
            }
        };
    }, [sigma, eventHandlers, setSettings]);
    return setEventHandlers;
}
exports.useRegisterEvents = useRegisterEvents;
//# sourceMappingURL=useRegisterEvents.js.map