// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

/* eslint-disable @typescript-eslint/no-unused-vars */
// organize-imports-ignore
import matchers from '@testing-library/jest-dom/matchers';
import { expect } from 'vitest';
//@ts-ignore
import React from 'react';
//@ts-ignore
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import 'whatwg-fetch';

// jest-dom extensions
expect.extend(matchers);

// mocks

beforeAll(() => {
    // DoodleUI Table uses virtualization which requires these properties to be defined or rows do not render
    Object.defineProperty(HTMLElement.prototype, 'offsetHeight', {
        value: 800,
    });
    Object.defineProperty(HTMLElement.prototype, 'offsetWidth', {
        value: 800,
    });

    // Radix Select relies on pointer events + scroll positioning under the hood
    // (Popper + focus management). In JSDOM, those methods (scrollIntoView,
    // hasPointerCapture, releasePointerCapture) don’t exist by default, so Radix
    // crashes silently when trying to open the select dropdown.
    const g = globalThis as any;
    const ElementCtor = g.Element as typeof Element | undefined;
    if (!ElementCtor?.prototype) return;
    const proto = ElementCtor.prototype as any;
    if (typeof proto.scrollIntoView !== 'function') proto.scrollIntoView = vi.fn();
    if (typeof proto.hasPointerCapture !== 'function') proto.hasPointerCapture = vi.fn();
    if (typeof proto.releasePointerCapture !== 'function') proto.releasePointerCapture = vi.fn();
});

beforeEach(() => {
    vi.clearAllMocks();
});

// See https://fontawesome.com/v5.15/how-to-use/on-the-web/using-with/react#unit-testing for more information
vi.mock('@fortawesome/react-fontawesome', () => ({
    FontAwesomeIcon: vi.fn((props) => {
        if (typeof props.icon === 'string') return <span>{props.icon}</span>;

        return <span>{props.icon.iconName}</span>;
    }),
}));

const ResizeObserverMock = vi.fn(() => ({
    observe: vi.fn(),
    unobserve: vi.fn(),
    disconnect: vi.fn(),
}));
vi.stubGlobal('ResizeObserver', ResizeObserverMock);
