// Copyright 2026 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/specterops/dawgs/graph (interfaces: Database,Batch,Transaction,Cursor,Result,NodeQuery,RelationshipQuery)
//
// Generated by this command:
//
//	mockgen -copyright_file=../../../../LICENSE.header -destination=./dawgs/graph/mock.go -package=graph github.com/specterops/dawgs/graph Database,Batch,Transaction,Cursor,Result,NodeQuery,RelationshipQuery
//

// Package graph is a generated GoMock package.
package graph

import (
	context "context"
	reflect "reflect"

	graph "github.com/specterops/dawgs/graph"
	size "github.com/specterops/dawgs/util/size"
	gomock "go.uber.org/mock/gomock"
)

// MockDatabase is a mock of Database interface.
type MockDatabase struct {
	ctrl     *gomock.Controller
	recorder *MockDatabaseMockRecorder
	isgomock struct{}
}

// MockDatabaseMockRecorder is the mock recorder for MockDatabase.
type MockDatabaseMockRecorder struct {
	mock *MockDatabase
}

// NewMockDatabase creates a new mock instance.
func NewMockDatabase(ctrl *gomock.Controller) *MockDatabase {
	mock := &MockDatabase{ctrl: ctrl}
	mock.recorder = &MockDatabaseMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockDatabase) EXPECT() *MockDatabaseMockRecorder {
	return m.recorder
}

// AssertSchema mocks base method.
func (m *MockDatabase) AssertSchema(ctx context.Context, dbSchema graph.Schema) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AssertSchema", ctx, dbSchema)
	ret0, _ := ret[0].(error)
	return ret0
}

// AssertSchema indicates an expected call of AssertSchema.
func (mr *MockDatabaseMockRecorder) AssertSchema(ctx, dbSchema any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssertSchema", reflect.TypeOf((*MockDatabase)(nil).AssertSchema), ctx, dbSchema)
}

// BatchOperation mocks base method.
func (m *MockDatabase) BatchOperation(ctx context.Context, batchDelegate graph.BatchDelegate) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchOperation", ctx, batchDelegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// BatchOperation indicates an expected call of BatchOperation.
func (mr *MockDatabaseMockRecorder) BatchOperation(ctx, batchDelegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchOperation", reflect.TypeOf((*MockDatabase)(nil).BatchOperation), ctx, batchDelegate)
}

// Close mocks base method.
func (m *MockDatabase) Close(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close.
func (mr *MockDatabaseMockRecorder) Close(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockDatabase)(nil).Close), ctx)
}

// FetchKinds mocks base method.
func (m *MockDatabase) FetchKinds(ctx context.Context) (graph.Kinds, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchKinds", ctx)
	ret0, _ := ret[0].(graph.Kinds)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchKinds indicates an expected call of FetchKinds.
func (mr *MockDatabaseMockRecorder) FetchKinds(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchKinds", reflect.TypeOf((*MockDatabase)(nil).FetchKinds), ctx)
}

// ReadTransaction mocks base method.
func (m *MockDatabase) ReadTransaction(ctx context.Context, txDelegate graph.TransactionDelegate, options ...graph.TransactionOption) error {
	m.ctrl.T.Helper()
	varargs := []any{ctx, txDelegate}
	for _, a := range options {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "ReadTransaction", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// ReadTransaction indicates an expected call of ReadTransaction.
func (mr *MockDatabaseMockRecorder) ReadTransaction(ctx, txDelegate any, options ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{ctx, txDelegate}, options...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadTransaction", reflect.TypeOf((*MockDatabase)(nil).ReadTransaction), varargs...)
}

// RefreshKinds mocks base method.
func (m *MockDatabase) RefreshKinds(ctx context.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RefreshKinds", ctx)
	ret0, _ := ret[0].(error)
	return ret0
}

// RefreshKinds indicates an expected call of RefreshKinds.
func (mr *MockDatabaseMockRecorder) RefreshKinds(ctx any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RefreshKinds", reflect.TypeOf((*MockDatabase)(nil).RefreshKinds), ctx)
}

// Run mocks base method.
func (m *MockDatabase) Run(ctx context.Context, query string, parameters map[string]any) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Run", ctx, query, parameters)
	ret0, _ := ret[0].(error)
	return ret0
}

// Run indicates an expected call of Run.
func (mr *MockDatabaseMockRecorder) Run(ctx, query, parameters any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Run", reflect.TypeOf((*MockDatabase)(nil).Run), ctx, query, parameters)
}

// SetBatchWriteSize mocks base method.
func (m *MockDatabase) SetBatchWriteSize(interval int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetBatchWriteSize", interval)
}

// SetBatchWriteSize indicates an expected call of SetBatchWriteSize.
func (mr *MockDatabaseMockRecorder) SetBatchWriteSize(interval any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBatchWriteSize", reflect.TypeOf((*MockDatabase)(nil).SetBatchWriteSize), interval)
}

// SetDefaultGraph mocks base method.
func (m *MockDatabase) SetDefaultGraph(ctx context.Context, graphSchema graph.Graph) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetDefaultGraph", ctx, graphSchema)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetDefaultGraph indicates an expected call of SetDefaultGraph.
func (mr *MockDatabaseMockRecorder) SetDefaultGraph(ctx, graphSchema any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetDefaultGraph", reflect.TypeOf((*MockDatabase)(nil).SetDefaultGraph), ctx, graphSchema)
}

// SetWriteFlushSize mocks base method.
func (m *MockDatabase) SetWriteFlushSize(interval int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "SetWriteFlushSize", interval)
}

// SetWriteFlushSize indicates an expected call of SetWriteFlushSize.
func (mr *MockDatabaseMockRecorder) SetWriteFlushSize(interval any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteFlushSize", reflect.TypeOf((*MockDatabase)(nil).SetWriteFlushSize), interval)
}

// WriteTransaction mocks base method.
func (m *MockDatabase) WriteTransaction(ctx context.Context, txDelegate graph.TransactionDelegate, options ...graph.TransactionOption) error {
	m.ctrl.T.Helper()
	varargs := []any{ctx, txDelegate}
	for _, a := range options {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "WriteTransaction", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTransaction indicates an expected call of WriteTransaction.
func (mr *MockDatabaseMockRecorder) WriteTransaction(ctx, txDelegate any, options ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{ctx, txDelegate}, options...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTransaction", reflect.TypeOf((*MockDatabase)(nil).WriteTransaction), varargs...)
}

// MockBatch is a mock of Batch interface.
type MockBatch struct {
	ctrl     *gomock.Controller
	recorder *MockBatchMockRecorder
	isgomock struct{}
}

// MockBatchMockRecorder is the mock recorder for MockBatch.
type MockBatchMockRecorder struct {
	mock *MockBatch
}

// NewMockBatch creates a new mock instance.
func NewMockBatch(ctrl *gomock.Controller) *MockBatch {
	mock := &MockBatch{ctrl: ctrl}
	mock.recorder = &MockBatchMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockBatch) EXPECT() *MockBatchMockRecorder {
	return m.recorder
}

// Commit mocks base method.
func (m *MockBatch) Commit() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Commit")
	ret0, _ := ret[0].(error)
	return ret0
}

// Commit indicates an expected call of Commit.
func (mr *MockBatchMockRecorder) Commit() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Commit", reflect.TypeOf((*MockBatch)(nil).Commit))
}

// CreateNode mocks base method.
func (m *MockBatch) CreateNode(node *graph.Node) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateNode", node)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateNode indicates an expected call of CreateNode.
func (mr *MockBatchMockRecorder) CreateNode(node any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNode", reflect.TypeOf((*MockBatch)(nil).CreateNode), node)
}

// CreateRelationship mocks base method.
func (m *MockBatch) CreateRelationship(relationship *graph.Relationship) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRelationship", relationship)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateRelationship indicates an expected call of CreateRelationship.
func (mr *MockBatchMockRecorder) CreateRelationship(relationship any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRelationship", reflect.TypeOf((*MockBatch)(nil).CreateRelationship), relationship)
}

// CreateRelationshipByIDs mocks base method.
func (m *MockBatch) CreateRelationshipByIDs(startNodeID, endNodeID graph.ID, kind graph.Kind, properties *graph.Properties) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRelationshipByIDs", startNodeID, endNodeID, kind, properties)
	ret0, _ := ret[0].(error)
	return ret0
}

// CreateRelationshipByIDs indicates an expected call of CreateRelationshipByIDs.
func (mr *MockBatchMockRecorder) CreateRelationshipByIDs(startNodeID, endNodeID, kind, properties any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRelationshipByIDs", reflect.TypeOf((*MockBatch)(nil).CreateRelationshipByIDs), startNodeID, endNodeID, kind, properties)
}

// DeleteNode mocks base method.
func (m *MockBatch) DeleteNode(id graph.ID) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteNode", id)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteNode indicates an expected call of DeleteNode.
func (mr *MockBatchMockRecorder) DeleteNode(id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteNode", reflect.TypeOf((*MockBatch)(nil).DeleteNode), id)
}

// DeleteRelationship mocks base method.
func (m *MockBatch) DeleteRelationship(id graph.ID) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteRelationship", id)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteRelationship indicates an expected call of DeleteRelationship.
func (mr *MockBatchMockRecorder) DeleteRelationship(id any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteRelationship", reflect.TypeOf((*MockBatch)(nil).DeleteRelationship), id)
}

// Nodes mocks base method.
func (m *MockBatch) Nodes() graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Nodes")
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Nodes indicates an expected call of Nodes.
func (mr *MockBatchMockRecorder) Nodes() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Nodes", reflect.TypeOf((*MockBatch)(nil).Nodes))
}

// Relationships mocks base method.
func (m *MockBatch) Relationships() graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Relationships")
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Relationships indicates an expected call of Relationships.
func (mr *MockBatchMockRecorder) Relationships() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Relationships", reflect.TypeOf((*MockBatch)(nil).Relationships))
}

// UpdateNodeBy mocks base method.
func (m *MockBatch) UpdateNodeBy(update graph.NodeUpdate) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateNodeBy", update)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateNodeBy indicates an expected call of UpdateNodeBy.
func (mr *MockBatchMockRecorder) UpdateNodeBy(update any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateNodeBy", reflect.TypeOf((*MockBatch)(nil).UpdateNodeBy), update)
}

// UpdateRelationshipBy mocks base method.
func (m *MockBatch) UpdateRelationshipBy(update graph.RelationshipUpdate) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateRelationshipBy", update)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateRelationshipBy indicates an expected call of UpdateRelationshipBy.
func (mr *MockBatchMockRecorder) UpdateRelationshipBy(update any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateRelationshipBy", reflect.TypeOf((*MockBatch)(nil).UpdateRelationshipBy), update)
}

// WithGraph mocks base method.
func (m *MockBatch) WithGraph(graphSchema graph.Graph) graph.Batch {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WithGraph", graphSchema)
	ret0, _ := ret[0].(graph.Batch)
	return ret0
}

// WithGraph indicates an expected call of WithGraph.
func (mr *MockBatchMockRecorder) WithGraph(graphSchema any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WithGraph", reflect.TypeOf((*MockBatch)(nil).WithGraph), graphSchema)
}

// MockTransaction is a mock of Transaction interface.
type MockTransaction struct {
	ctrl     *gomock.Controller
	recorder *MockTransactionMockRecorder
	isgomock struct{}
}

// MockTransactionMockRecorder is the mock recorder for MockTransaction.
type MockTransactionMockRecorder struct {
	mock *MockTransaction
}

// NewMockTransaction creates a new mock instance.
func NewMockTransaction(ctrl *gomock.Controller) *MockTransaction {
	mock := &MockTransaction{ctrl: ctrl}
	mock.recorder = &MockTransactionMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockTransaction) EXPECT() *MockTransactionMockRecorder {
	return m.recorder
}

// Commit mocks base method.
func (m *MockTransaction) Commit() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Commit")
	ret0, _ := ret[0].(error)
	return ret0
}

// Commit indicates an expected call of Commit.
func (mr *MockTransactionMockRecorder) Commit() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Commit", reflect.TypeOf((*MockTransaction)(nil).Commit))
}

// CreateNode mocks base method.
func (m *MockTransaction) CreateNode(properties *graph.Properties, kinds ...graph.Kind) (*graph.Node, error) {
	m.ctrl.T.Helper()
	varargs := []any{properties}
	for _, a := range kinds {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "CreateNode", varargs...)
	ret0, _ := ret[0].(*graph.Node)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateNode indicates an expected call of CreateNode.
func (mr *MockTransactionMockRecorder) CreateNode(properties any, kinds ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{properties}, kinds...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateNode", reflect.TypeOf((*MockTransaction)(nil).CreateNode), varargs...)
}

// CreateRelationshipByIDs mocks base method.
func (m *MockTransaction) CreateRelationshipByIDs(startNodeID, endNodeID graph.ID, kind graph.Kind, properties *graph.Properties) (*graph.Relationship, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CreateRelationshipByIDs", startNodeID, endNodeID, kind, properties)
	ret0, _ := ret[0].(*graph.Relationship)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CreateRelationshipByIDs indicates an expected call of CreateRelationshipByIDs.
func (mr *MockTransactionMockRecorder) CreateRelationshipByIDs(startNodeID, endNodeID, kind, properties any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CreateRelationshipByIDs", reflect.TypeOf((*MockTransaction)(nil).CreateRelationshipByIDs), startNodeID, endNodeID, kind, properties)
}

// GraphQueryMemoryLimit mocks base method.
func (m *MockTransaction) GraphQueryMemoryLimit() size.Size {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GraphQueryMemoryLimit")
	ret0, _ := ret[0].(size.Size)
	return ret0
}

// GraphQueryMemoryLimit indicates an expected call of GraphQueryMemoryLimit.
func (mr *MockTransactionMockRecorder) GraphQueryMemoryLimit() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GraphQueryMemoryLimit", reflect.TypeOf((*MockTransaction)(nil).GraphQueryMemoryLimit))
}

// Nodes mocks base method.
func (m *MockTransaction) Nodes() graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Nodes")
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Nodes indicates an expected call of Nodes.
func (mr *MockTransactionMockRecorder) Nodes() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Nodes", reflect.TypeOf((*MockTransaction)(nil).Nodes))
}

// Query mocks base method.
func (m *MockTransaction) Query(query string, parameters map[string]any) graph.Result {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Query", query, parameters)
	ret0, _ := ret[0].(graph.Result)
	return ret0
}

// Query indicates an expected call of Query.
func (mr *MockTransactionMockRecorder) Query(query, parameters any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MockTransaction)(nil).Query), query, parameters)
}

// Raw mocks base method.
func (m *MockTransaction) Raw(query string, parameters map[string]any) graph.Result {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Raw", query, parameters)
	ret0, _ := ret[0].(graph.Result)
	return ret0
}

// Raw indicates an expected call of Raw.
func (mr *MockTransactionMockRecorder) Raw(query, parameters any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Raw", reflect.TypeOf((*MockTransaction)(nil).Raw), query, parameters)
}

// Relationships mocks base method.
func (m *MockTransaction) Relationships() graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Relationships")
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Relationships indicates an expected call of Relationships.
func (mr *MockTransactionMockRecorder) Relationships() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Relationships", reflect.TypeOf((*MockTransaction)(nil).Relationships))
}

// UpdateNode mocks base method.
func (m *MockTransaction) UpdateNode(node *graph.Node) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateNode", node)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateNode indicates an expected call of UpdateNode.
func (mr *MockTransactionMockRecorder) UpdateNode(node any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateNode", reflect.TypeOf((*MockTransaction)(nil).UpdateNode), node)
}

// UpdateRelationship mocks base method.
func (m *MockTransaction) UpdateRelationship(relationship *graph.Relationship) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateRelationship", relationship)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateRelationship indicates an expected call of UpdateRelationship.
func (mr *MockTransactionMockRecorder) UpdateRelationship(relationship any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateRelationship", reflect.TypeOf((*MockTransaction)(nil).UpdateRelationship), relationship)
}

// WithGraph mocks base method.
func (m *MockTransaction) WithGraph(graphSchema graph.Graph) graph.Transaction {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WithGraph", graphSchema)
	ret0, _ := ret[0].(graph.Transaction)
	return ret0
}

// WithGraph indicates an expected call of WithGraph.
func (mr *MockTransactionMockRecorder) WithGraph(graphSchema any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WithGraph", reflect.TypeOf((*MockTransaction)(nil).WithGraph), graphSchema)
}

// MockCursor is a mock of Cursor interface.
type MockCursor[T any] struct {
	ctrl     *gomock.Controller
	recorder *MockCursorMockRecorder[T]
	isgomock struct{}
}

// MockCursorMockRecorder is the mock recorder for MockCursor.
type MockCursorMockRecorder[T any] struct {
	mock *MockCursor[T]
}

// NewMockCursor creates a new mock instance.
func NewMockCursor[T any](ctrl *gomock.Controller) *MockCursor[T] {
	mock := &MockCursor[T]{ctrl: ctrl}
	mock.recorder = &MockCursorMockRecorder[T]{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockCursor[T]) EXPECT() *MockCursorMockRecorder[T] {
	return m.recorder
}

// Chan mocks base method.
func (m *MockCursor[T]) Chan() chan T {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Chan")
	ret0, _ := ret[0].(chan T)
	return ret0
}

// Chan indicates an expected call of Chan.
func (mr *MockCursorMockRecorder[T]) Chan() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Chan", reflect.TypeOf((*MockCursor[T])(nil).Chan))
}

// Close mocks base method.
func (m *MockCursor[T]) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockCursorMockRecorder[T]) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockCursor[T])(nil).Close))
}

// Error mocks base method.
func (m *MockCursor[T]) Error() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Error")
	ret0, _ := ret[0].(error)
	return ret0
}

// Error indicates an expected call of Error.
func (mr *MockCursorMockRecorder[T]) Error() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Error", reflect.TypeOf((*MockCursor[T])(nil).Error))
}

// MockResult is a mock of Result interface.
type MockResult struct {
	ctrl     *gomock.Controller
	recorder *MockResultMockRecorder
	isgomock struct{}
}

// MockResultMockRecorder is the mock recorder for MockResult.
type MockResultMockRecorder struct {
	mock *MockResult
}

// NewMockResult creates a new mock instance.
func NewMockResult(ctrl *gomock.Controller) *MockResult {
	mock := &MockResult{ctrl: ctrl}
	mock.recorder = &MockResultMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockResult) EXPECT() *MockResultMockRecorder {
	return m.recorder
}

// Close mocks base method.
func (m *MockResult) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close.
func (mr *MockResultMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockResult)(nil).Close))
}

// Error mocks base method.
func (m *MockResult) Error() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Error")
	ret0, _ := ret[0].(error)
	return ret0
}

// Error indicates an expected call of Error.
func (mr *MockResultMockRecorder) Error() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Error", reflect.TypeOf((*MockResult)(nil).Error))
}

// Keys mocks base method.
func (m *MockResult) Keys() []string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Keys")
	ret0, _ := ret[0].([]string)
	return ret0
}

// Keys indicates an expected call of Keys.
func (mr *MockResultMockRecorder) Keys() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Keys", reflect.TypeOf((*MockResult)(nil).Keys))
}

// Mapper mocks base method.
func (m *MockResult) Mapper() graph.ValueMapper {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Mapper")
	ret0, _ := ret[0].(graph.ValueMapper)
	return ret0
}

// Mapper indicates an expected call of Mapper.
func (mr *MockResultMockRecorder) Mapper() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Mapper", reflect.TypeOf((*MockResult)(nil).Mapper))
}

// Next mocks base method.
func (m *MockResult) Next() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Next")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Next indicates an expected call of Next.
func (mr *MockResultMockRecorder) Next() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Next", reflect.TypeOf((*MockResult)(nil).Next))
}

// Scan mocks base method.
func (m *MockResult) Scan(targets ...any) error {
	m.ctrl.T.Helper()
	varargs := []any{}
	for _, a := range targets {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Scan", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Scan indicates an expected call of Scan.
func (mr *MockResultMockRecorder) Scan(targets ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Scan", reflect.TypeOf((*MockResult)(nil).Scan), targets...)
}

// Values mocks base method.
func (m *MockResult) Values() []any {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Values")
	ret0, _ := ret[0].([]any)
	return ret0
}

// Values indicates an expected call of Values.
func (mr *MockResultMockRecorder) Values() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Values", reflect.TypeOf((*MockResult)(nil).Values))
}

// MockNodeQuery is a mock of NodeQuery interface.
type MockNodeQuery struct {
	ctrl     *gomock.Controller
	recorder *MockNodeQueryMockRecorder
	isgomock struct{}
}

// MockNodeQueryMockRecorder is the mock recorder for MockNodeQuery.
type MockNodeQueryMockRecorder struct {
	mock *MockNodeQuery
}

// NewMockNodeQuery creates a new mock instance.
func NewMockNodeQuery(ctrl *gomock.Controller) *MockNodeQuery {
	mock := &MockNodeQuery{ctrl: ctrl}
	mock.recorder = &MockNodeQueryMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockNodeQuery) EXPECT() *MockNodeQueryMockRecorder {
	return m.recorder
}

// Count mocks base method.
func (m *MockNodeQuery) Count() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Count")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Count indicates an expected call of Count.
func (mr *MockNodeQueryMockRecorder) Count() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Count", reflect.TypeOf((*MockNodeQuery)(nil).Count))
}

// Delete mocks base method.
func (m *MockNodeQuery) Delete() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete")
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete.
func (mr *MockNodeQueryMockRecorder) Delete() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockNodeQuery)(nil).Delete))
}

// Fetch mocks base method.
func (m *MockNodeQuery) Fetch(delegate func(graph.Cursor[*graph.Node]) error, finalCriteria ...graph.Criteria) error {
	m.ctrl.T.Helper()
	varargs := []any{delegate}
	for _, a := range finalCriteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Fetch", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Fetch indicates an expected call of Fetch.
func (mr *MockNodeQueryMockRecorder) Fetch(delegate any, finalCriteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{delegate}, finalCriteria...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockNodeQuery)(nil).Fetch), varargs...)
}

// FetchIDs mocks base method.
func (m *MockNodeQuery) FetchIDs(delegate func(graph.Cursor[graph.ID]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchIDs indicates an expected call of FetchIDs.
func (mr *MockNodeQueryMockRecorder) FetchIDs(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockNodeQuery)(nil).FetchIDs), delegate)
}

// FetchKinds mocks base method.
func (m *MockNodeQuery) FetchKinds(arg0 func(graph.Cursor[graph.KindsResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchKinds", arg0)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchKinds indicates an expected call of FetchKinds.
func (mr *MockNodeQueryMockRecorder) FetchKinds(arg0 any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchKinds", reflect.TypeOf((*MockNodeQuery)(nil).FetchKinds), arg0)
}

// Filter mocks base method.
func (m *MockNodeQuery) Filter(criteria graph.Criteria) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filter", criteria)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Filter indicates an expected call of Filter.
func (mr *MockNodeQueryMockRecorder) Filter(criteria any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filter", reflect.TypeOf((*MockNodeQuery)(nil).Filter), criteria)
}

// Filterf mocks base method.
func (m *MockNodeQuery) Filterf(criteriaDelegate graph.CriteriaProvider) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filterf", criteriaDelegate)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Filterf indicates an expected call of Filterf.
func (mr *MockNodeQueryMockRecorder) Filterf(criteriaDelegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filterf", reflect.TypeOf((*MockNodeQuery)(nil).Filterf), criteriaDelegate)
}

// First mocks base method.
func (m *MockNodeQuery) First() (*graph.Node, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "First")
	ret0, _ := ret[0].(*graph.Node)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// First indicates an expected call of First.
func (mr *MockNodeQueryMockRecorder) First() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "First", reflect.TypeOf((*MockNodeQuery)(nil).First))
}

// Limit mocks base method.
func (m *MockNodeQuery) Limit(skip int) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Limit", skip)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Limit indicates an expected call of Limit.
func (mr *MockNodeQueryMockRecorder) Limit(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Limit", reflect.TypeOf((*MockNodeQuery)(nil).Limit), skip)
}

// Offset mocks base method.
func (m *MockNodeQuery) Offset(skip int) graph.NodeQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Offset", skip)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// Offset indicates an expected call of Offset.
func (mr *MockNodeQueryMockRecorder) Offset(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Offset", reflect.TypeOf((*MockNodeQuery)(nil).Offset), skip)
}

// OrderBy mocks base method.
func (m *MockNodeQuery) OrderBy(criteria ...graph.Criteria) graph.NodeQuery {
	m.ctrl.T.Helper()
	varargs := []any{}
	for _, a := range criteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "OrderBy", varargs...)
	ret0, _ := ret[0].(graph.NodeQuery)
	return ret0
}

// OrderBy indicates an expected call of OrderBy.
func (mr *MockNodeQueryMockRecorder) OrderBy(criteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OrderBy", reflect.TypeOf((*MockNodeQuery)(nil).OrderBy), criteria...)
}

// Query mocks base method.
func (m *MockNodeQuery) Query(delegate func(graph.Result) error, finalCriteria ...graph.Criteria) error {
	m.ctrl.T.Helper()
	varargs := []any{delegate}
	for _, a := range finalCriteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Query", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Query indicates an expected call of Query.
func (mr *MockNodeQueryMockRecorder) Query(delegate any, finalCriteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{delegate}, finalCriteria...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MockNodeQuery)(nil).Query), varargs...)
}

// Update mocks base method.
func (m *MockNodeQuery) Update(properties *graph.Properties) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Update", properties)
	ret0, _ := ret[0].(error)
	return ret0
}

// Update indicates an expected call of Update.
func (mr *MockNodeQueryMockRecorder) Update(properties any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Update", reflect.TypeOf((*MockNodeQuery)(nil).Update), properties)
}

// MockRelationshipQuery is a mock of RelationshipQuery interface.
type MockRelationshipQuery struct {
	ctrl     *gomock.Controller
	recorder *MockRelationshipQueryMockRecorder
	isgomock struct{}
}

// MockRelationshipQueryMockRecorder is the mock recorder for MockRelationshipQuery.
type MockRelationshipQueryMockRecorder struct {
	mock *MockRelationshipQuery
}

// NewMockRelationshipQuery creates a new mock instance.
func NewMockRelationshipQuery(ctrl *gomock.Controller) *MockRelationshipQuery {
	mock := &MockRelationshipQuery{ctrl: ctrl}
	mock.recorder = &MockRelationshipQueryMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockRelationshipQuery) EXPECT() *MockRelationshipQueryMockRecorder {
	return m.recorder
}

// Count mocks base method.
func (m *MockRelationshipQuery) Count() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Count")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Count indicates an expected call of Count.
func (mr *MockRelationshipQueryMockRecorder) Count() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Count", reflect.TypeOf((*MockRelationshipQuery)(nil).Count))
}

// Delete mocks base method.
func (m *MockRelationshipQuery) Delete() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete")
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete.
func (mr *MockRelationshipQueryMockRecorder) Delete() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockRelationshipQuery)(nil).Delete))
}

// Fetch mocks base method.
func (m *MockRelationshipQuery) Fetch(delegate func(graph.Cursor[*graph.Relationship]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Fetch", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// Fetch indicates an expected call of Fetch.
func (mr *MockRelationshipQueryMockRecorder) Fetch(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockRelationshipQuery)(nil).Fetch), delegate)
}

// FetchAllShortestPaths mocks base method.
func (m *MockRelationshipQuery) FetchAllShortestPaths(delegate func(graph.Cursor[graph.Path]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchAllShortestPaths", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchAllShortestPaths indicates an expected call of FetchAllShortestPaths.
func (mr *MockRelationshipQueryMockRecorder) FetchAllShortestPaths(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchAllShortestPaths", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchAllShortestPaths), delegate)
}

// FetchDirection mocks base method.
func (m *MockRelationshipQuery) FetchDirection(direction graph.Direction, delegate func(graph.Cursor[graph.DirectionalResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchDirection", direction, delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchDirection indicates an expected call of FetchDirection.
func (mr *MockRelationshipQueryMockRecorder) FetchDirection(direction, delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchDirection", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchDirection), direction, delegate)
}

// FetchIDs mocks base method.
func (m *MockRelationshipQuery) FetchIDs(delegate func(graph.Cursor[graph.ID]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchIDs indicates an expected call of FetchIDs.
func (mr *MockRelationshipQueryMockRecorder) FetchIDs(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchIDs), delegate)
}

// FetchKinds mocks base method.
func (m *MockRelationshipQuery) FetchKinds(delegate func(graph.Cursor[graph.RelationshipKindsResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchKinds", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchKinds indicates an expected call of FetchKinds.
func (mr *MockRelationshipQueryMockRecorder) FetchKinds(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchKinds", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchKinds), delegate)
}

// FetchTriples mocks base method.
func (m *MockRelationshipQuery) FetchTriples(delegate func(graph.Cursor[graph.RelationshipTripleResult]) error) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTriples", delegate)
	ret0, _ := ret[0].(error)
	return ret0
}

// FetchTriples indicates an expected call of FetchTriples.
func (mr *MockRelationshipQueryMockRecorder) FetchTriples(delegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTriples", reflect.TypeOf((*MockRelationshipQuery)(nil).FetchTriples), delegate)
}

// Filter mocks base method.
func (m *MockRelationshipQuery) Filter(criteria graph.Criteria) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filter", criteria)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Filter indicates an expected call of Filter.
func (mr *MockRelationshipQueryMockRecorder) Filter(criteria any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filter", reflect.TypeOf((*MockRelationshipQuery)(nil).Filter), criteria)
}

// Filterf mocks base method.
func (m *MockRelationshipQuery) Filterf(criteriaDelegate graph.CriteriaProvider) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Filterf", criteriaDelegate)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Filterf indicates an expected call of Filterf.
func (mr *MockRelationshipQueryMockRecorder) Filterf(criteriaDelegate any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Filterf", reflect.TypeOf((*MockRelationshipQuery)(nil).Filterf), criteriaDelegate)
}

// First mocks base method.
func (m *MockRelationshipQuery) First() (*graph.Relationship, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "First")
	ret0, _ := ret[0].(*graph.Relationship)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// First indicates an expected call of First.
func (mr *MockRelationshipQueryMockRecorder) First() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "First", reflect.TypeOf((*MockRelationshipQuery)(nil).First))
}

// Limit mocks base method.
func (m *MockRelationshipQuery) Limit(skip int) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Limit", skip)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Limit indicates an expected call of Limit.
func (mr *MockRelationshipQueryMockRecorder) Limit(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Limit", reflect.TypeOf((*MockRelationshipQuery)(nil).Limit), skip)
}

// Offset mocks base method.
func (m *MockRelationshipQuery) Offset(skip int) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Offset", skip)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// Offset indicates an expected call of Offset.
func (mr *MockRelationshipQueryMockRecorder) Offset(skip any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Offset", reflect.TypeOf((*MockRelationshipQuery)(nil).Offset), skip)
}

// OrderBy mocks base method.
func (m *MockRelationshipQuery) OrderBy(criteria ...graph.Criteria) graph.RelationshipQuery {
	m.ctrl.T.Helper()
	varargs := []any{}
	for _, a := range criteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "OrderBy", varargs...)
	ret0, _ := ret[0].(graph.RelationshipQuery)
	return ret0
}

// OrderBy indicates an expected call of OrderBy.
func (mr *MockRelationshipQueryMockRecorder) OrderBy(criteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OrderBy", reflect.TypeOf((*MockRelationshipQuery)(nil).OrderBy), criteria...)
}

// Query mocks base method.
func (m *MockRelationshipQuery) Query(delegate func(graph.Result) error, finalCriteria ...graph.Criteria) error {
	m.ctrl.T.Helper()
	varargs := []any{delegate}
	for _, a := range finalCriteria {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "Query", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// Query indicates an expected call of Query.
func (mr *MockRelationshipQueryMockRecorder) Query(delegate any, finalCriteria ...any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]any{delegate}, finalCriteria...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MockRelationshipQuery)(nil).Query), varargs...)
}

// Update mocks base method.
func (m *MockRelationshipQuery) Update(properties *graph.Properties) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Update", properties)
	ret0, _ := ret[0].(error)
	return ret0
}

// Update indicates an expected call of Update.
func (mr *MockRelationshipQueryMockRecorder) Update(properties any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Update", reflect.TypeOf((*MockRelationshipQuery)(nil).Update), properties)
}
