"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var CypherTypes = _interopRequireWildcard(require("../../lang/CypherTypes"));
var CompletionTypes = _interopRequireWildcard(require("../CompletionTypes"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// If we are in relationship pattern then return variables and types
var _default = element => {
  const parent = element.getParent ? element.getParent() : null;
  const text = element.getText();
  // Special case. We are at the beginning of first node pattern.
  if (parent) {
    if (parent instanceof CypherTypes.PATTERN_ELEMENT_CONTEXT && text === "(") {
      return [{
        type: CompletionTypes.VARIABLE
      }, {
        type: CompletionTypes.LABEL
      }];
    }
    if (parent instanceof CypherTypes.NODE_PATTERN_CONTEXT) {
      // We are at the begining of node pattern
      if (text === "(") {
        return [{
          type: CompletionTypes.VARIABLE
        }, {
          type: CompletionTypes.LABEL
        }];
      }
      if (text === ":") {
        return [{
          type: CompletionTypes.LABEL
        }];
      }
    }
  }
  return [];
};
exports.default = _default;