// Copyright 2023 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

import { Alert, AlertTitle, Container } from '@mui/material';

const GenericErrorBoundaryFallback = () => {
    return (
        <Container maxWidth='xl'>
            <div className='py-4 flex justify-end' data-testid='error-boundary'>
                <Alert severity='error'>
                    <AlertTitle>Error</AlertTitle>
                    An unexpected error has occurred. Please refresh the page and try again.
                </Alert>
            </div>
        </Container>
    );
};

export default GenericErrorBoundaryFallback;
