#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Theme Hospital
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250223.5

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='theme-hospital'
GAME_NAME='Theme Hospital'

ARCHIVE_BASE_2_NAME='setup_theme_hospital_v3_(28027).exe'
ARCHIVE_BASE_2_MD5='cb1a467f48532d3607fa5b9dd571a342'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_SIZE='198293'
ARCHIVE_BASE_2_VERSION='1.0-gog28027'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/theme_hospital'

ARCHIVE_BASE_1_NAME='setup_theme_hospital_v3_(28027).exe'
ARCHIVE_BASE_1_MD5='e4cba7cfddd5dd2d4baf4761bc86a8c8'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='200000'
ARCHIVE_BASE_1_VERSION='1.0-gog28027'

ARCHIVE_BASE_0_NAME='setup_theme_hospital_2.1.0.8.exe'
ARCHIVE_BASE_0_MD5='c1dc6cd19a3e22f7f7b31a72957babf7'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='210000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.7'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_DOSBOX_FILES='
connect.bat
dos4gw.exe
hospital.exe
hospital.cfg
modem.ini'
CONTENT_GAME_DATA_FILES='
anims
cfg
data
datam
intro
levels
qdata
qdatam
save
sound'
CONTENT_DOC_DATA_FILES='
manual.pdf
netplay.txt
readme.txt'

USER_PERSISTENT_DIRECTORIES='
save'
USER_PERSISTENT_FILES='
*.cfg
*.ini'

APP_MAIN_EXE='hospital.exe'
APP_MAIN_TYPE_CORSIXTH='custom'
APP_MAIN_ICON='app/goggame-1207659026.ico'
APP_MAIN_ICON_0='goggame-1207659026.ico'

PACKAGES_LIST='
PKG_DOSBOX
PKG_CORSIXTH
PKG_DATA'

PKG_ENGINE_ID="$GAME_ID"

PKG_DOSBOX_ID="${PKG_ENGINE_ID}-dosbox"
PKG_DOSBOX_PROVIDES="
$PKG_ENGINE_ID"
PKG_DOSBOX_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_CORSIXTH_ID="${PKG_ENGINE_ID}-corsixth"
PKG_CORSIXTH_PROVIDES="
$PKG_ENGINE_ID"
PKG_CORSIXTH_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_CORSIXTH_DEPENDENCIES_COMMANDS='
corsix-th'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## DOSBox

launchers_generation 'PKG_DOSBOX'

## CorsixTH

custom_launcher() {
	launcher_headers
	cat <<- 'OUTEREOF'
	# Set the path to game data on first launch
	config_path="${XDG_CONFIG_HOME:-"${HOME}/.config"}/CorsixTH/config.txt"
	if [ ! -e "$config_path" ]; then
	    mkdir --parents "$(dirname "$config_path")"
	    cat > "$config_path" <<- EOF
	OUTEREOF
	cat <<- OUTEREOF
	    theme_hospital_install = [[$(path_game_data)]]
	OUTEREOF
	cat <<- 'OUTEREOF'
	    EOF
	fi

	corsix-th "$@"

	OUTEREOF
	launcher_exit
}
launchers_generation 'PKG_CORSIXTH'

# Build packages

packages_generation
printf '\n'
printf 'CorsixTH:'
print_instructions 'PKG_DATA' 'PKG_CORSIXTH'
printf 'DOSBox:'
print_instructions 'PKG_DATA' 'PKG_DOSBOX'

# Clean up

working_directory_cleanup

exit 0
