/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef UKCCPLUGIN_H
#define UKCCPLUGIN_H

#include <QObject>
#include <QWidget>
#include <QTranslator>
#include <QIcon>
#include <QLocale>
#include <QApplication>

#include <ukcc/interface/interface.h>
#include <ukcc/widgets/titlelabel.h>
#include <ukcc/widgets/comboxframe.h>
#include <ukcc/widgets/fixlabel.h>
#include "kswitchbutton.h"

#include "alwaysdisplayonpanel.h"
#include "generalsettings.h"
using namespace kdk;


#include <QVBoxLayout>

class UkccPlugin : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:

    UkccPlugin();
    ~UkccPlugin();

    QString plugini18nName()        Q_DECL_OVERRIDE;
    int pluginTypes()               Q_DECL_OVERRIDE;
    QWidget *pluginUi()             Q_DECL_OVERRIDE;
    bool isEnable() const           Q_DECL_OVERRIDE;
    const QString name() const      Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const   Q_DECL_OVERRIDE;
    QIcon icon() const              Q_DECL_OVERRIDE;
    QString translationPath() const Q_DECL_OVERRIDE;

    void initUI();
    void setFrame_Noframe(QFrame *frame);
    void displayBtnOnPanel();
    void generalSettings();
    QFrame *setLine(QFrame *frame);

private:
    QString pluginName;
    int pluginType;
    QWidget *widget;
    bool mFirstLoad;

    QVBoxLayout *mverticalLayout;
    TitleLabel *CustomTitleLabel;
    TitleLabel *m_panelDisplayLabel;
    AlwaysDisplayonPanel *m_alwaysDisplayonPanelFrame;
    GeneralSettings *m_generalSettingsFrame;

private:
    void initSearchText();      // 搜索翻译
};

#endif // UKCCPLUGIN_H
