from __future__ import absolute_import, division, print_function
from libtbx.test_utils import approx_equal, show_diff
import iotbx.ncs as ncs
import iotbx.pdb
import sys, os
from iotbx.ncs import ncs_group_master_phil
import iotbx.phil

pdb_str_1 = """
CRYST1  399.000  399.000  399.000  90.00  90.00  90.00 P 1
ATOM      1  N   GLY A  34     125.208 211.886 175.417  1.00  0.00           N
ATOM      2  CA  GLY A  34     125.035 211.123 174.168  1.00  0.00           C
ATOM      3  C   GLY A  34     126.386 210.806 173.507  1.00  0.00           C
ATOM      4  O   GLY A  34     127.304 211.628 173.503  1.00  0.00           O
TER
ATOM      5  N   GLY B  34     251.532 143.432 175.422  1.00  0.00           N
ATOM      6  CA  GLY B  34     252.120 143.948 174.173  1.00  0.00           C
ATOM      7  C   GLY B  34     251.212 144.998 173.512  1.00  0.00           C
ATOM      8  O   GLY B  34     249.986 144.872 173.510  1.00  0.00           O
TER
ATOM      9  N   GLY C  34     189.583 273.076 175.423  1.00  0.00           N
ATOM     10  CA  GLY C  34     188.804 273.006 174.173  1.00  0.00           C
ATOM     11  C   GLY C  34     188.920 271.622 173.510  1.00  0.00           C
ATOM     12  O   GLY C  34     189.986 271.004 173.508  1.00  0.00           O
TER
"""

pdb_str_2 = """
CRYST1  399.000  399.000  399.000  90.00  90.00  90.00 P 1
ATOM      1  O   HOH S   1     109.583 203.076 175.423  1.00  0.00           O
TER
ATOM      1  N   GLY A  34     125.208 211.886 175.417  1.00  0.00           N
ATOM      2  CA  GLY A  34     125.035 211.123 174.168  1.00  0.00           C
ATOM      3  C   GLY A  34     126.386 210.806 173.507  1.00  0.00           C
ATOM      4  O   GLY A  34     127.304 211.628 173.503  1.00  0.00           O
TER
ATOM      5  N   GLY B  34     251.532 143.432 175.422  1.00  0.00           N
ATOM      6  CA  GLY B  34     252.120 143.948 174.173  1.00  0.00           C
ATOM      7  C   GLY B  34     251.212 144.998 173.512  1.00  0.00           C
ATOM      8  O   GLY B  34     249.986 144.872 173.510  1.00  0.00           O
TER
ATOM      9  N   GLY C  34     189.583 273.076 175.423  1.00  0.00           N
ATOM     10  CA  GLY C  34     188.804 273.006 174.173  1.00  0.00           C
ATOM     11  C   GLY C  34     188.920 271.622 173.510  1.00  0.00           C
ATOM     12  O   GLY C  34     189.986 271.004 173.508  1.00  0.00           O
TER
ATOM      9  O   TYR D   4     189.583 273.076 175.423  1.00  0.00           O
TER
"""

pdb_str_5 = """
ATOM      1  N   MET A   1     158.070 173.095 147.115  1.00 50.00           N
ATOM      2  CA  MET A   1     157.408 172.627 148.359  1.00 50.00           C
ATOM      3  CB  MET A   1     157.550 171.094 148.516  1.00 50.00           C
ATOM      4  CG  MET A   1     156.748 170.503 149.691  1.00 50.00           C
ATOM      5  SD  MET A   1     154.968 170.855 149.612  1.00 50.00           S
ATOM      6  CE  MET A   1     154.505 169.913 151.091  1.00 50.00           C
ATOM      7  C   MET A   1     157.958 173.331 149.563  1.00 50.00           C
ATOM      8  O   MET A   1     157.196 173.814 150.399  1.00 50.00           O
TER
ATOM      9  N   MET B   1     174.781 155.306 150.054  1.00 50.00           N
ATOM     10  CA  MET B   1     174.332 154.630 151.298  1.00 50.00           C
ATOM     11  CB  MET B   1     175.016 153.251 151.453  1.00 50.00           C
ATOM     12  CG  MET B   1     174.481 152.410 152.628  1.00 50.00           C
ATOM     13  SD  MET B   1     172.693 152.099 152.550  1.00 50.00           S
ATOM     14  CE  MET B   1     172.601 151.052 154.028  1.00 50.00           C
ATOM     15  C   MET B   1     174.594 155.484 152.502  1.00 50.00           C
ATOM     16  O   MET B   1     173.710 155.660 153.339  1.00 50.00           O
TER
ATOM     17  N   MET C   1     148.867 195.697 144.146  1.00 50.00           N
ATOM     18  CA  MET C   1     148.080 195.499 145.390  1.00 50.00           C
ATOM     19  CB  MET C   1     147.662 194.018 145.549  1.00 50.00           C
ATOM     20  CG  MET C   1     146.701 193.755 146.723  1.00 50.00           C
ATOM     21  SD  MET C   1     145.166 194.723 146.643  1.00 50.00           S
ATOM     22  CE  MET C   1     144.395 194.012 148.122  1.00 50.00           C
ATOM     23  C   MET C   1     148.846 195.960 146.594  1.00 50.00           C
ATOM     24  O   MET C   1     148.308 196.685 147.429  1.00 50.00           O
TER
ATOM    417  N   MET 1   1     274.499 237.478  69.907  1.00 50.00           N
ATOM    418  CA  MET 1   1     275.223 237.861  71.146  1.00 50.00           C
ATOM    419  CB  MET 1   1     275.281 239.400  71.298  1.00 50.00           C
ATOM    420  CG  MET 1   1     276.159 239.886  72.466  1.00 50.00           C
ATOM    421  SD  MET 1   1     277.878 239.307  72.379  1.00 50.00           S
ATOM    422  CE  MET 1   1     278.468 240.186  73.852  1.00 50.00           C
ATOM    423  C   MET 1   1     274.593 237.238  72.356  1.00 50.00           C
ATOM    424  O   MET 1   1     275.291 236.663  73.190  1.00 50.00           O
TER
END
"""

pdb_str_6 = """\
CRYST1  577.812  448.715  468.790  90.00  90.00  90.00 P 1
ATOM      1  CA  LYS A 151      10.766   9.333  12.905  1.00 44.22           C
ATOM      2  CA  LYS A 152      10.117   9.159  11.610  1.00 49.42           C
ATOM      3  CA  LYS A 153       9.099   8.000  11.562  1.00 46.15           C
ATOM      4  CA  LYS A 154       8.000   8.202  11.065  1.00 52.97           C
ATOM      5  CA  LYS A 155      11.146   9.065  10.474  1.00 41.68           C
ATOM      6  CA  LYS A 156      10.547   9.007   9.084  1.00 55.55           C
TER
ATOM      7  CA  LYS B 157      11.545   9.413   8.000  1.00 72.27           C
ATOM      8  CA  LYS B 158      12.277  10.718   8.343  1.00 75.78           C
ATOM      9  CA  LYS B 159      11.349  11.791   8.809  1.00 75.88           C
TER
ATOM      7  CA  LYS F 157       2.154   3.953  16.298  1.00 72.27           C
ATOM      8  CA  LYS F 158       2.014   3.732  17.811  1.00 75.78           C
ATOM      9  CA  LYS F 159       2.558   2.413  18.250  1.00 75.88           C
TER
ATOM      7  CA  LYS D 157       4.334  10.965  12.119  1.00 72.27           C
ATOM      8  CA  LYS D 158       4.057  11.980  13.238  1.00 75.78           C
ATOM      9  CA  LYS D 159       3.177  11.427  14.310  1.00 75.88           C
TER
ATOM      1  CA  LYS C 151       6.855   8.667  15.730  1.00 44.22           C
ATOM      2  CA  LYS C 152       5.891   8.459  14.655  1.00 49.42           C
ATOM      3  CA  LYS C 153       6.103   7.155  13.858  1.00 46.15           C
ATOM      4  CA  LYS C 154       5.138   6.438  13.633  1.00 52.97           C
ATOM      5  CA  LYS C 155       5.801   9.685  13.736  1.00 41.68           C
ATOM      6  CA  LYS C 156       4.731   9.594  12.667  1.00 55.55           C
TER
ATOM      1  CA  LYS E 151       6.987   4.106  17.432  1.00 44.22           C
ATOM      2  CA  LYS E 152       6.017   3.539  16.502  1.00 49.42           C
ATOM      3  CA  LYS E 153       6.497   3.492  15.036  1.00 46.15           C
ATOM      4  CA  LYS E 154       6.348   2.458  14.400  1.00 52.97           C
ATOM      5  CA  LYS E 155       4.647   4.221  16.634  1.00 41.68           C
ATOM      6  CA  LYS E 156       3.552   3.605  15.788  1.00 55.55           C
TER
"""

pdb_str_7 = """\
CRYST1  577.812  448.715  468.790  90.00  90.00  90.00 P 1
ATOM      1  CA  LYS A 151      10.766   9.333  12.905  1.00 44.22           C
ATOM      2  CA  LYS A 152      10.117   9.159  11.610  1.00 49.42           C
ATOM      3  CA  LYS A 153       9.099   8.000  11.562  1.00 46.15           C
ATOM      4  CA  LYS A 154       8.000   8.202  11.065  1.00 52.97           C
ATOM      5  CA  LYS A 155      11.146   9.065  10.474  1.00 41.68           C
TER
ATOM    222  CA  LEU X  40      94.618  -5.253  91.582  1.00 87.10           C
ATOM    223  CA  ARG X  41      62.395  51.344  80.786  1.00107.25           C
ATOM    224  CA  ARG X  42      62.395  41.344  80.786  1.00107.25           C
TER
ATOM      1  CA  THR D   1       8.111  11.080  10.645  1.00 20.00           C
ATOM      2  CA  THR D   2       8.000   9.722  10.125  1.00 20.00           C
ATOM      3  CA  THR D   3       8.075   8.694  11.249  1.00 20.00           C
ATOM      4  CA  THR D   4       8.890   8.818  12.163  1.00 20.00           C
TER
ATOM      1  CA  LYS B 151       6.855   8.667  15.730  1.00 44.22           C
ATOM      2  CA  LYS B 152       5.891   8.459  14.655  1.00 49.42           C
ATOM      3  CA  LYS B 153       6.103   7.155  13.858  1.00 46.15           C
ATOM      4  CA  LYS B 154       5.138   6.438  13.633  1.00 52.97           C
ATOM      5  CA  LYS B 155       5.801   9.685  13.736  1.00 41.68           C
TER
ATOM      1  CA  LYS C 151       6.987   4.106  17.432  1.00 44.22           C
ATOM      2  CA  LYS C 152       6.017   3.539  16.502  1.00 49.42           C
ATOM      3  CA  LYS C 153       6.497   3.492  15.036  1.00 46.15           C
ATOM      4  CA  LYS C 154       6.348   2.458  14.400  1.00 52.97           C
ATOM      5  CA  LYS C 155       4.647   4.221  16.634  1.00 41.68           C
TER
ATOM    222  CA  LEU Y  40     194.618   5.253  81.582  1.00 87.10           C
ATOM    223  CA  ARG Y  41     162.395  41.344  70.786  1.00107.25           C
ATOM    224  CA  ARG Y  42     162.395  31.344  70.786  1.00107.25           C
TER
ATOM      1  CA  THR E   1       8.111 -10.645  11.080  1.00 20.00           C
ATOM      2  CA  THR E   2       8.000 -10.125   9.722  1.00 20.00           C
ATOM      3  CA  THR E   3       8.075 -11.249   8.694  1.00 20.00           C
ATOM      4  CA  THR E   4       8.890 -12.163   8.818  1.00 20.00           C
TER
"""

pdb_str_8 = """\
ATOM      1  N   THR A   1      13.014  18.419   8.520  1.00 20.00           N
ATOM      2  CA  THR A   1      12.903  17.061   8.000  1.00 20.00           C
ATOM      3  C   THR A   1      12.978  16.033   9.124  1.00 20.00           C
ATOM      4  O   THR A   1      13.793  16.157  10.038  1.00 20.00           O
TER
ATOM      1  N   THR C   1      10.325   8.000  14.368  1.00 20.00           N
ATOM      2  CA  THR C   1      10.111   8.702  13.108  1.00 20.00           C
ATOM      3  C   THR C   1      11.313   9.570  12.750  1.00 20.00           C
ATOM      4  O   THR C   1      11.885  10.241  13.609  1.00 20.00           O
TER
ATOM      1  N   THR D   1      -0.430  15.458  18.495  1.00 20.00           N
ATOM      2  CA  THR D   1       0.086  15.020  17.204  1.00 20.00           C
ATOM      3  C   THR D   1       1.440  14.334  17.355  1.00 20.00           C
ATOM      4  O   THR D   1       2.297  14.791  18.111  1.00 20.00           O
TER
ATOM      1  N   THR E   1       1.895   8.366  19.752  1.00 20.00           N
ATOM      2  CA  THR E   1       1.682   9.068  18.491  1.00 20.00           C
ATOM      3  C   THR E   1       2.884   9.935  18.133  1.00 20.00           C
ATOM      4  O   THR E   1       3.455  10.606  18.993  1.00 20.00           O
TER
ATOM      1  N   THR F   1       8.346   7.308  15.936  1.00 20.00           N
ATOM      2  CA  THR F   1       7.054   7.796  15.467  1.00 20.00           C
ATOM      3  C   THR F   1       6.884   9.281  15.767  1.00 20.00           C
ATOM      4  O   THR F   1       7.237   9.751  16.849  1.00 20.00           O
TER
ATOM      1  N   THR G   1       0.609  -0.560  24.094  1.00 20.00           N
ATOM      2  CA  THR G   1       0.395   0.142  22.834  1.00 20.00           C
ATOM      3  C   THR G   1       1.598   1.009  22.476  1.00 20.00           C
ATOM      4  O   THR G   1       2.169   1.680  23.335  1.00 20.00           O
TER
ATOM      1  N   THR H   1       7.061  -1.617  20.279  1.00 20.00           N
ATOM      2  CA  THR H   1       5.768  -1.130  19.810  1.00 20.00           C
ATOM      3  C   THR H   1       5.599   0.356  20.109  1.00 20.00           C
ATOM      4  O   THR H   1       5.950   0.825  21.191  1.00 20.00           O
TER
ATOM      1  N   THR I   1       8.722   4.822  16.665  1.00 20.00           N
ATOM      2  CA  THR I   1       7.494   4.036  16.653  1.00 20.00           C
ATOM      3  C   THR I   1       6.628   4.350  17.868  1.00 20.00           C
ATOM      4  O   THR I   1       7.130   4.482  18.984  1.00 20.00           O
TER
ATOM      1  N   THR B   1       8.000  15.093  13.112  1.00 20.00           N
ATOM      2  CA  THR B   1       8.516  14.654  11.820  1.00 20.00           C
ATOM      3  C   THR B   1       9.870  13.968  11.972  1.00 20.00           C
ATOM      4  O   THR B   1      10.727  14.426  12.727  1.00 20.00           O
TER
"""

pdb_str_9 = """\
ATOM     45  N   PHEAa   6     221.693 146.930 114.416  1.00 50.00           N
ATOM     46  CA  PHEAa   6     220.871 148.020 114.886  1.00 50.00           C
ATOM     47  C   PHEAa   6     219.413 147.628 114.926  1.00 50.00           C
ATOM     48  O   PHEAa   6     218.730 147.905 115.908  1.00 50.00           O
ATOM     49  CB  PHEAa   6     221.058 149.265 113.976  1.00 50.00           C
ATOM     50  CG  PHEAa   6     220.338 150.481 114.498  1.00 50.00           C
ATOM     51  CD1 PHEAa   6     220.740 151.082 115.702  1.00 50.00           C
ATOM     52  CD2 PHEAa   6     219.240 151.016 113.801  1.00 50.00           C
ATOM     53  CE1 PHEAa   6     220.059 152.198 116.204  1.00 50.00           C
ATOM     54  CE2 PHEAa   6     218.557 152.133 114.299  1.00 50.00           C
ATOM     55  CZ  PHEAa   6     218.965 152.723 115.500  1.00 50.00           C
ATOM     56  N   ASNAa   7     218.926 146.940 113.868  1.00 50.00           N
ATOM     57  CA  ASNAa   7     217.565 146.462 113.741  1.00 50.00           C
ATOM     58  C   ASNAa   7     217.229 145.425 114.782  1.00 50.00           C
ATOM     59  O   ASNAa   7     216.113 145.412 115.283  1.00 50.00           O
ATOM     60  CB  ASNAa   7     217.235 145.875 112.347  1.00 50.00           C
ATOM     61  CG  ASNAa   7     217.277 146.970 111.271  1.00 50.00           C
ATOM     62  OD1 ASNAa   7     217.061 148.155 111.550  1.00 50.00           O
ATOM     63  ND2 ASNAa   7     217.551 146.541 110.002  1.00 50.00           N
ATOM     64  N   LEUAa   8     218.185 144.528 115.129  1.00 50.00           N
ATOM     65  CA  LEUAa   8     217.998 143.485 116.117  1.00 50.00           C
ATOM     66  C   LEUAa   8     217.846 144.051 117.505  1.00 50.00           C
ATOM     67  O   LEUAa   8     217.002 143.585 118.265  1.00 50.00           O
ATOM     68  CB  LEUAa   8     219.168 142.476 116.143  1.00 50.00           C
ATOM     69  CG  LEUAa   8     219.217 141.553 114.906  1.00 50.00           C
ATOM     70  CD1 LEUAa   8     220.600 140.889 114.770  1.00 50.00           C
ATOM     71  CD2 LEUAa   8     218.098 140.493 114.925  1.00 50.00           C
ATOM     72  N   LYSAa   9     218.665 145.069 117.866  1.00 50.00           N
ATOM     73  CA  LYSAa   9     218.573 145.769 119.133  1.00 50.00           C
ATOM     74  C   LYSAa   9     217.287 146.554 119.234  1.00 50.00           C
ATOM     75  O   LYSAa   9     216.682 146.606 120.301  1.00 50.00           O
ATOM     76  CB  LYSAa   9     219.751 146.744 119.364  1.00 50.00           C
ATOM     77  CG  LYSAa   9     221.113 146.057 119.558  1.00 50.00           C
ATOM     78  CD  LYSAa   9     221.257 145.305 120.891  1.00 50.00           C
ATOM     79  CE  LYSAa   9     222.646 144.673 121.065  1.00 50.00           C
ATOM     80  NZ  LYSAa   9     222.723 143.882 122.315  1.00 50.00           N
TER
ATOM   1244  N   PHEAb   1     305.367 162.705 105.239  1.00 50.00           N
ATOM   1245  CA  PHEAb   1     304.396 162.991 106.331  1.00 50.00           C
ATOM   1246  C   PHEAb   1     304.285 164.473 106.586  1.00 50.00           C
ATOM   1247  O   PHEAb   1     304.837 165.292 105.851  1.00 50.00           O
ATOM   1248  CB  PHEAb   1     304.743 162.176 107.627  1.00 50.00           C
ATOM   1249  CG  PHEAb   1     305.801 162.775 108.540  1.00 50.00           C
ATOM   1250  CD1 PHEAb   1     307.055 163.195 108.061  1.00 50.00           C
ATOM   1251  CD2 PHEAb   1     305.501 162.973 109.900  1.00 50.00           C
ATOM   1252  CE1 PHEAb   1     307.967 163.838 108.909  1.00 50.00           C
ATOM   1253  CE2 PHEAb   1     306.412 163.612 110.751  1.00 50.00           C
ATOM   1254  CZ  PHEAb   1     307.642 164.054 110.251  1.00 50.00           C
ATOM   1255  N   LYSAb   2     303.607 164.838 107.696  1.00 50.00           N
ATOM   1256  CA  LYSAb   2     303.542 166.190 108.180  1.00 50.00           C
ATOM   1257  C   LYSAb   2     303.642 166.054 109.667  1.00 50.00           C
ATOM   1258  O   LYSAb   2     302.934 165.255 110.277  1.00 50.00           O
ATOM   1259  CB  LYSAb   2     302.234 166.947 107.855  1.00 50.00           C
ATOM   1260  CG  LYSAb   2     302.035 167.201 106.352  1.00 50.00           C
ATOM   1261  CD  LYSAb   2     300.842 168.117 106.023  1.00 50.00           C
ATOM   1262  CE  LYSAb   2     301.067 169.582 106.424  1.00 50.00           C
ATOM   1263  NZ  LYSAb   2     299.910 170.421 106.031  1.00 50.00           N
ATOM   1264  N   ALAAb   3     304.533 166.867 110.282  1.00 50.00           N
ATOM   1265  CA  ALAAb   3     304.840 166.840 111.692  1.00 50.00           C
ATOM   1266  C   ALAAb   3     303.670 167.320 112.503  1.00 50.00           C
ATOM   1267  O   ALAAb   3     303.399 166.803 113.583  1.00 50.00           O
ATOM   1268  CB  ALAAb   3     306.055 167.711 112.038  1.00 50.00           C
ATOM   1269  N   GLUAb   4     302.961 168.344 111.975  1.00 50.00           N
ATOM   1270  CA  GLUAb   4     301.784 168.942 112.560  1.00 50.00           C
ATOM   1271  C   GLUAb   4     300.678 167.941 112.768  1.00 50.00           C
ATOM   1272  O   GLUAb   4     300.094 167.886 113.848  1.00 50.00           O
ATOM   1273  CB  GLUAb   4     301.233 170.108 111.709  1.00 50.00           C
ATOM   1274  CG  GLUAb   4     302.268 171.215 111.421  1.00 50.00           C
ATOM   1275  CD  GLUAb   4     302.808 171.795 112.727  1.00 50.00           C
ATOM   1276  OE1 GLUAb   4     304.040 171.677 112.965  1.00 50.00           O
ATOM   1277  OE2 GLUAb   4     301.994 172.363 113.504  1.00 50.00           O
TER
ATOM   2754  N   PHEAc   6     244.472 153.067 117.352  1.00 50.00           N
ATOM   2755  CA  PHEAc   6     243.314 153.789 117.823  1.00 50.00           C
ATOM   2756  C   PHEAc   6     242.094 152.900 117.864  1.00 50.00           C
ATOM   2757  O   PHEAc   6     241.358 152.912 118.847  1.00 50.00           O
ATOM   2758  CB  PHEAc   6     243.040 155.017 116.913  1.00 50.00           C
ATOM   2759  CG  PHEAc   6     241.932 155.894 117.436  1.00 50.00           C
ATOM   2760  CD1 PHEAc   6     242.091 156.600 118.639  1.00 50.00           C
ATOM   2761  CD2 PHEAc   6     240.715 155.999 116.739  1.00 50.00           C
ATOM   2762  CE1 PHEAc   6     241.055 157.396 119.141  1.00 50.00           C
ATOM   2763  CE2 PHEAc   6     239.676 156.795 117.237  1.00 50.00           C
ATOM   2764  CZ  PHEAc   6     239.846 157.493 118.439  1.00 50.00           C
ATOM   2765  N   ASNAc   7     241.886 152.082 116.806  1.00 50.00           N
ATOM   2766  CA  ASNAc   7     240.788 151.148 116.680  1.00 50.00           C
ATOM   2767  C   ASNAc   7     240.847 150.058 117.721  1.00 50.00           C
ATOM   2768  O   ASNAc   7     239.810 149.645 118.224  1.00 50.00           O
ATOM   2769  CB  ASNAc   7     240.690 150.481 115.286  1.00 50.00           C
ATOM   2770  CG  ASNAc   7     240.334 151.517 114.210  1.00 50.00           C
ATOM   2771  OD1 ASNAc   7     239.707 152.544 114.490  1.00 50.00           O
ATOM   2772  ND2 ASNAc   7     240.743 151.215 112.941  1.00 50.00           N
ATOM   2773  N   LEUAc   8     242.062 149.565 118.068  1.00 50.00           N
ATOM   2774  CA  LEUAc   8     242.264 148.525 119.056  1.00 50.00           C
ATOM   2775  C   LEUAc   8     241.919 148.999 120.443  1.00 50.00           C
ATOM   2776  O   LEUAc   8     241.299 148.260 121.204  1.00 50.00           O
ATOM   2777  CB  LEUAc   8     243.717 148.003 119.082  1.00 50.00           C
ATOM   2778  CG  LEUAc   8     244.094 147.160 117.844  1.00 50.00           C
ATOM   2779  CD1 LEUAc   8     245.623 147.037 117.707  1.00 50.00           C
ATOM   2780  CD2 LEUAc   8     243.430 145.768 117.864  1.00 50.00           C
ATOM   2781  N   LYSAc   9     242.317 150.242 120.804  1.00 50.00           N
ATOM   2782  CA  LYSAc   9     241.981 150.863 122.071  1.00 50.00           C
ATOM   2783  C   LYSAc   9     240.499 151.134 122.173  1.00 50.00           C
ATOM   2784  O   LYSAc   9     239.916 150.965 123.241  1.00 50.00           O
ATOM   2785  CB  LYSAc   9     242.729 152.197 122.302  1.00 50.00           C
ATOM   2786  CG  LYSAc   9     244.248 152.045 122.495  1.00 50.00           C
ATOM   2787  CD  LYSAc   9     244.653 151.394 123.828  1.00 50.00           C
ATOM   2788  CE  LYSAc   9     246.177 151.304 124.001  1.00 50.00           C
ATOM   2789  NZ  LYSAc   9     246.534 150.594 125.250  1.00 50.00           N
TER
ATOM   3953  N   PHEAd   1     316.882 197.854 108.123  1.00 50.00           N
ATOM   3954  CA  PHEAd   1     315.875 197.773 109.215  1.00 50.00           C
ATOM   3955  C   PHEAd   1     315.239 199.116 109.471  1.00 50.00           C
ATOM   3956  O   PHEAd   1     315.460 200.078 108.736  1.00 50.00           O
ATOM   3957  CB  PHEAd   1     316.493 197.136 110.512  1.00 50.00           C
ATOM   3958  CG  PHEAd   1     317.265 198.076 111.424  1.00 50.00           C
ATOM   3959  CD1 PHEAd   1     318.283 198.919 110.944  1.00 50.00           C
ATOM   3960  CD2 PHEAd   1     316.915 198.154 112.784  1.00 50.00           C
ATOM   3961  CE1 PHEAd   1     318.905 199.846 111.792  1.00 50.00           C
ATOM   3962  CE2 PHEAd   1     317.536 199.077 113.635  1.00 50.00           C
ATOM   3963  CZ  PHEAd   1     318.525 199.932 113.135  1.00 50.00           C
ATOM   3964  N   LYSAd   2     314.475 199.212 110.581  1.00 50.00           N
ATOM   3965  CA  LYSAd   2     313.929 200.450 111.066  1.00 50.00           C
ATOM   3966  C   LYSAd   2     314.073 200.360 112.553  1.00 50.00           C
ATOM   3967  O   LYSAd   2     313.699 199.360 113.163  1.00 50.00           O
ATOM   3968  CB  LYSAd   2     312.437 200.687 110.742  1.00 50.00           C
ATOM   3969  CG  LYSAd   2     312.159 200.852 109.239  1.00 50.00           C
ATOM   3970  CD  LYSAd   2     310.717 201.278 108.910  1.00 50.00           C
ATOM   3971  CE  LYSAd   2     310.400 202.726 109.311  1.00 50.00           C
ATOM   3972  NZ  LYSAd   2     309.019 203.094 108.919  1.00 50.00           N
ATOM   3973  N   ALAAd   3     314.612 201.440 113.166  1.00 50.00           N
ATOM   3974  CA  ALAAd   3     314.909 201.525 114.577  1.00 50.00           C
ATOM   3975  C   ALAAd   3     313.646 201.552 115.389  1.00 50.00           C
ATOM   3976  O   ALAAd   3     313.579 200.972 116.469  1.00 50.00           O
ATOM   3977  CB  ALAAd   3     315.731 202.774 114.922  1.00 50.00           C
ATOM   3978  N   GLUAd   4     312.615 202.253 114.862  1.00 50.00           N
ATOM   3979  CA  GLUAd   4     311.303 202.387 115.448  1.00 50.00           C
ATOM   3980  C   GLUAd   4     310.630 201.057 115.656  1.00 50.00           C
ATOM   3981  O   GLUAd   4     310.105 200.796 116.737  1.00 50.00           O
ATOM   3982  CB  GLUAd   4     310.369 203.279 114.597  1.00 50.00           C
ATOM   3983  CG  GLUAd   4     310.938 204.683 114.308  1.00 50.00           C
ATOM   3984  CD  GLUAd   4     311.233 205.418 115.614  1.00 50.00           C
ATOM   3985  OE1 GLUAd   4     312.425 205.752 115.850  1.00 50.00           O
ATOM   3986  OE2 GLUAd   4     310.271 205.657 116.392  1.00 50.00           O
TER
END
"""

pdb_str_10 = """\
ATOM    181  CA  SER L  26      43.792 -65.179  67.649  1.00 22.76           C
ATOM    182  C   SER L  26      43.921 -63.740  68.152  1.00 25.79           C
ATOM    183  O   SER L  26      44.600 -63.476  69.148  1.00 27.95           O
ATOM    184  CB  SER L  26      45.023 -65.575  66.834  1.00 23.39           C
ATOM    185  OG  SER L  26      45.013 -64.937  65.570  1.00 21.58           O
ATOM    186  N   GLN L  27      43.266 -62.813  67.460  1.00 23.64           N
ATOM    187  CA  GLN L  27      43.289 -61.405  67.832  1.00 24.84           C
ATOM    188  C   GLN L  27      41.869 -60.863  67.858  1.00 25.95           C
ATOM    189  O   GLN L  27      40.987 -61.380  67.172  1.00 26.41           O
ATOM    190  CB  GLN L  27      44.108 -60.589  66.830  1.00 27.09           C
ATOM    191  CG  GLN L  27      45.602 -60.618  67.048  1.00 35.67           C
ATOM    192  CD  GLN L  27      46.338 -59.767  66.033  1.00 38.53           C
ATOM    193  OE1 GLN L  27      46.675 -60.228  64.942  1.00 43.32           O
ATOM    194  NE2 GLN L  27      46.572 -58.507  66.380  1.00 40.19           N
ATOM    195  N   SER L  27A     41.653 -59.819  68.651  1.00 21.30           N
ATOM    196  CA  SER L  27A     40.340 -59.209  68.744  1.00 23.38           C
ATOM    197  C   SER L  27A     39.920 -58.676  67.377  1.00 22.05           C
ATOM    198  O   SER L  27A     40.712 -58.050  66.678  1.00 19.83           O
ATOM    199  CB  SER L  27A     40.362 -58.057  69.745  1.00 20.17           C
ATOM    200  OG  SER L  27A     39.122 -57.376  69.738  1.00 24.39           O
ATOM    201  N   LEU L  27B     38.669 -58.918  67.003  1.00 21.73           N
ATOM    202  CA  LEU L  27B     38.173 -58.446  65.720  1.00 20.41           C
ATOM    203  C   LEU L  27B     37.484 -57.089  65.854  1.00 21.13           C
ATOM    204  O   LEU L  27B     36.749 -56.670  64.961  1.00 21.34           O
ATOM    205  CB  LEU L  27B     37.212 -59.473  65.116  1.00 17.54           C
ATOM    206  CG  LEU L  27B     37.805 -60.882  64.938  1.00 21.70           C
ATOM    207  CD1 LEU L  27B     36.800 -61.778  64.232  1.00 19.78           C
ATOM    208  CD2 LEU L  27B     39.092 -60.808  64.132  1.00 17.87           C
ATOM    235  N   ASN L  28      36.659 -48.175  64.751  1.00 23.50           N
ATOM    236  CA  ASN L  28      35.418 -47.408  64.733  1.00 19.92           C
ATOM    237  C   ASN L  28      34.411 -48.040  65.685  1.00 22.34           C
ATOM    238  O   ASN L  28      33.274 -47.586  65.794  1.00 25.95           O
ATOM    239  CB  ASN L  28      34.831 -47.338  63.321  1.00 19.19           C
ATOM    240  CG  ASN L  28      34.676 -48.707  62.680  1.00 22.32           C
ATOM    241  OD1 ASN L  28      34.703 -49.732  63.359  1.00 19.98           O
ATOM    242  ND2 ASN L  28      34.498 -48.726  61.364  1.00 21.69           N
ATOM    243  N   GLY L  29      34.835 -49.093  66.374  1.00 23.30           N
ATOM    244  CA  GLY L  29      33.957 -49.746  67.329  1.00 23.12           C
ATOM    245  C   GLY L  29      33.135 -50.912  66.810  1.00 25.74           C
ATOM    246  O   GLY L  29      32.347 -51.500  67.555  1.00 22.95           O
TER
ATOM      1  CA  SER H  26      46.792 -62.179  70.649  1.00 22.76           C
ATOM      2  C   SER H  26      46.921 -60.740  71.152  1.00 25.79           C
ATOM      3  O   SER H  26      47.600 -60.476  72.148  1.00 27.95           O
ATOM      4  CB  SER H  26      48.023 -62.575  69.834  1.00 23.39           C
ATOM      5  OG  SER H  26      48.013 -61.937  68.570  1.00 21.58           O
ATOM      6  N   GLN H  27      46.266 -59.813  70.460  1.00 23.64           N
ATOM      7  CA  GLN H  27      46.289 -58.405  70.832  1.00 24.84           C
ATOM      8  C   GLN H  27      44.869 -57.863  70.858  1.00 25.95           C
ATOM      9  O   GLN H  27      43.987 -58.380  70.172  1.00 26.41           O
ATOM     10  CB  GLN H  27      47.108 -57.589  69.830  1.00 27.09           C
ATOM     11  CG  GLN H  27      48.602 -57.618  70.048  1.00 35.67           C
ATOM     12  CD  GLN H  27      49.338 -56.767  69.033  1.00 38.53           C
ATOM     13  OE1 GLN H  27      49.675 -57.228  67.942  1.00 43.32           O
ATOM     14  NE2 GLN H  27      49.572 -55.507  69.380  1.00 40.19           N
ATOM     15  N   SER H  27A     44.653 -56.819  71.651  1.00 21.30           N
ATOM     16  CA  SER H  27A     43.340 -56.209  71.744  1.00 23.38           C
ATOM     17  C   SER H  27A     42.920 -55.676  70.377  1.00 22.05           C
ATOM     18  O   SER H  27A     43.712 -55.050  69.678  1.00 19.83           O
ATOM     19  CB  SER H  27A     43.362 -55.057  72.745  1.00 20.17           C
ATOM     20  OG  SER H  27A     42.122 -54.376  72.738  1.00 24.39           O
ATOM     21  N   LEU H  27B     41.669 -55.918  70.003  1.00 21.73           N
ATOM     22  CA  LEU H  27B     41.173 -55.446  68.720  1.00 20.41           C
ATOM     23  C   LEU H  27B     40.484 -54.089  68.854  1.00 21.13           C
ATOM     24  O   LEU H  27B     39.749 -53.670  67.961  1.00 21.34           O
ATOM     25  CB  LEU H  27B     40.212 -56.473  68.116  1.00 17.54           C
ATOM     26  CG  LEU H  27B     40.805 -57.882  67.938  1.00 21.70           C
ATOM     27  CD1 LEU H  27B     39.800 -58.778  67.232  1.00 19.78           C
ATOM     28  CD2 LEU H  27B     42.092 -57.808  67.132  1.00 17.87           C
ATOM     29  N   ASN H  28      39.659 -45.175  67.751  1.00 23.50           N
ATOM     30  CA  ASN H  28      38.418 -44.408  67.733  1.00 19.92           C
ATOM     31  C   ASN H  28      37.411 -45.040  68.685  1.00 22.34           C
ATOM     32  O   ASN H  28      36.274 -44.586  68.794  1.00 25.95           O
ATOM     33  CB  ASN H  28      37.831 -44.338  66.321  1.00 19.19           C
ATOM     34  CG  ASN H  28      37.676 -45.707  65.680  1.00 22.32           C
ATOM     35  OD1 ASN H  28      37.703 -46.732  66.359  1.00 19.98           O
ATOM     36  ND2 ASN H  28      37.498 -45.726  64.364  1.00 21.69           N
ATOM     37  N   GLY H  29      37.835 -46.093  69.374  1.00 23.30           N
ATOM     38  CA  GLY H  29      36.957 -46.746  70.329  1.00 23.12           C
ATOM     39  C   GLY H  29      36.135 -47.912  69.810  1.00 25.74           C
ATOM     40  O   GLY H  29      35.347 -48.500  70.555  1.00 22.95           O
"""

pdb_str_11 = """\
ATOM    181  CA  SER L  26      43.792 -65.179  67.649  1.00 22.76           C
ATOM    182  C   SER L  26      43.921 -63.740  68.152  1.00 25.79           C
ATOM    183  O   SER L  26      44.600 -63.476  69.148  1.00 27.95           O
ATOM    184  CB  SER L  26      45.023 -65.575  66.834  1.00 23.39           C
ATOM    185  OG  SER L  26      45.013 -64.937  65.570  1.00 21.58           O
ATOM    186  N  AGLN L  27      43.266 -62.813  67.460  0.50 23.64           N
ATOM    187  CA AGLN L  27      43.289 -61.405  67.832  0.50 24.84           C
ATOM    188  C  AGLN L  27      41.869 -60.863  67.858  0.50 25.95           C
ATOM    189  O  AGLN L  27      40.987 -61.380  67.172  0.50 26.41           O
ATOM    190  CB AGLN L  27      44.108 -60.589  66.830  0.50 27.09           C
ATOM    191  CG AGLN L  27      45.602 -60.618  67.048  0.50 35.67           C
ATOM    192  CD AGLN L  27      46.338 -59.767  66.033  0.50 38.53           C
ATOM    193  OE1AGLN L  27      46.675 -60.228  64.942  0.50 43.32           O
ATOM    194  NE2AGLN L  27      46.572 -58.507  66.380  0.50 40.19           N
ATOM    195  N  BSER L  27      41.653 -59.819  68.651  0.50 21.30           N
ATOM    196  CA BSER L  27      40.340 -59.209  68.744  0.50 23.38           C
ATOM    197  C  BSER L  27      39.920 -58.676  67.377  0.50 22.05           C
ATOM    198  O  BSER L  27      40.712 -58.050  66.678  0.50 19.83           O
ATOM    199  CB BSER L  27      40.362 -58.057  69.745  0.50 20.17           C
ATOM    200  OG BSER L  27      39.122 -57.376  69.738  0.50 24.39           O
ATOM    235  N   ASN L  28      36.659 -48.175  64.751  1.00 23.50           N
ATOM    236  CA  ASN L  28      35.418 -47.408  64.733  1.00 19.92           C
ATOM    237  C   ASN L  28      34.411 -48.040  65.685  1.00 22.34           C
ATOM    238  O   ASN L  28      33.274 -47.586  65.794  1.00 25.95           O
ATOM    239  CB  ASN L  28      34.831 -47.338  63.321  1.00 19.19           C
ATOM    240  CG  ASN L  28      34.676 -48.707  62.680  1.00 22.32           C
ATOM    241  OD1 ASN L  28      34.703 -49.732  63.359  1.00 19.98           O
ATOM    242  ND2 ASN L  28      34.498 -48.726  61.364  1.00 21.69           N
TER
ATOM      1  CA  SER H  26      46.792 -62.179  70.649  1.00 22.76           C
ATOM      2  C   SER H  26      46.921 -60.740  71.152  1.00 25.79           C
ATOM      3  O   SER H  26      47.600 -60.476  72.148  1.00 27.95           O
ATOM      4  CB  SER H  26      48.023 -62.575  69.834  1.00 23.39           C
ATOM      5  OG  SER H  26      48.013 -61.937  68.570  1.00 21.58           O
ATOM      6  N  AGLN H  27      46.266 -59.813  70.460  0.50 23.64           N
ATOM      7  CA AGLN H  27      46.289 -58.405  70.832  0.50 24.84           C
ATOM      8  C  AGLN H  27      44.869 -57.863  70.858  0.50 25.95           C
ATOM      9  O  AGLN H  27      43.987 -58.380  70.172  0.50 26.41           O
ATOM     10  CB AGLN H  27      47.108 -57.589  69.830  0.50 27.09           C
ATOM     11  CG AGLN H  27      48.602 -57.618  70.048  0.50 35.67           C
ATOM     12  CD AGLN H  27      49.338 -56.767  69.033  0.50 38.53           C
ATOM     13  OE1AGLN H  27      49.675 -57.228  67.942  0.50 43.32           O
ATOM     14  NE2AGLN H  27      49.572 -55.507  69.380  0.50 40.19           N
ATOM     15  N  BSER H  27      44.653 -56.819  71.651  0.50 21.30           N
ATOM     16  CA BSER H  27      43.340 -56.209  71.744  0.50 23.38           C
ATOM     17  C  BSER H  27      42.920 -55.676  70.377  0.50 22.05           C
ATOM     18  O  BSER H  27      43.712 -55.050  69.678  0.50 19.83           O
ATOM     19  CB BSER H  27      43.362 -55.057  72.745  0.50 20.17           C
ATOM     20  OG BSER H  27      42.122 -54.376  72.738  0.50 24.39           O
ATOM     29  N   ASN H  28      39.659 -45.175  67.751  1.00 23.50           N
ATOM     30  CA  ASN H  28      38.418 -44.408  67.733  1.00 19.92           C
ATOM     31  C   ASN H  28      37.411 -45.040  68.685  1.00 22.34           C
ATOM     32  O   ASN H  28      36.274 -44.586  68.794  1.00 25.95           O
ATOM     33  CB  ASN H  28      37.831 -44.338  66.321  1.00 19.19           C
ATOM     34  CG  ASN H  28      37.676 -45.707  65.680  1.00 22.32           C
ATOM     35  OD1 ASN H  28      37.703 -46.732  66.359  1.00 19.98           O
ATOM     36  ND2 ASN H  28      37.498 -45.726  64.364  1.00 21.69           N
"""

pdb_str_12 = """\
MODEL        1
ATOM    181  CA  SER L  26      43.792 -65.179  67.649  1.00 22.76           C
ATOM    182  C   SER L  26      43.921 -63.740  68.152  1.00 25.79           C
ATOM    183  O   SER L  26      44.600 -63.476  69.148  1.00 27.95           O
ATOM    184  CB  SER L  26      45.023 -65.575  66.834  1.00 23.39           C
ATOM    185  OG  SER L  26      45.013 -64.937  65.570  1.00 21.58           O
ATOM      1  CA  SER H  26      46.792 -62.179  70.649  1.00 22.76           C
ATOM      2  C   SER H  26      46.921 -60.740  71.152  1.00 25.79           C
ATOM      3  O   SER H  26      47.600 -60.476  72.148  1.00 27.95           O
ATOM      4  CB  SER H  26      48.023 -62.575  69.834  1.00 23.39           C
ATOM      5  OG  SER H  26      48.013 -61.937  68.570  1.00 21.58           O
ENDMDL
MODEL        2
ATOM    181  CA  SER L  26      43.792 -65.179  67.649  1.00 22.76           C
ATOM    182  C   SER L  26      43.921 -63.740  68.152  1.00 25.79           C
ATOM    183  O   SER L  26      44.600 -63.476  69.148  1.00 27.95           O
ATOM    184  CB  SER L  26      45.023 -65.575  66.834  1.00 23.39           C
ATOM    185  OG  SER L  26      45.013 -64.937  65.570  1.00 21.58           O
ATOM      1  CA  SER H  26      46.792 -62.179  70.649  1.00 22.76           C
ATOM      2  C   SER H  26      46.921 -60.740  71.152  1.00 25.79           C
ATOM      3  O   SER H  26      47.600 -60.476  72.148  1.00 27.95           O
ATOM      4  CB  SER H  26      48.023 -62.575  69.834  1.00 23.39           C
ATOM      5  OG  SER H  26      48.013 -61.937  68.570  1.00 21.58           O
ENDMDL
"""

pdb_str_13 = """\
ATOM      1  P    DG A 101      29.431  -7.266  16.571  1.00 20.00           P
ATOM      2  OP1  DG A 101      28.043  -6.752  16.549  1.00 20.00           O
ATOM      3  OP2  DG A 101      30.364  -6.133  16.806  1.00 20.00           O
ATOM      4  O5'  DG A 101      29.574  -8.346  17.739  1.00 20.00           O
ATOM      5  C5'  DG A 101      30.631  -9.289  17.729  1.00 20.00           C
ATOM      6  C4'  DG A 101      31.914  -8.737  18.342  1.00 20.00           C
ATOM      7  O4'  DG A 101      32.710  -7.950  17.421  1.00 20.00           O
ATOM      8  C3'  DG A 101      31.833  -7.757  19.494  1.00 20.00           C
ATOM      9  O3'  DG A 101      31.252  -8.345  20.643  1.00 20.00           O
ATOM     10  C2'  DG A 101      33.328  -7.516  19.649  1.00 20.00           C
ATOM     11  C1'  DG A 101      33.752  -7.367  18.191  1.00 20.00           C
ATOM     12  P    DA A 102      30.972  -7.472  21.954  1.00 20.00           P
ATOM     13  OP1  DA A 102      30.002  -8.227  22.777  1.00 20.00           O
ATOM     14  OP2  DA A 102      30.635  -6.106  21.501  1.00 20.00           O
ATOM     15  O5'  DA A 102      32.406  -7.509  22.679  1.00 20.00           O
ATOM     16  C5'  DA A 102      32.679  -7.422  24.091  1.00 20.00           C
ATOM     17  C4'  DA A 102      33.179  -6.028  24.456  1.00 20.00           C
ATOM     18  O4'  DA A 102      33.463  -5.302  23.221  1.00 20.00           O
ATOM     19  C3'  DA A 102      32.175  -5.184  25.252  1.00 20.00           C
ATOM     20  O3'  DA A 102      32.792  -4.407  26.338  1.00 20.00           O
ATOM     21  C2'  DA A 102      31.466  -4.398  24.138  1.00 20.00           C
ATOM     22  C1'  DA A 102      32.655  -4.152  23.209  1.00 20.00           C
TER
ATOM    298  P    DGaA 101      49.431  12.734  36.571  1.00 20.00           P
ATOM    299  OP1  DGaA 101      48.043  13.248  36.549  1.00 20.00           O
ATOM    300  OP2  DGaA 101      50.364  13.867  36.806  1.00 20.00           O
ATOM    301  O5'  DGaA 101      49.574  11.654  37.739  1.00 20.00           O
ATOM    302  C5'  DGaA 101      50.631  10.711  37.729  1.00 20.00           C
ATOM    303  C4'  DGaA 101      51.914  11.263  38.342  1.00 20.00           C
ATOM    304  O4'  DGaA 101      52.710  12.050  37.421  1.00 20.00           O
ATOM    305  C3'  DGaA 101      51.833  12.243  39.494  1.00 20.00           C
ATOM    306  O3'  DGaA 101      51.252  11.655  40.643  1.00 20.00           O
ATOM    307  C2'  DGaA 101      53.328  12.484  39.649  1.00 20.00           C
ATOM    308  C1'  DGaA 101      53.752  12.633  38.191  1.00 20.00           C
ATOM    309  P    DAaA 102      50.972  12.528  41.954  1.00 20.00           P
ATOM    310  OP1  DAaA 102      50.002  11.773  42.777  1.00 20.00           O
ATOM    311  OP2  DAaA 102      50.635  13.894  41.501  1.00 20.00           O
ATOM    312  O5'  DAaA 102      52.406  12.491  42.679  1.00 20.00           O
ATOM    313  C5'  DAaA 102      52.679  12.578  44.091  1.00 20.00           C
ATOM    314  C4'  DAaA 102      53.179  13.972  44.456  1.00 20.00           C
ATOM    315  O4'  DAaA 102      53.463  14.698  43.221  1.00 20.00           O
ATOM    316  C3'  DAaA 102      52.175  14.816  45.252  1.00 20.00           C
ATOM    317  O3'  DAaA 102      52.792  15.593  46.338  1.00 20.00           O
ATOM    318  C2'  DAaA 102      51.466  15.602  44.138  1.00 20.00           C
ATOM    319  C1'  DAaA 102      52.655  15.848  43.209  1.00 20.00           C
END
"""

pdb_str_14 = """
CRYST1  399.000  399.000  399.000  90.00  90.00  90.00 P 1
ATOM      1  N1  XXX A  34     125.208 211.886 175.417  1.00  0.00           N
ATOM      2  CT  XXX A  34     125.035 211.123 174.168  1.00  0.00           C
ATOM      3  C   XXX A  34     126.386 210.806 173.507  1.00  0.00           C
ATOM      4  K   XXX A  34     127.304 211.628 173.503  1.00  0.00           K
TER
ATOM      5  N1  XXX B  34     251.532 143.432 175.422  1.00  0.00           N
ATOM      6  CT  XXX B  34     252.120 143.948 174.173  1.00  0.00           C
ATOM      7  C   XXX B  34     251.212 144.998 173.512  1.00  0.00           C
ATOM      8  K   XXX B  34     249.986 144.872 173.510  1.00  0.00           K
TER
ATOM      9  N1  XXX C  34     189.583 273.076 175.423  1.00  0.00           N
ATOM     10  CT  XXX C  34     188.804 273.006 174.173  1.00  0.00           C
ATOM     11  C   XXX C  34     188.920 271.622 173.510  1.00  0.00           C
ATOM     12  K   XXX C  34     189.986 271.004 173.508  1.00  0.00           K
TER
"""

pdb_str_15 = """
ATOM      1  N1  XXX A  34     125.208 211.886 175.417  1.00  0.00           N
ATOM      2  CT  XXX A  34     125.035 211.123 174.168  1.00  0.00           C
ATOM      3  C   XXX A  34     126.386 210.806 173.507  1.00  0.00           C
ATOM      4  K   XXX A  34     127.304 211.628 173.503  1.00  0.00           K
ATOM      1  O   HOH A  35     135.208 211.886 175.417  1.00  0.00           O
ATOM      2  O   HOH A  36     135.035 211.123 174.168  1.00  0.00           O
ATOM      3  O   HOH A  37     136.386 210.806 173.507  1.00  0.00           O
ATOM      4  O   HOH A  38     137.304 211.628 173.503  1.00  0.00           O
TER
ATOM      5  N1  XXX B  34     251.532 143.432 175.422  1.00  0.00           N
ATOM      6  CT  XXX B  34     252.120 143.948 174.173  1.00  0.00           C
ATOM      7  C   XXX B  34     251.212 144.998 173.512  1.00  0.00           C
ATOM      8  K   XXX B  34     249.986 144.872 173.510  1.00  0.00           K
ATOM      5  O   HOH B  35     271.532 143.432 175.422  1.00  0.00           O
ATOM      6  O   HOH B  36     272.120 143.948 174.173  1.00  0.00           O
ATOM      7  O   HOH B  37     271.212 144.998 173.512  1.00  0.00           O
ATOM      8  O   HOH B  38     279.986 144.872 173.510  1.00  0.00           O
TER
"""

pdb_str_16 = """\
ATOM    181  CA  SER L  26      43.792 -65.179  67.649  1.00 22.76           C
ATOM    182  C   SER L  26      43.921 -63.740  68.152  1.00 25.79           C
ATOM    183  O   SER L  26      44.600 -63.476  69.148  1.00 27.95           O
ATOM    184  CB  SER L  26      45.023 -65.575  66.834  1.00 23.39           C
ATOM    185  OG  SER L  26      45.013 -64.937  65.570  1.00 21.58           O
ATOM    186  N  AGLN L  27      43.266 -62.813  67.460  0.50 23.64           N
ATOM    187  CA AGLN L  27      43.289 -61.405  67.832  0.50 24.84           C
ATOM    188  C  AGLN L  27      41.869 -60.863  67.858  0.50 25.95           C
ATOM    189  O  AGLN L  27      40.987 -61.380  67.172  0.50 26.41           O
ATOM    190  CB AGLN L  27      44.108 -60.589  66.830  0.50 27.09           C
ATOM    191  CG AGLN L  27      45.602 -60.618  67.048  0.50 35.67           C
ATOM    192  CD AGLN L  27      46.338 -59.767  66.033  0.50 38.53           C
ATOM    193  OE1AGLN L  27      46.675 -60.228  64.942  0.50 43.32           O
ATOM    194  NE2AGLN L  27      46.572 -58.507  66.380  0.50 40.19           N
ATOM    195  N  BSER L  27      41.653 -59.819  68.651  0.50 21.30           N
ATOM    196  CA BSER L  27      40.340 -59.209  68.744  0.50 23.38           C
ATOM    197  C  BSER L  27      39.920 -58.676  67.377  0.50 22.05           C
ATOM    198  O  BSER L  27      40.712 -58.050  66.678  0.50 19.83           O
ATOM    199  CB BSER L  27      40.362 -58.057  69.745  0.50 20.17           C
ATOM    200  OG BSER L  27      39.122 -57.376  69.738  0.50 24.39           O
ATOM    235  N   ASN L  28      36.659 -48.175  64.751  1.00 23.50           N
ATOM    236  CA  ASN L  28      35.418 -47.408  64.733  1.00 19.92           C
ATOM    237  C   ASN L  28      34.411 -48.040  65.685  1.00 22.34           C
ATOM    238  O   ASN L  28      33.274 -47.586  65.794  1.00 25.95           O
ATOM    239  CB  ASN L  28      34.831 -47.338  63.321  1.00 19.19           C
ATOM    240  CG  ASN L  28      34.676 -48.707  62.680  1.00 22.32           C
ATOM    241  OD1 ASN L  28      34.703 -49.732  63.359  1.00 19.98           O
ATOM    242  ND2 ASN L  28      34.498 -48.726  61.364  1.00 21.69           N
TER
ATOM      1  CA  SER H  -1      46.792 -62.179  70.649  1.00 22.76           C
ATOM      2  C   SER H  -1      46.921 -60.740  71.152  1.00 25.79           C
ATOM      3  O   SER H  -1      47.600 -60.476  72.148  1.00 27.95           O
ATOM      4  CB  SER H  -1      48.023 -62.575  69.834  1.00 23.39           C
ATOM      5  OG  SER H  -1      48.013 -61.937  68.570  1.00 21.58           O
ATOM      6  N  AGLN H   0      46.266 -59.813  70.460  0.50 23.64           N
ATOM      7  CA AGLN H   0      46.289 -58.405  70.832  0.50 24.84           C
ATOM      8  C  AGLN H   0      44.869 -57.863  70.858  0.50 25.95           C
ATOM      9  O  AGLN H   0      43.987 -58.380  70.172  0.50 26.41           O
ATOM     10  CB AGLN H   0      47.108 -57.589  69.830  0.50 27.09           C
ATOM     11  CG AGLN H   0      48.602 -57.618  70.048  0.50 35.67           C
ATOM     12  CD AGLN H   0      49.338 -56.767  69.033  0.50 38.53           C
ATOM     13  OE1AGLN H   0      49.675 -57.228  67.942  0.50 43.32           O
ATOM     14  NE2AGLN H   0      49.572 -55.507  69.380  0.50 40.19           N
ATOM     15  N  BSER H   0      44.653 -56.819  71.651  0.50 21.30           N
ATOM     16  CA BSER H   0      43.340 -56.209  71.744  0.50 23.38           C
ATOM     17  C  BSER H   0      42.920 -55.676  70.377  0.50 22.05           C
ATOM     18  O  BSER H   0      43.712 -55.050  69.678  0.50 19.83           O
ATOM     19  CB BSER H   0      43.362 -55.057  72.745  0.50 20.17           C
ATOM     20  OG BSER H   0      42.122 -54.376  72.738  0.50 24.39           O
ATOM     29  N   ASN H   9      39.659 -45.175  67.751  1.00 23.50           N
ATOM     30  CA  ASN H   9      38.418 -44.408  67.733  1.00 19.92           C
ATOM     31  C   ASN H   9      37.411 -45.040  68.685  1.00 22.34           C
ATOM     32  O   ASN H   9      36.274 -44.586  68.794  1.00 25.95           O
ATOM     33  CB  ASN H   9      37.831 -44.338  66.321  1.00 19.19           C
ATOM     34  CG  ASN H   9      37.676 -45.707  65.680  1.00 22.32           C
ATOM     35  OD1 ASN H   9      37.703 -46.732  66.359  1.00 19.98           O
ATOM     36  ND2 ASN H   9      37.498 -45.726  64.364  1.00 21.69           N
"""

pdb_str_17 = """
ATOM      1  N   ASP B   1      51.626 -66.543  62.314  1.00 34.60           N
ATOM      2  CA  ASP B   1      50.334 -66.083  61.819  1.00 33.86           C
ATOM      3  C   ASP B   1      49.224 -66.387  62.821  1.00 34.02           C
ATOM      4  O   ASP B   1      49.488 -66.629  63.999  1.00 32.23           O
ATOM      5  CB  ASP B   1      50.015 -66.728  60.469  1.00 33.99           C
ATOM      6  CG  ASP B   1      51.047 -66.399  59.408  1.00 36.93           C
ATOM      7  OD1 ASP B   1      51.647 -65.306  59.480  1.00 36.67           O
ATOM      8  OD2 ASP B   1      51.258 -67.233  58.503  1.00 38.81           O
ATOM      9  N   VAL B   2      47.984 -66.373  62.345  1.00 31.94           N
ATOM     10  CA  VAL B   2      46.833 -66.647  63.196  1.00 29.81           C
ATOM     11  C   VAL B   2      46.674 -68.151  63.403  1.00 28.28           C
ATOM     12  O   VAL B   2      46.672 -68.925  62.445  1.00 27.24           O
ATOM     13  CB  VAL B   2      45.547 -66.026  62.609  1.00 30.66           C
ATOM     14  CG1 VAL B   2      44.320 -66.509  63.370  1.00 29.42           C
ATOM     15  CG2 VAL B   2      45.429 -66.333  61.122  1.00 31.43           C
ATOM     16  N   GLN B   3      46.550 -68.560  64.661  1.00 25.93           N
ATOM     17  CA  GLN B   3      46.391 -69.970  64.997  1.00 24.46           C
ATOM     18  C   GLN B   3      44.959 -70.433  64.750  1.00 23.33           C
ATOM     19  O   GLN B   3      44.010 -69.863  65.287  1.00 20.10           O
ATOM     20  CB  GLN B   3      46.782 -70.222  66.455  1.00 29.74           C
ATOM     21  CG  GLN B   3      46.646 -71.671  66.893  1.00 39.72           C
ATOM     22  CD  GLN B   3      47.041 -71.883  68.341  1.00 51.31           C
ATOM     23  OE1 GLN B   3      47.031 -73.007  68.841  1.00 57.11           O
ATOM     24  NE2 GLN B   3      47.393 -70.799  69.023  1.00 54.00           N
ATOM     25  N   MET B   4      44.812 -71.472  63.933  1.00 24.27           N
ATOM     26  CA  MET B   4      43.496 -72.013  63.613  1.00 22.89           C
ATOM     27  C   MET B   4      42.969 -72.880  64.752  1.00 21.48           C
ATOM     28  O   MET B   4      43.379 -74.029  64.912  1.00 23.73           O
ATOM     29  CB  MET B   4      43.551 -72.824  62.316  1.00 22.77           C
ATOM     30  CG  MET B   4      43.996 -72.024  61.103  1.00 20.45           C
ATOM     31  SD  MET B   4      42.904 -70.635  60.747  1.00 23.95           S
ATOM     32  CE  MET B   4      41.353 -71.486  60.468  1.00 24.76           C
ATOM     33  N   THR B   5      42.057 -72.320  65.541  1.00 20.55           N
ATOM     34  CA  THR B   5      41.472 -73.040  66.666  1.00 20.64           C
ATOM     35  C   THR B   5      40.063 -73.521  66.335  1.00 20.08           C
ATOM     36  O   THR B   5      39.176 -72.720  66.042  1.00 20.87           O
ATOM     37  CB  THR B   5      41.422 -72.165  67.932  1.00 23.39           C
ATOM     38  OG1 THR B   5      42.751 -71.766  68.293  1.00 30.91           O
ATOM     39  CG2 THR B   5      40.798 -72.934  69.087  1.00 26.97           C
TER
ATOM      1  N   ASP A   1      46.675 -60.355  58.113  1.00 34.60           N
ATOM      2  CA  ASP A   1      46.807 -61.464  59.051  1.00 33.86           C
ATOM      3  C   ASP A   1      45.597 -61.546  59.975  1.00 34.02           C
ATOM      4  O   ASP A   1      45.693 -62.048  61.095  1.00 32.23           O
ATOM      5  CB  ASP A   1      48.090 -61.322  59.873  1.00 33.99           C
ATOM      6  CG  ASP A   1      49.337 -61.310  59.010  1.00 36.93           C
ATOM      7  OD1 ASP A   1      49.255 -60.851  57.851  1.00 36.67           O
ATOM      8  OD2 ASP A   1      50.398 -61.759  59.491  1.00 38.81           O
ATOM      9  N   VAL A   2      44.460 -61.050  59.499  1.00 31.94           N
ATOM     10  CA  VAL A   2      43.231 -61.067  60.281  1.00 29.81           C
ATOM     11  C   VAL A   2      42.306 -62.174  59.789  1.00 28.28           C
ATOM     12  O   VAL A   2      41.817 -62.132  58.660  1.00 27.24           O
ATOM     13  CB  VAL A   2      42.520 -59.704  60.230  1.00 30.66           C
ATOM     14  CG1 VAL A   2      41.241 -59.742  61.052  1.00 29.42           C
ATOM     15  CG2 VAL A   2      43.447 -58.604  60.725  1.00 31.43           C
ATOM     16  N   GLN A   3      42.071 -63.165  60.643  1.00 25.93           N
ATOM     17  CA  GLN A   3      41.205 -64.286  60.296  1.00 24.46           C
ATOM     18  C   GLN A   3      40.490 -64.827  61.530  1.00 23.33           C
ATOM     19  O   GLN A   3      41.120 -65.383  62.430  1.00 20.10           O
ATOM     20  CB  GLN A   3      42.011 -65.399  59.624  1.00 29.74           C
ATOM     21  CG  GLN A   3      41.185 -66.611  59.227  1.00 39.72           C
ATOM     22  CD  GLN A   3      42.016 -67.692  58.564  1.00 51.31           C
ATOM     23  OE1 GLN A   3      43.226 -67.542  58.391  1.00 57.11           O
ATOM     24  NE2 GLN A   3      41.370 -68.790  58.190  1.00 54.00           N
ATOM     25  N   MET A   4      39.172 -64.662  61.564  1.00 24.27           N
ATOM     26  CA  MET A   4      38.369 -65.133  62.686  1.00 22.89           C
ATOM     27  C   MET A   4      37.658 -66.437  62.341  1.00 21.48           C
ATOM     28  O   MET A   4      37.275 -67.196  63.233  1.00 23.73           O
ATOM     29  CB  MET A   4      37.349 -64.070  63.100  1.00 22.77           C
ATOM     30  CG  MET A   4      37.968 -62.752  63.535  1.00 20.45           C
ATOM     31  SD  MET A   4      39.065 -62.933  64.954  1.00 23.95           S
ATOM     32  CE  MET A   4      37.932 -63.588  66.177  1.00 24.76           C
ATOM     33  N   THR A   5      37.492 -66.682  61.043  1.00 20.55           N
ATOM     34  CA  THR A   5      36.832 -67.882  60.528  1.00 20.64           C
ATOM     35  C   THR A   5      35.420 -68.037  61.091  1.00 20.08           C
ATOM     36  O   THR A   5      35.211 -68.701  62.108  1.00 20.87           O
ATOM     37  CB  THR A   5      37.647 -69.156  60.837  1.00 23.39           C
ATOM     38  OG1 THR A   5      39.009 -68.964  60.435  1.00 30.91           O
ATOM     39  CG2 THR A   5      37.073 -70.352  60.091  1.00 26.97           C
TER
"""

pdb_str_18 = """
ATOM      1  N   MET     1     158.070 173.095 147.115  1.00 50.00      A16S N
ATOM      2  CA  MET     1     157.408 172.627 148.359  1.00 50.00      A16S C
ATOM      3  CB  MET     1     157.550 171.094 148.516  1.00 50.00      A16S C
ATOM      4  CG  MET     1     156.748 170.503 149.691  1.00 50.00      A16S C
ATOM      5  SD  MET     1     154.968 170.855 149.612  1.00 50.00      A16S S
ATOM      6  CE  MET     1     154.505 169.913 151.091  1.00 50.00      A16S C
ATOM      7  C   MET     1     157.958 173.331 149.563  1.00 50.00      A16S C
ATOM      8  O   MET     1     157.196 173.814 150.399  1.00 50.00      A16S O
TER
ATOM      9  N   MET     1     174.781 155.306 150.054  1.00 50.00      B16S N
ATOM     10  CA  MET     1     174.332 154.630 151.298  1.00 50.00      B16S C
ATOM     11  CB  MET     1     175.016 153.251 151.453  1.00 50.00      B16S C
ATOM     12  CG  MET     1     174.481 152.410 152.628  1.00 50.00      B16S C
ATOM     13  SD  MET     1     172.693 152.099 152.550  1.00 50.00      B16S S
ATOM     14  CE  MET     1     172.601 151.052 154.028  1.00 50.00      B16S C
ATOM     15  C   MET     1     174.594 155.484 152.502  1.00 50.00      B16S C
ATOM     16  O   MET     1     173.710 155.660 153.339  1.00 50.00      B16S O
TER
END
"""

pdb_str_19 = """
ATOM      1  N   MET A   1     158.070 173.095 147.115  1.00 50.00      A16S N
ATOM      2  CA  MET A   1     157.408 172.627 148.359  1.00 50.00      A16S C
ATOM      3  CB  MET A   1     157.550 171.094 148.516  1.00 50.00      A16S C
ATOM      4  CG  MET A   1     156.748 170.503 149.691  1.00 50.00      A16S C
ATOM      5  SD  MET A   1     154.968 170.855 149.612  1.00 50.00      A16S S
ATOM      6  CE  MET A   1     154.505 169.913 151.091  1.00 50.00      A16S C
ATOM      7  C   MET A   1     157.958 173.331 149.563  1.00 50.00      A16S C
ATOM      8  O   MET A   1     157.196 173.814 150.399  1.00 50.00      A16S O
TER
ATOM      9  N   MET     1     174.781 155.306 150.054  1.00 50.00      B16S N
ATOM     10  CA  MET     1     174.332 154.630 151.298  1.00 50.00      B16S C
ATOM     11  CB  MET     1     175.016 153.251 151.453  1.00 50.00      B16S C
ATOM     12  CG  MET     1     174.481 152.410 152.628  1.00 50.00      B16S C
ATOM     13  SD  MET     1     172.693 152.099 152.550  1.00 50.00      B16S S
ATOM     14  CE  MET     1     172.601 151.052 154.028  1.00 50.00      B16S C
ATOM     15  C   MET     1     174.594 155.484 152.502  1.00 50.00      B16S C
ATOM     16  O   MET     1     173.710 155.660 153.339  1.00 50.00      B16S O
TER
END
"""

pdb_str_20 = """
CRYST1   25.287   40.217   65.471  90.00  90.00  90.00 P 21 21 21
SCALE1      0.039546  0.000000  0.000000        0.00000
SCALE2      0.000000  0.024865  0.000000        0.00000
SCALE3      0.000000  0.000000  0.015274        0.00000
ATOM      1  P    DA A   5      -8.062  -5.965 -15.755  1.00 42.17           P
ATOM      2  OP1  DA A   5      -8.426  -7.228 -16.405  1.00 50.61           O
ATOM      3  OP2  DA A   5      -8.689  -5.557 -14.457  1.00 51.75           O
ATOM      4  O5'  DA A   5      -6.496  -5.961 -15.638  1.00 34.89           O
ATOM      5  C5'  DA A   5      -5.791  -6.321 -16.790  1.00 30.71           C
ATOM      6  C4'  DA A   5      -4.355  -5.917 -16.600  1.00 34.43           C
ATOM      7  O4'  DA A   5      -4.303  -4.509 -16.239  1.00 33.96           O
ATOM      8  C3'  DA A   5      -3.630  -6.687 -15.491  1.00 35.56           C
ATOM      9  O3'  DA A   5      -2.407  -7.257 -16.020  1.00 33.08           O
ATOM     10  C2'  DA A   5      -3.531  -5.654 -14.384  1.00 32.41           C
ATOM     11  C1'  DA A   5      -3.435  -4.334 -15.130  1.00 28.44           C
ATOM     12  N9   DA A   5      -3.904  -3.143 -14.449  1.00 28.37           N
ATOM     13  C8   DA A   5      -5.187  -2.933 -14.022  1.00 27.53           C
ATOM     14  N7   DA A   5      -5.401  -1.724 -13.565  1.00 29.33           N
ATOM     15  C5   DA A   5      -4.187  -1.082 -13.747  1.00 23.78           C
ATOM     16  C6   DA A   5      -3.761   0.226 -13.474  1.00 25.22           C
ATOM     17  N6   DA A   5      -4.519   1.150 -12.896  1.00 25.69           N
ATOM     18  N1   DA A   5      -2.485   0.535 -13.749  1.00 24.39           N
ATOM     19  C2   DA A   5      -1.712  -0.389 -14.320  1.00 24.89           C
ATOM     20  N3   DA A   5      -2.001  -1.641 -14.653  1.00 28.33           N
ATOM     21  C4   DA A   5      -3.268  -1.935 -14.326  1.00 27.45           C
ATOM     22  P    DA A   6      -1.382  -8.057 -15.083  1.00 33.49           P
ATOM     23  OP1  DA A   6      -0.596  -8.971 -15.989  1.00 35.26           O
ATOM     24  OP2  DA A   6      -2.097  -8.481 -13.890  1.00 34.48           O
ATOM     25  O5'  DA A   6      -0.480  -6.949 -14.401  1.00 31.72           O
ATOM     26  C5'  DA A   6       0.398  -6.138 -15.188  1.00 28.12           C
ATOM     27  C4'  DA A   6       1.219  -5.272 -14.269  1.00 22.57           C
ATOM     28  O4'  DA A   6       0.380  -4.203 -13.784  1.00 23.34           O
ATOM     29  C3'  DA A   6       1.783  -5.982 -13.049  1.00 23.61           C
ATOM     30  O3'  DA A   6       3.202  -5.785 -13.150  1.00 22.60           O
ATOM     31  C2'  DA A   6       1.110  -5.289 -11.881  1.00 22.21           C
ATOM     32  C1'  DA A   6       0.653  -3.958 -12.418  1.00 20.89           C
ATOM     33  N9   DA A   6      -0.561  -3.398 -11.831  1.00 21.71           N
ATOM     34  C8   DA A   6      -1.777  -4.017 -11.666  1.00 23.62           C
ATOM     35  N7   DA A   6      -2.693  -3.249 -11.139  1.00 23.57           N
ATOM     36  C5   DA A   6      -2.071  -2.016 -11.029  1.00 20.29           C
ATOM     37  C6   DA A   6      -2.506  -0.774 -10.519  1.00 20.33           C
ATOM     38  N6   DA A   6      -3.763  -0.525 -10.122  1.00 20.36           N
ATOM     39  N1   DA A   6      -1.604   0.233 -10.486  1.00 20.84           N
ATOM     40  C2   DA A   6      -0.341  -0.023 -10.868  1.00 21.15           C
ATOM     41  N3   DA A   6       0.174  -1.126 -11.378  1.00 22.91           N
ATOM     42  C4   DA A   6      -0.746  -2.101 -11.433  1.00 20.00           C
ATOM     43  P    DT A   7       4.283  -6.215 -12.051  1.00 23.53           P
ATOM     44  OP1  DT A   7       5.598  -6.398 -12.780  1.00 27.73           O
ATOM     45  OP2  DT A   7       3.774  -7.297 -11.205  1.00 24.18           O
ATOM     46  O5'  DT A   7       4.350  -4.948 -11.106  1.00 22.94           O
ATOM     47  C5'  DT A   7       4.668  -3.709 -11.633  1.00 21.30           C
ATOM     48  C4'  DT A   7       4.525  -2.656 -10.580  1.00 20.84           C
ATOM     49  O4'  DT A   7       3.138  -2.512 -10.296  1.00 19.94           O
ATOM     50  C3'  DT A   7       5.205  -2.966  -9.250  1.00 20.02           C
ATOM     51  O3'  DT A   7       6.280  -2.035  -9.099  1.00 23.74           O
ATOM     52  C2'  DT A   7       4.144  -2.717  -8.200  1.00 19.47           C
ATOM     53  C1'  DT A   7       3.048  -2.015  -8.962  1.00 20.12           C
ATOM     54  N1   DT A   7       1.641  -2.197  -8.524  1.00 20.27           N
ATOM     55  C2   DT A   7       0.957  -1.108  -8.030  1.00 18.61           C
ATOM     56  O2   DT A   7       1.430   0.017  -7.926  1.00 19.56           O
ATOM     57  N3   DT A   7      -0.344  -1.365  -7.721  1.00 18.89           N
ATOM     58  C4   DT A   7      -1.018  -2.563  -7.836  1.00 21.94           C
ATOM     59  O4   DT A   7      -2.200  -2.640  -7.497  1.00 23.57           O
ATOM     60  C5   DT A   7      -0.226  -3.674  -8.271  1.00 18.09           C
ATOM     61  C7   DT A   7      -0.860  -5.022  -8.351  1.00 19.35           C
ATOM     62  C6   DT A   7       1.065  -3.446  -8.562  1.00 17.66           C
ATOM     63  P    DT A   8       7.284  -1.980  -7.857  1.00 26.43           P
ATOM     64  OP1  DT A   8       8.611  -1.444  -8.278  1.00 28.45           O
ATOM     65  OP2  DT A   8       7.248  -3.298  -7.198  1.00 27.17           O
ATOM     66  O5'  DT A   8       6.613  -0.927  -6.882  1.00 25.09           O
ATOM     67  C5'  DT A   8       6.357   0.403  -7.340  1.00 24.67           C
ATOM     68  C4'  DT A   8       5.543   1.125  -6.301  1.00 23.10           C
ATOM     69  O4'  DT A   8       4.228   0.541  -6.229  1.00 23.60           O
ATOM     70  C3'  DT A   8       6.127   1.057  -4.884  1.00 25.21           C
ATOM     71  O3'  DT A   8       6.507   2.380  -4.493  1.00 28.93           O
ATOM     72  C2'  DT A   8       5.018   0.434  -4.050  1.00 23.32           C
ATOM     73  C1'  DT A   8       3.795   0.667  -4.883  1.00 22.06           C
ATOM     74  N1   DT A   8       2.713  -0.291  -4.689  1.00 19.79           N
ATOM     75  C2   DT A   8       1.466   0.223  -4.414  1.00 18.40           C
ATOM     76  O2   DT A   8       1.263   1.399  -4.157  1.00 20.56           O
ATOM     77  N3   DT A   8       0.484  -0.716  -4.337  1.00 19.20           N
ATOM     78  C4   DT A   8       0.588  -2.075  -4.597  1.00 18.45           C
ATOM     79  O4   DT A   8      -0.397  -2.789  -4.538  1.00 21.38           O
ATOM     80  C5   DT A   8       1.920  -2.549  -4.859  1.00 17.02           C
ATOM     81  C7   DT A   8       2.126  -4.006  -5.116  1.00 20.50           C
ATOM     82  C6   DT A   8       2.895  -1.634  -4.959  1.00 19.29           C
TER
ATOM     83  P    DA B  17     -10.220   1.260  -1.207  1.00 27.94           P
ATOM     84  OP1  DA B  17     -11.370   2.143  -0.856  1.00 34.83           O
ATOM     85  OP2  DA B  17     -10.221   0.599  -2.553  1.00 31.17           O
ATOM     86  O5'  DA B  17      -8.842   2.020  -1.098  1.00 26.12           O
ATOM     87  C5'  DA B  17      -8.558   2.683   0.094  1.00 25.41           C
ATOM     88  C4'  DA B  17      -7.407   3.619  -0.107  1.00 26.38           C
ATOM     89  O4'  DA B  17      -6.208   2.886  -0.440  1.00 24.41           O
ATOM     90  C3'  DA B  17      -7.600   4.631  -1.214  1.00 27.57           C
ATOM     91  O3'  DA B  17      -6.972   5.834  -0.764  1.00 29.89           O
ATOM     92  C2'  DA B  17      -6.902   3.980  -2.406  1.00 26.29           C
ATOM     93  C1'  DA B  17      -5.771   3.225  -1.781  1.00 23.13           C
ATOM     94  N9   DA B  17      -5.444   1.986  -2.460  1.00 22.66           N
ATOM     95  C8   DA B  17      -6.295   0.942  -2.750  1.00 23.38           C
ATOM     96  N7   DA B  17      -5.700  -0.094  -3.288  1.00 20.62           N
ATOM     97  C5   DA B  17      -4.344   0.242  -3.234  1.00 20.59           C
ATOM     98  C6   DA B  17      -3.178  -0.447  -3.603  1.00 17.89           C
ATOM     99  N6   DA B  17      -3.184  -1.685  -4.072  1.00 20.22           N
ATOM    100  N1   DA B  17      -1.995   0.205  -3.497  1.00 19.61           N
ATOM    101  C2   DA B  17      -1.992   1.465  -3.030  1.00 20.38           C
ATOM    102  N3   DA B  17      -3.021   2.207  -2.621  1.00 20.80           N
ATOM    103  C4   DA B  17      -4.182   1.540  -2.774  1.00 19.17           C
ATOM    104  P    DA B  18      -6.994   7.132  -1.670  1.00 32.91           P
ATOM    105  OP1  DA B  18      -6.817   8.281  -0.798  1.00 37.55           O
ATOM    106  OP2  DA B  18      -8.060   7.037  -2.636  1.00 31.04           O
ATOM    107  O5'  DA B  18      -5.659   7.052  -2.535  1.00 30.20           O
ATOM    108  C5'  DA B  18      -4.377   7.074  -1.958  1.00 30.19           C
ATOM    109  C4'  DA B  18      -3.354   6.838  -3.036  1.00 28.09           C
ATOM    110  O4'  DA B  18      -3.424   5.481  -3.484  1.00 26.27           O
ATOM    111  C3'  DA B  18      -3.545   7.708  -4.286  1.00 29.73           C
ATOM    112  O3'  DA B  18      -2.469   8.627  -4.273  1.00 34.73           O
ATOM    113  C2'  DA B  18      -3.566   6.715  -5.433  1.00 27.32           C
ATOM    114  C1'  DA B  18      -3.010   5.448  -4.841  1.00 24.83           C
ATOM    115  N9   DA B  18      -3.488   4.196  -5.410  1.00 23.72           N
ATOM    116  C8   DA B  18      -4.794   3.799  -5.530  1.00 20.51           C
ATOM    117  N7   DA B  18      -4.937   2.581  -5.985  1.00 22.85           N
ATOM    118  C5   DA B  18      -3.636   2.147  -6.189  1.00 20.87           C
ATOM    119  C6   DA B  18      -3.111   0.950  -6.675  1.00 19.34           C
ATOM    120  N6   DA B  18      -3.852  -0.099  -7.028  1.00 21.88           N
ATOM    121  N1   DA B  18      -1.767   0.849  -6.776  1.00 19.77           N
ATOM    122  C2   DA B  18      -1.023   1.872  -6.374  1.00 21.42           C
ATOM    123  N3   DA B  18      -1.392   3.050  -5.910  1.00 22.19           N
ATOM    124  C4   DA B  18      -2.734   3.129  -5.836  1.00 21.41           C
ATOM    125  P    DT B  19      -2.064   9.546  -5.497  1.00 40.82           P
ATOM    126  OP1  DT B  19      -1.281  10.615  -4.939  1.00 44.52           O
ATOM    127  OP2  DT B  19      -3.292   9.787  -6.271  1.00 44.69           O
ATOM    128  O5'  DT B  19      -1.119   8.619  -6.355  1.00 30.72           O
ATOM    129  C5'  DT B  19       0.059   8.093  -5.804  1.00 29.16           C
ATOM    130  C4'  DT B  19       0.704   7.195  -6.832  1.00 26.15           C
ATOM    131  O4'  DT B  19      -0.129   6.045  -7.087  1.00 26.00           O
ATOM    132  C3'  DT B  19       0.941   7.859  -8.188  1.00 25.98           C
ATOM    133  O3'  DT B  19       2.343   7.877  -8.376  1.00 30.07           O
ATOM    134  C2'  DT B  19       0.207   6.968  -9.181  1.00 26.77           C
ATOM    135  C1'  DT B  19       0.036   5.665  -8.443  1.00 25.87           C
ATOM    136  N1   DT B  19      -1.122   4.839  -8.816  1.00 24.60           N
ATOM    137  C2   DT B  19      -0.906   3.556  -9.283  1.00 22.21           C
ATOM    138  O2   DT B  19       0.197   3.084  -9.451  1.00 22.06           O
ATOM    139  N3   DT B  19      -2.038   2.833  -9.519  1.00 22.04           N
ATOM    140  C4   DT B  19      -3.339   3.262  -9.380  1.00 21.81           C
ATOM    141  O4   DT B  19      -4.247   2.495  -9.615  1.00 24.16           O
ATOM    142  C5   DT B  19      -3.499   4.613  -8.891  1.00 22.25           C
ATOM    143  C7   DT B  19      -4.879   5.143  -8.663  1.00 23.26           C
ATOM    144  C6   DT B  19      -2.396   5.327  -8.640  1.00 22.85           C
ATOM    145  P    DT B  20       3.005   8.456  -9.725  1.00 32.03           P
ATOM    146  OP1  DT B  20       4.339   8.958  -9.284  1.00 35.31           O
ATOM    147  OP2  DT B  20       2.027   9.351 -10.442  1.00 33.99           O
ATOM    148  O5'  DT B  20       3.144   7.102 -10.543  1.00 31.33           O
ATOM    149  C5'  DT B  20       3.894   5.979 -10.032  1.00 28.60           C
ATOM    150  C4'  DT B  20       3.851   4.840 -11.020  1.00 28.63           C
ATOM    151  O4'  DT B  20       2.494   4.361 -11.145  1.00 26.47           O
ATOM    152  C3'  DT B  20       4.300   5.211 -12.437  1.00 31.59           C
ATOM    153  O3'  DT B  20       5.260   4.256 -12.875  1.00 39.07           O
ATOM    154  C2'  DT B  20       3.027   5.147 -13.257  1.00 26.06           C
ATOM    155  C1'  DT B  20       2.211   4.120 -12.529  1.00 24.42           C
ATOM    156  N1   DT B  20       0.757   4.123 -12.660  1.00 23.79           N
ATOM    157  C2   DT B  20       0.138   2.932 -12.972  1.00 25.04           C
ATOM    158  O2   DT B  20       0.741   1.921 -13.262  1.00 24.66           O
ATOM    159  N3   DT B  20      -1.229   2.977 -12.959  1.00 25.84           N
ATOM    160  C4   DT B  20      -2.022   4.071 -12.671  1.00 25.98           C
ATOM    161  O4   DT B  20      -3.234   3.948 -12.646  1.00 28.14           O
ATOM    162  C5   DT B  20      -1.311   5.298 -12.387  1.00 22.81           C
ATOM    163  C7   DT B  20      -2.094   6.540 -12.092  1.00 27.47           C
ATOM    164  C6   DT B  20       0.028   5.263 -12.401  1.00 26.29           C
TER
ATOM    165  P    DA C   5      -8.062  -5.965 -15.755  1.00 42.17           P
ATOM    166  OP1  DA C   5      -8.426  -7.228 -16.405  1.00 50.61           O
ATOM    167  OP2  DA C   5      -8.689  -5.557 -14.457  1.00 51.75           O
ATOM    168  O5'  DA C   5      -6.496  -5.961 -15.638  1.00 34.89           O
ATOM    169  C5'  DA C   5      -5.791  -6.321 -16.790  1.00 30.71           C
ATOM    170  C4'  DA C   5      -4.355  -5.917 -16.600  1.00 34.43           C
ATOM    171  O4'  DA C   5      -4.303  -4.509 -16.239  1.00 33.96           O
ATOM    172  C3'  DA C   5      -3.630  -6.687 -15.491  1.00 35.56           C
ATOM    173  O3'  DA C   5      -2.407  -7.257 -16.020  1.00 33.08           O
ATOM    174  C2'  DA C   5      -3.531  -5.654 -14.384  1.00 32.41           C
ATOM    175  C1'  DA C   5      -3.435  -4.334 -15.130  1.00 28.44           C
ATOM    176  N9   DA C   5      -3.904  -3.143 -14.449  1.00 28.37           N
ATOM    177  C8   DA C   5      -5.187  -2.933 -14.022  1.00 27.53           C
ATOM    178  N7   DA C   5      -5.401  -1.724 -13.565  1.00 29.33           N
ATOM    179  C5   DA C   5      -4.187  -1.082 -13.747  1.00 23.78           C
ATOM    180  C6   DA C   5      -3.761   0.226 -13.474  1.00 25.22           C
ATOM    181  N6   DA C   5      -4.519   1.150 -12.896  1.00 25.69           N
ATOM    182  N1   DA C   5      -2.485   0.535 -13.749  1.00 24.39           N
ATOM    183  C2   DA C   5      -1.712  -0.389 -14.320  1.00 24.89           C
ATOM    184  N3   DA C   5      -2.001  -1.641 -14.653  1.00 28.33           N
ATOM    185  C4   DA C   5      -3.268  -1.935 -14.326  1.00 27.45           C
ATOM    186  P    DA C   6      -1.382  -8.057 -15.083  1.00 33.49           P
ATOM    187  OP1  DA C   6      -0.596  -8.971 -15.989  1.00 35.26           O
ATOM    188  OP2  DA C   6      -2.097  -8.481 -13.890  1.00 34.48           O
ATOM    189  O5'  DA C   6      -0.480  -6.949 -14.401  1.00 31.72           O
ATOM    190  C5'  DA C   6       0.398  -6.138 -15.188  1.00 28.12           C
ATOM    191  C4'  DA C   6       1.219  -5.272 -14.269  1.00 22.57           C
ATOM    192  O4'  DA C   6       0.380  -4.203 -13.784  1.00 23.34           O
ATOM    193  C3'  DA C   6       1.783  -5.982 -13.049  1.00 23.61           C
ATOM    194  O3'  DA C   6       3.202  -5.785 -13.150  1.00 22.60           O
ATOM    195  C2'  DA C   6       1.110  -5.289 -11.881  1.00 22.21           C
ATOM    196  C1'  DA C   6       0.653  -3.958 -12.418  1.00 20.89           C
ATOM    197  N9   DA C   6      -0.561  -3.398 -11.831  1.00 21.71           N
ATOM    198  C8   DA C   6      -1.777  -4.017 -11.666  1.00 23.62           C
ATOM    199  N7   DA C   6      -2.693  -3.249 -11.139  1.00 23.57           N
ATOM    200  C5   DA C   6      -2.071  -2.016 -11.029  1.00 20.29           C
ATOM    201  C6   DA C   6      -2.506  -0.774 -10.519  1.00 20.33           C
ATOM    202  N6   DA C   6      -3.763  -0.525 -10.122  1.00 20.36           N
ATOM    203  N1   DA C   6      -1.604   0.233 -10.486  1.00 20.84           N
ATOM    204  C2   DA C   6      -0.341  -0.023 -10.868  1.00 21.15           C
ATOM    205  N3   DA C   6       0.174  -1.126 -11.378  1.00 22.91           N
ATOM    206  C4   DA C   6      -0.746  -2.101 -11.433  1.00 20.00           C
ATOM    207  P    DT C   7       4.283  -6.215 -12.051  1.00 23.53           P
ATOM    208  OP1  DT C   7       5.598  -6.398 -12.780  1.00 27.73           O
ATOM    209  OP2  DT C   7       3.774  -7.297 -11.205  1.00 24.18           O
ATOM    210  O5'  DT C   7       4.350  -4.948 -11.106  1.00 22.94           O
ATOM    211  C5'  DT C   7       4.668  -3.709 -11.633  1.00 21.30           C
ATOM    212  C4'  DT C   7       4.525  -2.656 -10.580  1.00 20.84           C
ATOM    213  O4'  DT C   7       3.138  -2.512 -10.296  1.00 19.94           O
ATOM    214  C3'  DT C   7       5.205  -2.966  -9.250  1.00 20.02           C
ATOM    215  O3'  DT C   7       6.280  -2.035  -9.099  1.00 23.74           O
ATOM    216  C2'  DT C   7       4.144  -2.717  -8.200  1.00 19.47           C
ATOM    217  C1'  DT C   7       3.048  -2.015  -8.962  1.00 20.12           C
ATOM    218  N1   DT C   7       1.641  -2.197  -8.524  1.00 20.27           N
ATOM    219  C2   DT C   7       0.957  -1.108  -8.030  1.00 18.61           C
ATOM    220  O2   DT C   7       1.430   0.017  -7.926  1.00 19.56           O
ATOM    221  N3   DT C   7      -0.344  -1.365  -7.721  1.00 18.89           N
ATOM    222  C4   DT C   7      -1.018  -2.563  -7.836  1.00 21.94           C
ATOM    223  O4   DT C   7      -2.200  -2.640  -7.497  1.00 23.57           O
ATOM    224  C5   DT C   7      -0.226  -3.674  -8.271  1.00 18.09           C
ATOM    225  C7   DT C   7      -0.860  -5.022  -8.351  1.00 19.35           C
ATOM    226  C6   DT C   7       1.065  -3.446  -8.562  1.00 17.66           C
ATOM    227  P    DT C   8       7.284  -1.980  -7.857  1.00 26.43           P
ATOM    228  OP1  DT C   8       8.611  -1.444  -8.278  1.00 28.45           O
ATOM    229  OP2  DT C   8       7.248  -3.298  -7.198  1.00 27.17           O
ATOM    230  O5'  DT C   8       6.613  -0.927  -6.882  1.00 25.09           O
ATOM    231  C5'  DT C   8       6.357   0.403  -7.340  1.00 24.67           C
ATOM    232  C4'  DT C   8       5.543   1.125  -6.301  1.00 23.10           C
ATOM    233  O4'  DT C   8       4.228   0.541  -6.229  1.00 23.60           O
ATOM    234  C3'  DT C   8       6.127   1.057  -4.884  1.00 25.21           C
ATOM    235  O3'  DT C   8       6.507   2.380  -4.493  1.00 28.93           O
ATOM    236  C2'  DT C   8       5.018   0.434  -4.050  1.00 23.32           C
ATOM    237  C1'  DT C   8       3.795   0.667  -4.883  1.00 22.06           C
ATOM    238  N1   DT C   8       2.713  -0.291  -4.689  1.00 19.79           N
ATOM    239  C2   DT C   8       1.466   0.223  -4.414  1.00 18.40           C
ATOM    240  O2   DT C   8       1.263   1.399  -4.157  1.00 20.56           O
ATOM    241  N3   DT C   8       0.484  -0.716  -4.337  1.00 19.20           N
ATOM    242  C4   DT C   8       0.588  -2.075  -4.597  1.00 18.45           C
ATOM    243  O4   DT C   8      -0.397  -2.789  -4.538  1.00 21.38           O
ATOM    244  C5   DT C   8       1.920  -2.549  -4.859  1.00 17.02           C
ATOM    245  C7   DT C   8       2.126  -4.006  -5.116  1.00 20.50           C
ATOM    246  C6   DT C   8       2.895  -1.634  -4.959  1.00 19.29           C
TER
ATOM    247  P    DA D  17     -10.220   1.260  -1.207  1.00 27.94           P
ATOM    248  OP1  DA D  17     -11.370   2.143  -0.856  1.00 34.83           O
ATOM    249  OP2  DA D  17     -10.221   0.599  -2.553  1.00 31.17           O
ATOM    250  O5'  DA D  17      -8.842   2.020  -1.098  1.00 26.12           O
ATOM    251  C5'  DA D  17      -8.558   2.683   0.094  1.00 25.41           C
ATOM    252  C4'  DA D  17      -7.407   3.619  -0.107  1.00 26.38           C
ATOM    253  O4'  DA D  17      -6.208   2.886  -0.440  1.00 24.41           O
ATOM    254  C3'  DA D  17      -7.600   4.631  -1.214  1.00 27.57           C
ATOM    255  O3'  DA D  17      -6.972   5.834  -0.764  1.00 29.89           O
ATOM    256  C2'  DA D  17      -6.902   3.980  -2.406  1.00 26.29           C
ATOM    257  C1'  DA D  17      -5.771   3.225  -1.781  1.00 23.13           C
ATOM    258  N9   DA D  17      -5.444   1.986  -2.460  1.00 22.66           N
ATOM    259  C8   DA D  17      -6.295   0.942  -2.750  1.00 23.38           C
ATOM    260  N7   DA D  17      -5.700  -0.094  -3.288  1.00 20.62           N
ATOM    261  C5   DA D  17      -4.344   0.242  -3.234  1.00 20.59           C
ATOM    262  C6   DA D  17      -3.178  -0.447  -3.603  1.00 17.89           C
ATOM    263  N6   DA D  17      -3.184  -1.685  -4.072  1.00 20.22           N
ATOM    264  N1   DA D  17      -1.995   0.205  -3.497  1.00 19.61           N
ATOM    265  C2   DA D  17      -1.992   1.465  -3.030  1.00 20.38           C
ATOM    266  N3   DA D  17      -3.021   2.207  -2.621  1.00 20.80           N
ATOM    267  C4   DA D  17      -4.182   1.540  -2.774  1.00 19.17           C
ATOM    268  P    DA D  18      -6.994   7.132  -1.670  1.00 32.91           P
ATOM    269  OP1  DA D  18      -6.817   8.281  -0.798  1.00 37.55           O
ATOM    270  OP2  DA D  18      -8.060   7.037  -2.636  1.00 31.04           O
ATOM    271  O5'  DA D  18      -5.659   7.052  -2.535  1.00 30.20           O
ATOM    272  C5'  DA D  18      -4.377   7.074  -1.958  1.00 30.19           C
ATOM    273  C4'  DA D  18      -3.354   6.838  -3.036  1.00 28.09           C
ATOM    274  O4'  DA D  18      -3.424   5.481  -3.484  1.00 26.27           O
ATOM    275  C3'  DA D  18      -3.545   7.708  -4.286  1.00 29.73           C
ATOM    276  O3'  DA D  18      -2.469   8.627  -4.273  1.00 34.73           O
ATOM    277  C2'  DA D  18      -3.566   6.715  -5.433  1.00 27.32           C
ATOM    278  C1'  DA D  18      -3.010   5.448  -4.841  1.00 24.83           C
ATOM    279  N9   DA D  18      -3.488   4.196  -5.410  1.00 23.72           N
ATOM    280  C8   DA D  18      -4.794   3.799  -5.530  1.00 20.51           C
ATOM    281  N7   DA D  18      -4.937   2.581  -5.985  1.00 22.85           N
ATOM    282  C5   DA D  18      -3.636   2.147  -6.189  1.00 20.87           C
ATOM    283  C6   DA D  18      -3.111   0.950  -6.675  1.00 19.34           C
ATOM    284  N6   DA D  18      -3.852  -0.099  -7.028  1.00 21.88           N
ATOM    285  N1   DA D  18      -1.767   0.849  -6.776  1.00 19.77           N
ATOM    286  C2   DA D  18      -1.023   1.872  -6.374  1.00 21.42           C
ATOM    287  N3   DA D  18      -1.392   3.050  -5.910  1.00 22.19           N
ATOM    288  C4   DA D  18      -2.734   3.129  -5.836  1.00 21.41           C
ATOM    289  P    DT D  19      -2.064   9.546  -5.497  1.00 40.82           P
ATOM    290  OP1  DT D  19      -1.281  10.615  -4.939  1.00 44.52           O
ATOM    291  OP2  DT D  19      -3.292   9.787  -6.271  1.00 44.69           O
ATOM    292  O5'  DT D  19      -1.119   8.619  -6.355  1.00 30.72           O
ATOM    293  C5'  DT D  19       0.059   8.093  -5.804  1.00 29.16           C
ATOM    294  C4'  DT D  19       0.704   7.195  -6.832  1.00 26.15           C
ATOM    295  O4'  DT D  19      -0.129   6.045  -7.087  1.00 26.00           O
ATOM    296  C3'  DT D  19       0.941   7.859  -8.188  1.00 25.98           C
ATOM    297  O3'  DT D  19       2.343   7.877  -8.376  1.00 30.07           O
ATOM    298  C2'  DT D  19       0.207   6.968  -9.181  1.00 26.77           C
ATOM    299  C1'  DT D  19       0.036   5.665  -8.443  1.00 25.87           C
ATOM    300  N1   DT D  19      -1.122   4.839  -8.816  1.00 24.60           N
ATOM    301  C2   DT D  19      -0.906   3.556  -9.283  1.00 22.21           C
ATOM    302  O2   DT D  19       0.197   3.084  -9.451  1.00 22.06           O
ATOM    303  N3   DT D  19      -2.038   2.833  -9.519  1.00 22.04           N
ATOM    304  C4   DT D  19      -3.339   3.262  -9.380  1.00 21.81           C
ATOM    305  O4   DT D  19      -4.247   2.495  -9.615  1.00 24.16           O
ATOM    306  C5   DT D  19      -3.499   4.613  -8.891  1.00 22.25           C
ATOM    307  C7   DT D  19      -4.879   5.143  -8.663  1.00 23.26           C
ATOM    308  C6   DT D  19      -2.396   5.327  -8.640  1.00 22.85           C
ATOM    309  P    DT D  20       3.005   8.456  -9.725  1.00 32.03           P
ATOM    310  OP1  DT D  20       4.339   8.958  -9.284  1.00 35.31           O
ATOM    311  OP2  DT D  20       2.027   9.351 -10.442  1.00 33.99           O
ATOM    312  O5'  DT D  20       3.144   7.102 -10.543  1.00 31.33           O
ATOM    313  C5'  DT D  20       3.894   5.979 -10.032  1.00 28.60           C
ATOM    314  C4'  DT D  20       3.851   4.840 -11.020  1.00 28.63           C
ATOM    315  O4'  DT D  20       2.494   4.361 -11.145  1.00 26.47           O
ATOM    316  C3'  DT D  20       4.300   5.211 -12.437  1.00 31.59           C
ATOM    317  O3'  DT D  20       5.260   4.256 -12.875  1.00 39.07           O
ATOM    318  C2'  DT D  20       3.027   5.147 -13.257  1.00 26.06           C
ATOM    319  C1'  DT D  20       2.211   4.120 -12.529  1.00 24.42           C
ATOM    320  N1   DT D  20       0.757   4.123 -12.660  1.00 23.79           N
ATOM    321  C2   DT D  20       0.138   2.932 -12.972  1.00 25.04           C
ATOM    322  O2   DT D  20       0.741   1.921 -13.262  1.00 24.66           O
ATOM    323  N3   DT D  20      -1.229   2.977 -12.959  1.00 25.84           N
ATOM    324  C4   DT D  20      -2.022   4.071 -12.671  1.00 25.98           C
ATOM    325  O4   DT D  20      -3.234   3.948 -12.646  1.00 28.14           O
ATOM    326  C5   DT D  20      -1.311   5.298 -12.387  1.00 22.81           C
ATOM    327  C7   DT D  20      -2.094   6.540 -12.092  1.00 27.47           C
ATOM    328  C6   DT D  20       0.028   5.263 -12.401  1.00 26.29           C
TER
END
"""

pdb_AB = '''\
ATOM      1  CB  MET B   1      52.886   1.976   9.011  1.00 41.44           C
ATOM      2  CG  MET B   1      53.271   0.996  10.102  1.00 47.36           C
ATOM      3  SD  MET B   1      55.066   1.105  10.320  1.00 54.87           S
ATOM      4  CE  MET B   1      55.198   1.758  11.963  1.00 52.95           C
ATOM      5  C   MET B   1      51.257   3.002   7.473  1.00 32.90           C
ATOM      6  O   MET B   1      51.643   3.028   6.297  1.00 33.11           O
ATOM      7  N   MET B   1      51.320   0.535   7.805  1.00 38.36           N
ATOM      8  CA  MET B   1      51.486   1.834   8.434  1.00 36.79           C
TER
ATOM      1  CB  MET A   1       0.115  20.271   3.107  1.00 41.44           C
ATOM      2  CG  MET A   1       0.717  21.085   1.978  1.00 47.36           C
ATOM      3  SD  MET A   1       1.424  22.584   2.709  1.00 54.87           S
ATOM      4  CE  MET A   1       3.156  22.361   2.406  1.00 52.95           C
ATOM      5  C   MET A   1      -1.177  18.359   3.971  1.00 32.90           C
ATOM      6  O   MET A   1      -2.072  18.689   4.760  1.00 33.11           O
ATOM      7  N   MET A   1      -1.968  19.642   1.989  1.00 38.36           N
ATOM      8  CA  MET A   1      -0.810  19.133   2.704  1.00 36.79           C
'''

pdb_space = '''\
ATOM      1  CB  MET     1      52.886   1.976   9.011  1.00 41.44           C
ATOM      2  CG  MET     1      53.271   0.996  10.102  1.00 47.36           C
ATOM      3  SD  MET     1      55.066   1.105  10.320  1.00 54.87           S
ATOM      4  CE  MET     1      55.198   1.758  11.963  1.00 52.95           C
ATOM      5  C   MET     1      51.257   3.002   7.473  1.00 32.90           C
ATOM      6  O   MET     1      51.643   3.028   6.297  1.00 33.11           O
ATOM      7  N   MET     1      51.320   0.535   7.805  1.00 38.36           N
ATOM      8  CA  MET     1      51.486   1.834   8.434  1.00 36.79           C
TER
ATOM      1  CB  MET A   1       0.115  20.271   3.107  1.00 41.44           C
ATOM      2  CG  MET A   1       0.717  21.085   1.978  1.00 47.36           C
ATOM      3  SD  MET A   1       1.424  22.584   2.709  1.00 54.87           S
ATOM      4  CE  MET A   1       3.156  22.361   2.406  1.00 52.95           C
ATOM      5  C   MET A   1      -1.177  18.359   3.971  1.00 32.90           C
ATOM      6  O   MET A   1      -2.072  18.689   4.760  1.00 33.11           O
ATOM      7  N   MET A   1      -1.968  19.642   1.989  1.00 38.36           N
ATOM      8  CA  MET A   1      -0.810  19.133   2.704  1.00 36.79           C
'''

pdb_stars = '''\
ATOM      1  CB  MET**   1      52.886   1.976   9.011  1.00 41.44           C
ATOM      2  CG  MET**   1      53.271   0.996  10.102  1.00 47.36           C
ATOM      3  SD  MET**   1      55.066   1.105  10.320  1.00 54.87           S
ATOM      4  CE  MET**   1      55.198   1.758  11.963  1.00 52.95           C
ATOM      5  C   MET**   1      51.257   3.002   7.473  1.00 32.90           C
ATOM      6  O   MET**   1      51.643   3.028   6.297  1.00 33.11           O
ATOM      7  N   MET**   1      51.320   0.535   7.805  1.00 38.36           N
ATOM      8  CA  MET**   1      51.486   1.834   8.434  1.00 36.79           C
TER
ATOM      1  CB  MET A   1       0.115  20.271   3.107  1.00 41.44           C
ATOM      2  CG  MET A   1       0.717  21.085   1.978  1.00 47.36           C
ATOM      3  SD  MET A   1       1.424  22.584   2.709  1.00 54.87           S
ATOM      4  CE  MET A   1       3.156  22.361   2.406  1.00 52.95           C
ATOM      5  C   MET A   1      -1.177  18.359   3.971  1.00 32.90           C
ATOM      6  O   MET A   1      -2.072  18.689   4.760  1.00 33.11           O
ATOM      7  N   MET A   1      -1.968  19.642   1.989  1.00 38.36           N
ATOM      8  CA  MET A   1      -0.810  19.133   2.704  1.00 36.79           C
'''

pdb_stars_and_spaces = '''\
ATOM      1  CB  MET**   1      52.886   1.976   9.011  1.00 41.44           C
ATOM      2  CG  MET**   1      53.271   0.996  10.102  1.00 47.36           C
ATOM      3  SD  MET**   1      55.066   1.105  10.320  1.00 54.87           S
ATOM      4  CE  MET**   1      55.198   1.758  11.963  1.00 52.95           C
ATOM      5  C   MET**   1      51.257   3.002   7.473  1.00 32.90           C
ATOM      6  O   MET**   1      51.643   3.028   6.297  1.00 33.11           O
ATOM      7  N   MET**   1      51.320   0.535   7.805  1.00 38.36           N
ATOM      8  CA  MET**   1      51.486   1.834   8.434  1.00 36.79           C
TER
ATOM      1  CB  MET     1       0.115  20.271   3.107  1.00 41.44           C
ATOM      2  CG  MET     1       0.717  21.085   1.978  1.00 47.36           C
ATOM      3  SD  MET     1       1.424  22.584   2.709  1.00 54.87           S
ATOM      4  CE  MET     1       3.156  22.361   2.406  1.00 52.95           C
ATOM      5  C   MET     1      -1.177  18.359   3.971  1.00 32.90           C
ATOM      6  O   MET     1      -2.072  18.689   4.760  1.00 33.11           O
ATOM      7  N   MET     1      -1.968  19.642   1.989  1.00 38.36           N
ATOM      8  CA  MET     1      -0.810  19.133   2.704  1.00 36.79           C
'''

pdb_str_23 = """\
CRYST1  178.041  178.041  241.485  90.00  90.00  90.00 P 4 21 2
SCALE1      0.005617  0.000000  0.000000        0.00000
SCALE2      0.000000  0.005617  0.000000        0.00000
SCALE3      0.000000  0.000000  0.004141        0.00000
ATOM      1  N   VAL A 175       4.326 -59.034 -15.595  1.00105.80           N
ATOM      2  CA  VAL A 175       5.525 -58.206 -15.617  1.00 86.22           C
ATOM      3  C   VAL A 175       6.348 -58.476 -14.358  1.00 61.80           C
ATOM      4  O   VAL A 175       5.879 -59.158 -13.445  1.00 58.55           O
TER
ATOM   2117  N   THR B 174     -15.180 -65.753 -17.549  1.00113.31           N
ATOM   2118  CA  THR B 174     -14.857 -64.334 -17.581  1.00120.94           C
ATOM   2119  C   THR B 174     -15.877 -63.524 -16.808  1.00109.70           C
ATOM   2120  O   THR B 174     -15.828 -62.302 -16.798  1.00110.07           O
TER
ATOM   9373  N   LYS F  30     -75.643   8.901 124.736  1.00205.41           N
ATOM   9374  CA  LYS F  30     -74.928  10.142 125.003  1.00200.32           C
ATOM   9375  C   LYS F  30     -75.558  11.283 124.229  1.00198.69           C
ATOM   9376  O   LYS F  30     -74.919  11.832 123.330  1.00194.89           O
ATOM   9377  N   THR F  31     -76.807  11.640 124.555  1.00163.49           N
ATOM   9378  CA  THR F  31     -77.445  12.728 123.826  1.00162.32           C
ATOM   9379  C   THR F  31     -76.491  13.902 123.640  1.00160.35           C
ATOM   9380  O   THR F  31     -76.874  15.060 123.806  1.00158.76           O
TER
END
"""

pdb_str_24 = """
CRYST1   76.486   77.631  216.881  90.00  90.00  90.00 P 21 21 21
SCALE1      0.013074  0.000000  0.000000        0.00000
SCALE2      0.000000  0.012881  0.000000        0.00000
SCALE3      0.000000  0.000000  0.004611        0.00000
ATOM    982  N   ARG A 125       9.773  18.491  33.022  1.00 61.37           N
ATOM    983  CA  ARG A 125      10.267  17.380  32.220  1.00 71.35           C
ATOM    984  C   ARG A 125      11.259  16.547  33.018  1.00 62.76           C
ATOM    985  O   ARG A 125      11.140  15.318  33.094  1.00 72.81           O
ATOM    986  CB  ARG A 125      10.900  17.905  30.931  1.00 64.16           C
ATOM    987  CG  ARG A 125       9.880  18.399  29.916  1.00 40.86           C
ATOM    988  CD  ARG A 125      10.531  18.918  28.646  1.00 48.22           C
ATOM    989  NE  ARG A 125       9.529  19.321  27.662  1.00 52.59           N
ATOM    990  CZ  ARG A 125       9.806  19.880  26.488  1.00 48.26           C
ATOM    991  NH1 ARG A 125      11.062  20.113  26.134  1.00 48.70           N
ATOM    992  NH2 ARG A 125       8.819  20.210  25.666  1.00 49.04           N
ATOM    993  N   GLU A 126      12.225  17.205  33.662  1.00 63.21           N
ATOM    994  CA  GLU A 126      13.225  16.450  34.406  1.00 78.02           C
ATOM    995  C   GLU A 126      12.632  15.795  35.650  1.00 89.06           C
ATOM    996  O   GLU A 126      13.057  14.698  36.028  1.00103.40           O
ATOM    997  CB  GLU A 126      14.401  17.349  34.782  1.00 82.45           C
ATOM    998  CG  GLU A 126      15.677  16.568  35.092  1.00 91.17           C
ATOM    999  CD  GLU A 126      16.917  17.159  34.440  1.00109.97           C
ATOM   1000  OE1 GLU A 126      18.031  16.899  34.945  1.00109.65           O
ATOM   1001  OE2 GLU A 126      16.785  17.875  33.425  1.00 97.57           O
ATOM   1002  N   LYS A 127      11.648  16.430  36.293  1.00 75.13           N
ATOM   1003  CA  LYS A 127      11.018  15.805  37.452  1.00 69.58           C
ATOM   1004  C   LYS A 127      10.264  14.546  37.045  1.00 88.59           C
ATOM   1005  O   LYS A 127      10.483  13.469  37.611  1.00105.79           O
ATOM   1006  CB  LYS A 127      10.074  16.787  38.148  1.00 78.73           C
ATOM   1007  CG  LYS A 127       9.598  16.287  39.509  1.00 91.26           C
ATOM   1008  CD  LYS A 127       8.654  17.260  40.202  1.00 90.42           C
ATOM   1009  CE  LYS A 127       7.239  17.168  39.654  1.00 84.11           C
ATOM   1010  NZ  LYS A 127       6.224  17.503  40.695  1.00 84.76           N
ATOM   1011  N   ASP A 128       9.365  14.663  36.065  1.00 90.36           N
ATOM   1012  CA  ASP A 128       8.652  13.493  35.571  1.00 97.11           C
ATOM   1013  C   ASP A 128       9.608  12.437  35.031  1.00103.15           C
ATOM   1014  O   ASP A 128       9.257  11.253  35.002  1.00106.89           O
ATOM   1015  CB  ASP A 128       7.649  13.911  34.493  1.00 80.42           C
ATOM   1016  CG  ASP A 128       6.552  12.883  34.281  1.00101.74           C
ATOM   1017  OD1 ASP A 128       6.682  11.752  34.795  1.00109.66           O
ATOM   1018  OD2 ASP A 128       5.553  13.211  33.606  1.00103.92           O
ATOM   1019  N   ARG A 129      10.808  12.837  34.602  1.00 97.73           N
ATOM   1020  CA  ARG A 129      11.841  11.854  34.292  1.00 95.38           C
ATOM   1021  C   ARG A 129      12.283  11.127  35.556  1.00 98.41           C
ATOM   1022  O   ARG A 129      12.298   9.892  35.603  1.00 95.12           O
ATOM   1023  CB  ARG A 129      13.028  12.544  33.618  1.00 85.97           C
ATOM   1024  CG  ARG A 129      13.890  11.631  32.758  1.00 74.83           C
ATOM   1025  CD  ARG A 129      14.881  10.822  33.579  1.00 92.99           C
ATOM   1026  NE  ARG A 129      15.876  11.663  34.243  1.00 98.70           N
ATOM   1027  CZ  ARG A 129      17.000  12.095  33.675  1.00 88.85           C
ATOM   1028  NH1 ARG A 129      17.284  11.777  32.418  1.00 74.86           N
ATOM   1029  NH2 ARG A 129      17.844  12.852  34.366  1.00 76.69           N
ATOM   1030  N   LEU A 130      12.646  11.884  36.592  1.00104.97           N
ATOM   1031  CA  LEU A 130      13.022  11.312  37.879  1.00112.32           C
ATOM   1032  C   LEU A 130      11.932  10.388  38.404  1.00110.14           C
ATOM   1033  O   LEU A 130      12.101   9.164  38.428  1.00103.14           O
ATOM   1034  CB  LEU A 130      13.297  12.423  38.897  1.00 91.77           C
ATOM   1035  CG  LEU A 130      14.750  12.866  39.084  1.00 80.63           C
ATOM   1036  CD1 LEU A 130      15.545  11.798  39.827  1.00 97.71           C
ATOM   1037  CD2 LEU A 130      15.405  13.195  37.751  1.00 95.08           C
TER
ATOM   8774  N   ARG F 125      10.452  30.705  49.041  1.00 51.45           N
ATOM   8775  CA  ARG F 125       9.875  31.452  50.151  1.00 42.65           C
ATOM   8776  C   ARG F 125       8.537  30.856  50.561  1.00 58.84           C
ATOM   8777  O   ARG F 125       8.272  30.655  51.753  1.00 62.79           O
ATOM   8778  CB  ARG F 125       9.726  32.926  49.770  1.00 34.75           C
ATOM   8779  CG  ARG F 125      10.998  33.739  49.974  1.00 48.58           C
ATOM   8780  CD  ARG F 125      10.892  35.136  49.381  1.00 47.83           C
ATOM   8781  NE  ARG F 125      12.120  35.903  49.575  1.00 40.07           N
ATOM   8782  CZ  ARG F 125      12.304  37.149  49.150  1.00 35.39           C
ATOM   8783  NH1 ARG F 125      11.339  37.784  48.497  1.00 36.70           N
ATOM   8784  NH2 ARG F 125      13.457  37.762  49.378  1.00 40.69           N
ATOM   8785  N   GLU F 126       7.681  30.547  49.582  1.00 76.22           N
ATOM   8786  CA  GLU F 126       6.396  29.945  49.928  1.00 61.43           C
ATOM   8787  C   GLU F 126       6.565  28.523  50.449  1.00 57.03           C
ATOM   8788  O   GLU F 126       5.822  28.102  51.343  1.00 57.49           O
ATOM   8789  CB  GLU F 126       5.453  29.974  48.726  1.00 59.74           C
ATOM   8790  CG  GLU F 126       4.365  31.031  48.849  1.00 60.06           C
ATOM   8791  CD  GLU F 126       4.927  32.411  49.126  1.00 81.51           C
ATOM   8792  OE1 GLU F 126       5.740  32.899  48.312  1.00 85.73           O
ATOM   8793  OE2 GLU F 126       4.566  33.001  50.167  1.00 81.43           O
ATOM   8794  N   LYS F 127       7.544  27.779  49.930  1.00 58.23           N
ATOM   8795  CA  LYS F 127       7.805  26.440  50.445  1.00 51.76           C
ATOM   8796  C   LYS F 127       8.193  26.488  51.919  1.00 65.55           C
ATOM   8797  O   LYS F 127       7.712  25.679  52.722  1.00 72.54           O
ATOM   8798  CB  LYS F 127       8.900  25.772  49.610  1.00 63.55           C
ATOM   8799  CG  LYS F 127       9.291  24.369  50.056  1.00 91.13           C
ATOM   8800  CD  LYS F 127      10.356  23.778  49.134  1.00 94.56           C
ATOM   8801  CE  LYS F 127       9.769  22.767  48.155  1.00 96.34           C
ATOM   8802  NZ  LYS F 127       9.419  21.477  48.818  1.00 86.37           N
ATOM   8803  N  BASP F 128       9.133  27.361  52.316  0.38 62.87           N
ATOM   8804  CA BASP F 128       9.578  27.468  53.744  0.38 48.81           C
ATOM   8805  C  BASP F 128       8.425  28.107  54.594  0.38 59.71           C
ATOM   8806  O  BASP F 128       8.291  27.636  55.724  0.38 63.03           O
ATOM   8807  CB BASP F 128      10.872  28.273  53.854  0.38 65.51           C
ATOM   8808  CG BASP F 128      12.065  27.592  53.215  0.38 65.67           C
ATOM   8809  OD1BASP F 128      12.020  26.366  53.054  0.38 54.17           O
ATOM   8810  OD2BASP F 128      13.027  28.297  52.884  0.38 76.43           O
ATOM   8811  N   ARG F 129       7.611  29.111  54.153  1.00 68.75           N
ATOM   8812  CA  ARG F 129       6.434  29.572  54.862  1.00 58.29           C
ATOM   8813  C   ARG F 129       5.449  28.434  55.079  1.00 71.92           C
ATOM   8814  O   ARG F 129       4.763  28.394  56.107  1.00 73.61           O
ATOM   8815  CB  ARG F 129       5.809  30.711  54.070  1.00 68.67           C
ATOM   8816  CG  ARG F 129       4.624  31.350  54.722  1.00 54.93           C
ATOM   8817  CD  ARG F 129       4.361  32.689  54.077  1.00 64.27           C
ATOM   8818  NE  ARG F 129       5.336  33.692  54.502  1.00123.14           N
ATOM   8819  CZ  ARG F 129       5.576  34.828  53.854  1.00119.24           C
ATOM   8820  NH1 ARG F 129       4.920  35.109  52.735  1.00107.68           N
ATOM   8821  NH2 ARG F 129       6.480  35.682  54.320  1.00119.09           N
ATOM   8822  N   LEU F 130       5.387  27.485  54.140  1.00 74.90           N
ATOM   8823  CA  LEU F 130       4.517  26.326  54.310  1.00 71.49           C
ATOM   8824  C   LEU F 130       5.032  25.387  55.393  1.00 66.21           C
ATOM   8825  O   LEU F 130       4.236  24.707  56.050  1.00 59.85           O
ATOM   8826  CB  LEU F 130       4.385  25.575  52.987  1.00 64.81           C
ATOM   8827  CG  LEU F 130       3.071  24.818  52.807  1.00 41.77           C
ATOM   8828  CD1 LEU F 130       1.947  25.797  52.493  1.00 61.75           C
ATOM   8829  CD2 LEU F 130       3.202  23.768  51.721  1.00 46.78           C
TER
HETATM 9346  C1' CTP A 201       4.240  18.558  36.758  0.93 67.75           C
HETATM 9347  C2  CTP A 201       3.926  20.715  37.868  0.93 70.26           C
HETATM 9348  C2' CTP A 201       3.416  17.353  37.127  0.93 75.55           C
HETATM 9349  C3' CTP A 201       3.873  16.336  36.043  0.93 75.44           C
HETATM 9350  C4  CTP A 201       2.178  22.080  37.193  0.93 48.66           C
HETATM 9351  C4' CTP A 201       4.865  17.117  35.203  0.93 76.06           C
HETATM 9352  C5  CTP A 201       1.760  21.161  36.234  0.93 51.30           C
HETATM 9353  C5' CTP A 201       4.677  16.780  33.753  0.93 76.35           C
HETATM 9354  C6  CTP A 201       2.471  20.001  36.124  0.93 54.86           C
HETATM 9355  N1  CTP A 201       3.496  19.767  36.904  0.93 58.61           N
HETATM 9356  N3  CTP A 201       3.232  21.889  38.003  0.93 63.86           N
HETATM 9357  N4  CTP A 201       1.525  23.225  37.317  0.93 39.11           N
HETATM 9358  O1A CTP A 201       3.054  15.039  32.621  0.93 87.57           O
HETATM 9359  O1B CTP A 201       0.836  16.529  29.242  0.93 81.12           O
HETATM 9360  O1G CTP A 201       3.539  15.284  27.178  0.93102.66           O
HETATM 9361  O2  CTP A 201       4.890  20.448  38.554  0.93 52.94           O
HETATM 9362  O2' CTP A 201       3.744  16.961  38.425  0.93 80.00           O
HETATM 9363  O2A CTP A 201       1.248  16.129  33.990  0.93 59.52           O
HETATM 9364  O2B CTP A 201       2.687  17.991  29.776  0.93 72.35           O
HETATM 9365  O2G CTP A 201       4.756  13.769  28.739  0.93 59.52           O
HETATM 9366  O3' CTP A 201       4.559  15.227  36.614  0.93 80.14           O
HETATM 9367  O3A CTP A 201       1.662  16.810  31.626  0.93 60.30           O
HETATM 9368  O3B CTP A 201       3.120  15.501  29.842  0.93 72.11           O
HETATM 9369  O3G CTP A 201       2.318  13.561  28.541  0.93 98.31           O
HETATM 9370  O4' CTP A 201       4.553  18.476  35.419  0.93 62.09           O
HETATM 9371  O5' CTP A 201       3.367  17.217  33.356  0.93 75.19           O
HETATM 9372  PA  CTP A 201       2.270  16.205  32.913  0.93 66.87           P
HETATM 9373  PB  CTP A 201       2.123  16.651  29.985  0.93 91.05           P
HETATM 9374  PG  CTP A 201       3.489  14.512  28.471  0.93101.70           P
HETATM 9491  C1'ACTP F 201      13.964  26.733  50.766  0.62 67.52           C
HETATM 9492  C2 ACTP F 201      14.486  25.231  48.851  0.62 68.70           C
HETATM 9493  C2'ACTP F 201      14.100  26.070  52.113  0.62 64.29           C
HETATM 9494  C3'ACTP F 201      13.449  27.153  53.025  0.62 72.35           C
HETATM 9495  C4 ACTP F 201      16.626  25.201  47.926  0.62 63.87           C
HETATM 9496  C4'ACTP F 201      13.432  28.417  52.150  0.62 69.82           C
HETATM 9497  C5 ACTP F 201      17.094  26.167  48.844  0.62 58.73           C
HETATM 9498  C5'ACTP F 201      14.053  29.615  52.865  0.62 72.42           C
HETATM 9499  C6 ACTP F 201      16.205  26.659  49.775  0.62 48.91           C
HETATM 9500  N1 ACTP F 201      14.945  26.216  49.801  0.62 62.55           N
HETATM 9501  N3 ACTP F 201      15.362  24.729  47.913  0.62 66.52           N
HETATM 9502  N4 ACTP F 201      17.473  24.696  47.011  0.62 60.14           N
HETATM 9503  O1AACTP F 201      16.477  28.303  52.040  0.62 66.78           O
HETATM 9504  O1BACTP F 201      17.264  31.510  52.100  0.62 75.29           O
HETATM 9505  O1GACTP F 201      18.721  35.021  52.963  0.62 67.59           O
HETATM 9506  O2 ACTP F 201      13.326  24.860  48.906  0.62 57.76           O
HETATM 9507  O2'ACTP F 201      13.395  24.871  52.103  0.62 58.72           O
HETATM 9508  O2AACTP F 201      16.693  27.769  54.499  0.62 79.47           O1-
HETATM 9509  O2BACTP F 201      15.812  31.687  54.293  0.62 87.41           O1-
HETATM 9510  O2GACTP F 201      17.245  34.852  54.963  0.62 54.68           O1-
HETATM 9511  O3'ACTP F 201      12.097  26.822  53.344  0.62 70.65           O
HETATM 9512  O3AACTP F 201      17.383  30.027  53.660  0.62 53.83           O
HETATM 9513  O3BACTP F 201      18.261  32.559  54.047  0.62 65.92           O
HETATM 9514  O3GACTP F 201      19.621  34.398  55.214  0.62 66.01           O1-
HETATM 9515  O4'ACTP F 201      14.182  28.093  50.949  0.62 63.99           O
HETATM 9516  O5'ACTP F 201      15.016  29.191  53.853  0.62 69.01           O
HETATM 9517  PA ACTP F 201      16.481  28.753  53.464  0.62 71.42           P
HETATM 9518  PB ACTP F 201      17.148  31.722  53.516  0.62 71.63           P
HETATM 9519  PG ACTP F 201      18.460  34.316  54.269  0.62 90.35           P
END
"""


def exercise_00(prefix="iotbx_ncs_exercise_00",debug=False):
  pdb_file_name = "%s.pdb"%prefix
  ncs_params_str = """
ncs_group {
  reference = chain A
  selection = chain B
  selection = chain C
}
  """
  def check_result(ncs_inp, test_i):
    if test_i == 0:
      l1, l2, l3 = [0,1,2,3], [4,5,6,7], [8,9,10,11]
    elif test_i == 1:
      l1, l2, l3 = [1,2,3,4], [5,6,7,8], [9,10,11,12]
    else: assert 0
    ncs_groups = ncs_inp.get_ncs_restraints_group_list()
    # ncs_groups._show()
    # STOP()
    assert len(ncs_groups) == 1, len(ncs_groups)
    ncs_group = ncs_groups[0]
    assert approx_equal(ncs_group.master_iselection, l1)
    assert len(ncs_group.copies) == 2
    assert approx_equal(ncs_group.copies[0].iselection, l2)
    assert approx_equal(ncs_group.copies[1].iselection, l3)
  files_to_delete = []
  for test_i, pdb_str in enumerate([
      pdb_str_1,
      pdb_str_2]):
    of = open(pdb_file_name, "w")
    files_to_delete.append(pdb_file_name)
    print(pdb_str, file=of)
    of.close()
    pdb_inp = iotbx.pdb.input(file_name = pdb_file_name)
    pdb_hierarchy = iotbx.pdb.input(file_name = pdb_file_name).\
        construct_hierarchy()
    # using pdb_hierarchy
    ncs_inp = ncs.input(hierarchy = pdb_hierarchy)
    check_result(ncs_inp,test_i)
  # cleanup
  if not debug:
    clean_temp_files(files_to_delete)

def exercise_01(prefix="iotbx_ncs_exercise_01", debug=False):
  """
  Make sure provided selections take precedence and are correctly respected.
  """
  pdb_file_name = "%s.pdb"%prefix
  ncs_params_str = """
ncs_group {
  reference = chain C
  selection = chain A
}
  """
  def check_result(ncs_inp, test_i):
    if test_i == 0:
      l1, l2 = [8,9,10,11], [0,1,2,3]
    elif test_i == 1:
      l1, l2 = [9,10,11,12], [1,2,3,4]
    else: assert 0
    ncs_groups = ncs_inp.get_ncs_restraints_group_list()
    assert len(ncs_groups) == 1
    ncs_group = ncs_groups[0]
    # print  "master sel:", list(ncs_group.master_iselection), l1
    # print "copy sel:", list(ncs_group.copies[0].iselection), l2
    assert approx_equal(ncs_group.master_iselection, l1)
    assert len(ncs_group.copies) == 1
    assert approx_equal(ncs_group.copies[0].iselection, l2)
  files_to_delete = []
  for test_i, pdb_str in enumerate([pdb_str_1, pdb_str_2]):
    files_to_delete.append(pdb_file_name)
    of = open(pdb_file_name, "w")
    print(pdb_str, file=of)
    of.close()
    pdb_inp = iotbx.pdb.input(file_name = pdb_file_name)

    # using combination of pdb_inp and Phil parameter string
    phil_groups = ncs_group_master_phil.fetch(
        iotbx.phil.parse(ncs_params_str)).extract()
    ncs_inp = ncs.input(hierarchy = pdb_inp.construct_hierarchy(),
      ncs_phil_groups=phil_groups.ncs_group)
    check_result(ncs_inp,test_i)
  if not debug:
    clean_temp_files(files_to_delete)

def exercise_03():
  """
  Expect one master and 3 copies.
  """
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_5)
  ncs_inp = ncs.input(hierarchy = pdb_inp.construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  # truncated_hierarchy also works here
  asc = ncs_inp.original_hierarchy.atom_selection_cache()
  sel_master = asc.selection(string = "chain 1")
  sel_copy_1 = asc.selection(string = "chain A")
  sel_copy_2 = asc.selection(string = "chain B")
  sel_copy_3 = asc.selection(string = "chain C")
  assert len(ncs_groups)==1
  ng = ncs_groups[0]
  # chains are sorted by name (numbers first)
  assert approx_equal(sel_master.iselection(), ng.master_iselection)
  assert approx_equal(sel_copy_1.iselection(), ng.copies[0].iselection)
  assert approx_equal(sel_copy_2.iselection(), ng.copies[1].iselection)
  assert approx_equal(sel_copy_3.iselection(), ng.copies[2].iselection)

def exercise_05():
  """
  Make sure that phil selection overrides ncs grouping
  """
  phil_str = """\
ncs_group {
  reference = chain A
  selection = chain C
}
ncs_group {
  reference = chain B
  selection = chain D
}
"""
  phil_groups = ncs_group_master_phil.fetch(
      iotbx.phil.parse(phil_str)).extract()
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_6)
  ncs_inp = ncs.input(
    hierarchy=pdb_inp.construct_hierarchy(),
    ncs_phil_groups=phil_groups.ncs_group)
  nrgl = ncs_inp.get_ncs_restraints_group_list()
  # print nrgl.get_array_of_str_selections()
  assert nrgl.get_array_of_str_selections() == \
      [["chain 'A'", "chain 'C'"], ["chain 'B'", "chain 'D'"]]

def exercise_06():
  """
  Two groups, different number of chain in each group.
  Two chains that are NOT ncs related
  """
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_7)
  ncs_inp = ncs.input(hierarchy=pdb_inp.construct_hierarchy())
  nrgl = ncs_inp.get_ncs_restraints_group_list()
  # print nrgl.get_array_of_str_selections()
  assert nrgl.get_array_of_str_selections() == \
      [["chain 'A'", "chain 'B'", "chain 'C'"], ["chain 'D'", "chain 'E'"]]

def exercise_07():
  """
  Test that minimal number of chains in master ncs are selected (not the
  minimal number of transformations)
  """
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_8)
  ncs_inp = ncs.input(hierarchy=pdb_inp.construct_hierarchy())
  nrgl = ncs_inp.get_ncs_restraints_group_list()
  # print nrgl.get_array_of_str_selections()
  assert nrgl.get_array_of_str_selections() == \
      [["chain 'A'", "chain 'B'", "chain 'C'", "chain 'D'", "chain 'E'",
        "chain 'F'", "chain 'G'", "chain 'H'", "chain 'I'"]]

def exercise_09():
  """
  Test minimal master NCS grouping
  make sure it does not group together similar chains that can be grouped and
  that NCS group and transforms created properly
  """
  from mmtbx.ncs import ncs_search
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_8)
  ph = pdb_inp.construct_hierarchy()
  #
  match_dict = ncs_search.search_ncs_relations(
    ph=ph,chain_similarity_threshold=0)
  # make sure that all possible chains compared
  model  = ph.models()[0]
  chain_ids = list({x.id for x in model.chains()})
  chain_ids = sorted(chain_ids)
  n_chains = len(chain_ids)
  assert n_chains==9
  assert len(match_dict)==8, len(match_dict)

def exercise_10():
  """ Test minimal NCS operators """
  from mmtbx.ncs import ncs_search
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_8)
  ph = pdb_inp.construct_hierarchy()
  #
  match_dict = ncs_search.search_ncs_relations(
    ph=ph,
    chain_similarity_threshold=0)
  #
  chains_info = ncs_search.get_chains_info(ph)
  #
  nrgl = ncs_search.ncs_grouping_and_group_dict(match_dict, ph)
  nrgl.update_str_selections_if_needed(ph)
  str_sel = nrgl.get_array_of_str_selections()
  print(str_sel)
  assert str_sel == [["chain 'A'", "chain 'B'", "chain 'C'", "chain 'D'",
      "chain 'E'", "chain 'F'", "chain 'G'", "chain 'H'", "chain 'I'"]]

def exercise_11():
  """
  Make sure user-provided NCS groups are preserved. Also make sure two-letter
  chain ID are handled correctly
  """
  phil_str="""
ncs_group {
  reference = chain 'Aa' and (resseq 6:9 )
  selection = chain 'Ac' and (resseq 6:9 )
}
ncs_group {
  reference = chain 'Ab' and (resseq 1:4 )
  selection = chain 'Ad' and (resseq 1:4 )
}
"""
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_9).construct_hierarchy().atom_selection_cache()
  ### default
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_9)
  ncs_inp = ncs.input(hierarchy=pdb_inp.construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()

  # no more grouping, therefore groups are like in phil_str above
  # ncs_inp.show(format='phil')
  assert len(ncs_groups)==2, len(ncs_groups)
  assert ncs_groups[0].master_iselection.all_eq(
    asc.selection(string = "chain Aa").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(
    asc.selection(string = "chain Ac").iselection())
  assert ncs_groups[1].master_iselection.all_eq(
    asc.selection(string = "chain Ab").iselection())
  g2_c = ncs_groups[1].copies
  assert len(g1_c)==1
  assert g2_c[0].iselection.all_eq(
    asc.selection(string = "chain Ad").iselection())

  # NO MORE GROUPING, therefore these are not valid
  # assert len(ncs_groups)==1, len(ncs_groups)
  # assert ncs_groups[0].master_iselection.all_eq(
  #   asc.selection(string = "chain Aa or chain Ab").iselection())
  # g1_c = ncs_groups[0].copies
  # assert len(g1_c)==1
  # assert g1_c[0].iselection.all_eq(
  #   asc.selection(string = "chain Ac or chain Ad").iselection())

  ### user-supplied
  phil_groups = ncs_group_master_phil.fetch(
      iotbx.phil.parse(phil_str)).extract()
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_9)
  ncs_inp = ncs.input(hierarchy=pdb_inp.construct_hierarchy(),
      ncs_phil_groups=phil_groups.ncs_group)
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==2
  # group 1
  assert ncs_groups[0].master_iselection.all_eq(
    asc.selection(string = "chain Aa and resseq 6:9").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(
    asc.selection(string = "chain Ac and resseq 6:9").iselection())
  # group 2
  assert ncs_groups[1].master_iselection.all_eq(
    asc.selection(string = "chain Ab and resseq 1:4").iselection())
  g1_c = ncs_groups[1].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(
    asc.selection(string = "chain Ad and resseq 1:4").iselection())

def exercise_12():
  """ Test dealing with chains names that are space or **"""
  ncs_obj_AB = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_AB).construct_hierarchy())
  ncs_obj_space = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_space).construct_hierarchy())
  ncs_obj_stars = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_stars).construct_hierarchy())
  ncs_obj_str_and_spc = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_stars_and_spaces).construct_hierarchy())
  #
  for ncs_obj in [
      ncs_obj_AB,
      ncs_obj_space,
      ncs_obj_stars,
      ncs_obj_str_and_spc]:
    ncs_groups = ncs_obj.get_ncs_restraints_group_list()
    assert len(ncs_groups) == 1
    assert ncs_groups[0].master_iselection.size() == 8
    assert ncs_groups[0].copies[0].iselection.size() == 8

def exercise_13():
  """
  PDB file with insertion codes.
  """
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_10).construct_hierarchy().atom_selection_cache()
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_10).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  assert ncs_groups[0].master_iselection.all_eq(
    asc.selection(string = "chain H").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(
    asc.selection(string = "chain L").iselection())

def exercise_14():
  """
  PDB file with alternative conformations.
  """
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_11).construct_hierarchy().atom_selection_cache()
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_11).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  assert ncs_groups[0].master_iselection.all_eq(asc.selection(
    string = "chain H and not (altloc A or altloc B)").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(asc.selection(
    string = "chain L and not (altloc A or altloc B)").iselection())

def exercise_15():
  """
  PDB file with MODEL-ENDMDL.
  """
  exc = None
  try:
    ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_12).construct_hierarchy())
    ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  except Exception as e:
    exc = e
  assert str(exc)=="Multi-model PDB (with MODEL-ENDMDL) is not supported."

def exercise_16():
  """
  PDB file with nucleic acids.
  """
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_13).construct_hierarchy().atom_selection_cache()
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_13).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  assert ncs_groups[0].master_iselection.all_eq(asc.selection(
    string = "chain A").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(asc.selection(
    string = "chain aA").iselection())

def exercise_17():
  """
  PDB file with ligands.
  """
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_14).construct_hierarchy().atom_selection_cache()
  p = ncs.input.get_default_params()
  p.ncs_search.exclude_selection=None
  ncs_inp = ncs.input(
      hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_14).construct_hierarchy(),
      params=p.ncs_search)
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  assert ncs_groups[0].master_iselection.all_eq(asc.selection(
    string = "chain A").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==2
  assert g1_c[0].iselection.all_eq(asc.selection(
    string = "chain B").iselection())
  assert g1_c[1].iselection.all_eq(asc.selection(
    string = "chain C").iselection())

def exercise_19():
  """
  PDB file with insertion codes, resseqs are different.
  """
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_16).construct_hierarchy().atom_selection_cache()
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_16).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  assert ncs_groups[0].master_iselection.all_eq(asc.selection(
    string = "chain H and not (altloc A or altloc B)").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(asc.selection(
    string = "chain L and not (altloc A or altloc B)").iselection())

def exercise_20():
  """
  Identical chains, too large rms difference. No NCS by default, use user
  siupplied NCS.
  """
  phil_str="""
ncs_group {
  reference = chain A
  selection = chain B
}
"""
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_17).construct_hierarchy().atom_selection_cache()
  ### user-supplied
  phil_groups = ncs_group_master_phil.fetch(
      iotbx.phil.parse(phil_str)).extract()
  ncs_inp = ncs.input(
      hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_17).construct_hierarchy(),
      ncs_phil_groups=phil_groups.ncs_group)
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  # group 1
  assert ncs_groups[0].master_iselection.all_eq(
    asc.selection(string = "chain A").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(
    asc.selection(string = "chain B").iselection())
  ### default
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_17).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==0

def exercise_21():
  """
  PDB file with blank chain ID and segID.
  XXX No support for segID in search procedure anymore.
  """
  # both chain ID blank. segID non-blank
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_18).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  # STOP()
  assert len(ncs_groups)==0 # it does not care about segID
  # blank and non-blank chain ID, non-blank segID
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_19).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_19).construct_hierarchy().atom_selection_cache()
  assert ncs_groups[0].master_iselection.all_eq(asc.selection(
    string = "chain ' '").iselection())
  g1_c = ncs_groups[0].copies
  assert len(g1_c)==1
  assert g1_c[0].iselection.all_eq(asc.selection(
    string = "chain 'A'").iselection()), list(g1_c[0].iselection)

def exercise_22():
  """
  PDB file with perfectly overlapping chains.
  """
  ncs_inp = ncs.input(hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_20).construct_hierarchy())
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  assert len(ncs_groups[0].copies)==3
  asc = iotbx.pdb.input(source_info=None,
    lines=pdb_str_20).construct_hierarchy().atom_selection_cache()
  assert ncs_groups[0].master_iselection.all_eq(asc.selection(
    string = "chain A").iselection())
  g1_c = ncs_groups[0].copies
  sel_1 = g1_c[0].iselection
  sel_1.extend(g1_c[1].iselection)
  sel_1.extend(g1_c[2].iselection)
  sel = asc.selection(
    string = "chain B or chain C or chain D").iselection()
  assert sel_1.all_eq(sel)

def exercise_23():
  """
  Case when reordering of chains (function update_chain_ids_search_order
  ncs_search.py) results in selections that doesn't match 'atom-by-atom'
  with each others.
  """
  pdb_inp = iotbx.pdb.input(source_info=None,lines=pdb_str_23.split('\n'))
  pdb_hierarchy = pdb_inp.construct_hierarchy()
  pdb_hierarchy = pdb_hierarchy.expand_to_p1(
    crystal_symmetry=pdb_inp.crystal_symmetry())
  pdb_hierarchy.write_pdb_file(file_name="m.pdb")
  pdb_hierarchy.atoms().reset_i_seq()
  ncs_inp = iotbx.ncs.input(hierarchy=pdb_hierarchy)
  # print dir(ncs_inp)
  # print ncs_inp.print_ncs_phil_param()
  # STOP()
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  phil_out = ncs_inp.show_phil_format()
  assert not show_diff(phil_out, """\

NCS phil parameters:
-----------------------
ncs_group {
  reference        = chain Aa or chain Ab or chain Ac
  selection        = chain Ad or chain Ae or chain Af
  selection        = chain Ag or chain Ah or chain Ai
  selection        = chain Aj or chain Ak or chain Al
  selection        = chain Am or chain An or chain Ao
  selection        = chain Ap or chain Aq or chain Ar
  selection        = chain As or chain At or chain Au
  selection        = chain Av or chain Aw or chain Ax
}""")

def exercise_24():
  """
  PDB file with another alternative conformations. Similar to exercise_14(),
  but the trick here is we have chain A and F split into two with the same chain IDs.
  Moreover, protein in chain F has single altloc B, and ligand in chain F has
  signle altloc 'A'. When combined, makes the resulting chain have
  altlocs while separately they dont.

  The result we are looking for is essentially skipping residue 128 and 201
  which are in AC in chain F.
  """

  p = ncs.input.get_default_params()
  p.ncs_search.residue_match_radius=5 # for residue 129 to be included

  ncs_inp = ncs.input(
      hierarchy=iotbx.pdb.input(source_info=None, lines=pdb_str_24).construct_hierarchy(),
      params=p.ncs_search)
  ncs_groups = ncs_inp.get_ncs_restraints_group_list()
  assert len(ncs_groups)==1
  # print(ncs_inp.show_phil_format())
  phil_out = ncs_inp.show_phil_format()
  assert not show_diff(phil_out, """\

NCS phil parameters:
-----------------------
ncs_group {
  reference = (chain 'A' and (resid 125 through 127 or resid 129 through 130))
  selection = (chain 'F' and (resid 125 through 127 or resid 129 through 130))
}""")

def clean_temp_files(file_list):
  """ delete files in the file_list """
  for fn in file_list:
    if os.path.isfile(fn): os.remove(fn)

if (__name__ == "__main__"):
  debug = ('debug' in sys.argv[1:])
  exercise_00(debug=debug)
  exercise_01(debug=debug)
  exercise_03()
  exercise_05()
  exercise_06()
  exercise_07()
  exercise_09()
  exercise_10()
  exercise_11()
  exercise_12()
  exercise_13()
  exercise_14()
  exercise_15()
  exercise_16()
  exercise_17()
  exercise_19()
  exercise_20()
  exercise_21() # No support for segID in search procedure anymore.
  exercise_22()
  # exercise_23() # Not grouping chains anymore. Test is left to illustrate
  # failure of update_chain_ids_search_order in this example
  exercise_24()
  print("OK")
