// Code generated by go generate; DO NOT EDIT.
package postgres

import "errors"

type Permission int

const (
    Invalid Permission = iota
    BypassRls Permission = iota
    Connect Permission = iota
    Create Permission = iota
    CreateDb Permission = iota
    CreateRole Permission = iota
    Delete Permission = iota
    InheritanceOfPrivs Permission = iota
    Insert Permission = iota
    Login Permission = iota
    References Permission = iota
    Replication Permission = iota
    Select Permission = iota
    Superuser Permission = iota
    Temp Permission = iota
    Trigger Permission = iota
    Truncate Permission = iota
    Update Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        BypassRls: "bypass_rls",
        Connect: "connect",
        Create: "create",
        CreateDb: "create_db",
        CreateRole: "create_role",
        Delete: "delete",
        InheritanceOfPrivs: "inheritance_of_privs",
        Insert: "insert",
        Login: "login",
        References: "references",
        Replication: "replication",
        Select: "select",
        Superuser: "superuser",
        Temp: "temp",
        Trigger: "trigger",
        Truncate: "truncate",
        Update: "update",
    }

    StringToPermission = map[string]Permission{
        "bypass_rls": BypassRls,
        "connect": Connect,
        "create": Create,
        "create_db": CreateDb,
        "create_role": CreateRole,
        "delete": Delete,
        "inheritance_of_privs": InheritanceOfPrivs,
        "insert": Insert,
        "login": Login,
        "references": References,
        "replication": Replication,
        "select": Select,
        "superuser": Superuser,
        "temp": Temp,
        "trigger": Trigger,
        "truncate": Truncate,
        "update": Update,
    }

    PermissionIDs = map[Permission]int{
        BypassRls: 1,
        Connect: 2,
        Create: 3,
        CreateDb: 4,
        CreateRole: 5,
        Delete: 6,
        InheritanceOfPrivs: 7,
        Insert: 8,
        Login: 9,
        References: 10,
        Replication: 11,
        Select: 12,
        Superuser: 13,
        Temp: 14,
        Trigger: 15,
        Truncate: 16,
        Update: 17,
    }

    IdToPermission = map[int]Permission{
        1: BypassRls,
        2: Connect,
        3: Create,
        4: CreateDb,
        5: CreateRole,
        6: Delete,
        7: InheritanceOfPrivs,
        8: Insert,
        9: Login,
        10: References,
        11: Replication,
        12: Select,
        13: Superuser,
        14: Temp,
        15: Trigger,
        16: Truncate,
        17: Update,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
