# 2020-08-03 Triage Log

See the [README](README.md) for details on how this log was gathered.

Triage done by [simulacrum](https://github.com/Mark-Simulacrum).
Revision range: [efc02b03d18b0cbaa55b1e421d792f70a39230b2..19cefa68640843956eedd86227ddc1d35dbc6754](https://perf.rust-lang.org/?start=efc02b03d18b0cbaa55b1e421d792f70a39230b2&end=19cefa68640843956eedd86227ddc1d35dbc6754&absolute=false&stat=instructions%3Au)

8 regressions, 2 improvements, 1 of them on rollups.
1 outstanding nag from last week.

Regressions
* [convert higher ranked `Predicate`s to `PredicateKind::ForAll` #73503](https://github.com/rust-lang/rust/pull/73503)
  ([instructions](https://perf.rust-lang.org/compare.html?start=efc02b03d18b0cbaa55b1e421d792f70a39230b2&end=76e83339bb619aba206e5590b1e4b813a154b199&stat=instructions%3Au))
  Up to 2.5% losses on stress tests, 1-2% on some other real-world crates. This
  was [expected](https://github.com/rust-lang/rust/pull/73503#issuecomment-661053865).
* [mv std libs to library/ #73265](https://github.com/rust-lang/rust/pull/73265#issuecomment-668254522)
  ([instructions](https://perf.rust-lang.org/compare.html?start=9be8ffcb0206fc1558069a7b4766090df7877659&end=ac48e62db85e6db4bbe026490381ab205f4a614d&stat=instructions%3Au))
  Up to 3% losses on tiny crates, and stress tests show 1-3% regressions.
* [Update cargo #74923](https://github.com/rust-lang/rust/pull/74923#issuecomment-668261346)
  ([instructions](https://perf.rust-lang.org/compare.html?start=efc02b03d18b0cbaa55b1e421d792f70a39230b2&end=76e83339bb619aba206e5590b1e4b813a154b199&stat=instructions%3Au))
  This was up to a 28% loss on some incremental benchmarks, as a result of
  regressions in proc macro performance (expansion is slower).
* [Replace all uses of `log::log_enabled` with `Debug` printers #74876](https://github.com/rust-lang/rust/pull/74876#issuecomment-668262178)
  ([instructions](https://perf.rust-lang.org/compare.html?start=6e50a225fd67576e43bab1d4dfa3c97f310786a8&end=1799d31847294d6e3816c17679247a5c206e809a&stat=instructions%3Au))
  A 1.5% regression on the ctfe stress test.
* [std: Switch from libbacktrace to gimli (take 2) #74682](https://github.com/rust-lang/rust/pull/74682#issuecomment-668264270)
  ([instructions](https://perf.rust-lang.org/compare.html?start=cfc572cae2d1fc381cce476b5c787fd7221af98c&end=c058a8b8dc5dea0ed9b33e14da9e317e2749fcd7&stat=instructions%3Au))
  An expected loss of up to 20% on smaller benchmarks. This was also a
  [max-rss](https://perf.rust-lang.org/compare.html?start=cfc572cae2d1fc381cce476b5c787fd7221af98c&end=c058a8b8dc5dea0ed9b33e14da9e317e2749fcd7&stat=max-rss)
  regression, though how big is difficult to determine as this statistics is
  noisy. See discussion on
  [Zulip](https://rust-lang.zulipchat.com/#narrow/stream/247081-t-compiler.2Fperformance/topic/gimli.20regressions).
  Optimistically, there is a follow-up PR, "metadata: track the simplified Self type for every trait impl
  #75008", which may [eliminate](https://github.com/rust-lang/rust/pull/75008#issuecomment-667577993) a good portion of these losses.
* [Normalize all opaque types when converting ParamEnv to Reveal::All #65989](https://github.com/rust-lang/rust/pull/65989#issuecomment-668267468)
  ([instructions](https://perf.rust-lang.org/compare.html?start=62f9aa94c0d0312544589bed78679d85646d4e62&end=6e87bacd37539b7e7cd75152dffd225047fa983a&stat=instructions%3Au))
  A slight performance regression, of up to 4%. Expected.
* [Move 'probably equal' methods to librustc_parse #75004](https://github.com/rust-lang/rust/pull/75004#issuecomment-668271907)
  ([instructions](https://perf.rust-lang.org/compare.html?start=8141873e6d50a0a0829fd756b0a16a92b27cfe22&end=46cf80dc1a75ad27f67e79f73fec371a16762494&stat=instructions%3Au))
  A 1% regression on some smaller crates, rustdoc-only.
* [Rollup of 10 pull requests #75060](https://perf.rust-lang.org/compare.html?start=e8876ae2c11f341565059b900eeae1254a9accf1&end=a99ae95c722d4dc8d1eef09aaa4e72d50d496e75&stat=instructions%3Au)
  ([instructions](https://perf.rust-lang.org/compare.html?start=e8876ae2c11f341565059b900eeae1254a9accf1&end=a99ae95c722d4dc8d1eef09aaa4e72d50d496e75&stat=instructions%3Au))
  Up to 1% regression; unclear cause -- possibly `BTreeMap` changes.

Improvements
* [Cache non-exhaustive separately from attributes #74887](https://github.com/rust-lang/rust/pull/74887#issuecomment-668258043)
  ([instructions](https://perf.rust-lang.org/compare.html?start=517385b31b0add8487ff3cc27e216cf3f867ab44&end=10c375700ce170fc57cb617754dc6d0631d3d573&stat=instructions%3Au))
  Up to 2% wins on tiny crates. This arose as an attempt to mitigate some of the
  effects of [re-landing gimli](https://github.com/rust-lang/rust/pull/74682).
* [Move from `log` to `tracing` #74726](https://github.com/rust-lang/rust/pull/74726#issuecomment-668269871)
  ([instructions](https://perf.rust-lang.org/compare.html?start=de10abf50c514ca648eb3bdcbc912d46b7eb32a6&end=05762e3d6f5facafdd47efdf4203021fadf61bb1&stat=instructions%3Au))
  Up to 1.5% wins, scattered across the smaller benchmarks. Expected.

Nags:
 * [Disable polymorphisation #74633](https://github.com/rust-lang/rust/pull/74633#issuecomment-668243225)
   From last week, this was a performance neutral PR even though the landing of
   polymorphisation was a regression. Investigation on why needs to be
   conducted.
